package dressing.handlers;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

import dressing.model.Caisson;
import dressing.model.ModelProvider;
import dressing.model.Project3D;
import dressing.ui.dressing.DressingWizard;
import dressing.model.Piece2D;
import dressing.model.Project3D;

public class CloseProjectHandler {

	@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute(Shell shell){
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o instanceof Project3D)
		{
			if(check())
			{
				Project3D child = (Project3D)o;
				ModelProvider.RootInstance().deleteProject(child);
			}

		}		
	}
	@CanExecute
	public boolean check()
	{
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o instanceof Project3D)
		{
			return true;
		}
		return false;
	}
}
