package gdxapp.object3d;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.math.Vector3;
import dressing.mathutils.Vector4;
import dressing.model.DesignObject3D;
import dressing.model.MechanicDesignCreator;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.ModelViewer;
import gdxapp.Commun.ScreenshotFactory;
import param.MechanicDesign;
import param.MechanicPublicParam;
import supercad.scene.object2d.KitchenElement2D;
import dressing.model.persistence.dpos.KitchenElementDPO;
import dressing.model.persistence.dpos.Object3D;
import dressing.model.persistence.mappers.Persistable;

@Persistable(persistableForm = KitchenElementDPO.class)
public class KitchenElement extends WorldObject {

	protected DesignObject3D designObject;
	private HashMap<String, DoorHandle> doorHandles;
	private Profile profile;
	private SceneTexture facadeTexture;
	private SceneTexture boxTexture;
	private SceneTexture backTexture;
	private String pathToFrontImage;
	private String pathToBackImage;

	public KitchenElement() {
		super();
		setType(ObjectType.DEFINED);
	}

	public void generateImages() {
		final KitchenElement element = this;
		final Vector3 dimensions = new Vector3(realWorldDimension.x, realWorldDimension.y, realWorldDimension.z);
		ModelViewer modelViewer = new ModelViewer(720, 1);
		Pixmap front = modelViewer.render(element, dimensions.cpy().scl(1.2f, Math.min(1.2f, 2 / dimensions.y), 2));
		Pixmap back = modelViewer.render(element, dimensions.cpy().scl(1.2f, Math.min(1.2f, 2 / dimensions.y), -2));
		modelViewer.dispose();
		String projectDirPath = ProjectManager.getManager().getCurrentProjectDirectory();
		String backPath = projectDirPath + File.separator + "reporting" + File.separator + sceneID + "_back.png";
		String frontPath = projectDirPath + File.separator + "reporting" + File.separator + sceneID + "_front.png";
		File file = new File(backPath);
		try {
			file.getParentFile().mkdirs();
			file.createNewFile();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ScreenshotFactory.savePixmapAsPng(back, backPath);
		element.setPathToBackImage(file.toURI().toString());

		file = new File(frontPath);
		try {
			file.createNewFile();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		ScreenshotFactory.savePixmapAsPng(front, frontPath);
		element.setPathToFrontImage(file.toURI().toString());

	}

	public String getPathToFrontImage() {
		return pathToFrontImage;
	}

	public void setPathToFrontImage(String pathToFrontImage) {
		this.pathToFrontImage = pathToFrontImage;
	}

	public String getPathToBackImage() {
		return pathToBackImage;
	}

	public void setPathToBackImage(String pathToBackImage) {
		this.pathToBackImage = pathToBackImage;
	}

	@Override
	public KitchenElement clone() {
		KitchenElement clone = new KitchenElement();
		clone.setRealWorldDimension(getRealWorldDimension());
		clone.setRealWorldPosition(getRealWorldPosition());
		clone.setModel(this.getModel());
		clone.setFacadeTexture(getFacadeTexture());
		clone.setBoxTexture(getBoxTexture());
		clone.setUuid(getUuid());
		clone.setSceneId(getSceneId());
		clone.setDesignObject(getDesignObject());
		return clone;
	}

	public float getActiveDepth() {
		float depth = Float.NaN;
		if (activeWidth) {
			if (designObject != null) {
				MechanicPublicParam param;
				try {
					param = getMechanicDesign().getPublicParam("global.l");
					depth = Float.valueOf(param.getDefaultvalue()) * 0.001f;
				} catch (Exception e) {
					depth = Float.NaN;
				}
			} else {
				depth = realWorldDimension.z;
			}
		} else {
			depth = realWorldDimension.z;
		}
		return depth;
	}

	public Vector4 getObjectDimention() {
		if (realWorldDimension == null)
			realWorldDimension = new Vector4();
		if (getType().equals(ObjectType.DEFINED) && getMechanicDesign() != null && getDesignObject() != null) {
			try {
				MechanicPublicParam paramL = getMechanicDesign().getPublicParam("global.l");
				if (paramL != null) {
					String l = paramL.getDefaultvalue();
					realWorldDimension.x = Integer.valueOf(l) / 1000.0f;
				}
				MechanicPublicParam paramH = getMechanicDesign().getPublicParam("global.h");
				if (paramH != null) {
					String h = paramH.getDefaultvalue();
					realWorldDimension.y = Integer.valueOf(h) / 1000.0f;
				}
				MechanicPublicParam paramP = getMechanicDesign().getPublicParam("global.p");
				if (paramP != null) {
					String p = paramP.getDefaultvalue();
					realWorldDimension.z = Integer.valueOf(p) / 1000.0f;
					var facadeRetourParam = getMechanicDesign().getPublicParam("facade.retourL");
					if (facadeRetourParam != null) {
						int value = Integer.valueOf(facadeRetourParam.getDefaultvalue());
						realWorldDimension.z += value * 0.001f;
					}

				}
				MechanicPublicParam paramlargeur = getMechanicDesign().getPublicParam("global.largeur");
				if (paramlargeur != null) {
					String largeur = paramlargeur.getDefaultvalue();
					realWorldDimension.w = Integer.valueOf(largeur) / 1000.0f;
				}

			} catch (Exception e) {

				e.printStackTrace();

			}
		}
		return realWorldDimension.cpy();

	}

	@Override
	public Object3D toDPO() {
		return new Object3D(this);
	}

	public MechanicDesign getMechanicDesign() {
		return getDesignObject().getMechanicDesignDefinition();
	}

	public DesignObject3D getDesignObject() {
		if (designObject == null)
			designObject = ProjectManager.getManager().getCurrentKitchen().getElement(this.uuid);
		return designObject;
	}

	public void setDesignObject(DesignObject3D designObject) {
		this.designObject = designObject;
	}

	public SceneTexture getFacadeTexture() {
		if (facadeTexture == null) {
			facadeTexture = ProjectManager.getManager().getCurrentScene().getPreferences().getFacadeTexture();
		}
		return facadeTexture;
	}

	public void setFacadeTexture(SceneTexture facadeTexture) {
		this.facadeTexture = facadeTexture;
	}

	public SceneTexture getBoxTexture() {
		if (boxTexture == null) {
			boxTexture = ProjectManager.getManager().getCurrentScene().getPreferences().getBoxTexture();
		}
		return boxTexture;
	}

	public void setBoxTexture(SceneTexture boxTexture) {
		this.boxTexture = boxTexture;
	}

	public SceneTexture getBackTexture() {
		if (backTexture == null)
			backTexture = ProjectManager.getManager().getCurrentScene().getPreferences().getBackTexture();
		return backTexture;
	}

	public void setBackTexture(SceneTexture backTexture) {
		this.backTexture = backTexture;
	}

	public int getDesignObjectSceneIndex() {

		if (designObject.isFausseFacade()) {
			return ProjectManager.getManager().getCurrentKitchen().getElementsFausseFacades().indexOf(designObject) + 1;

		} else {
			return ProjectManager.getManager().getCurrentKitchen().getElementsWithoutFausseFacades()
					.indexOf(designObject) + 1;
		}
	}

	@Override
	public KitchenElement2D create2DObject() {
		return new KitchenElement2D(this);
	}

	@Override
	public KitchenElement copy() {
		KitchenElement copy = new KitchenElement();
		DesignObject3D designObject3D = null;
		try {
			designObject3D = MechanicDesignCreator.getInstance().constructObject(ModelProvider.getModelroot(), null,
					null, copy.getMechanicDesign(), MechanicDesignCreator.create, false);
			copy.setDesignObject(designObject3D);
		} catch (Exception e) {
			// TODO: handle exception
		}
		copy.setRealWorldDimension(getRealWorldDimension().cpy());
		copy.setRealWorldPosition(getRealWorldPosition().cpy());
		copy.setFacadeTexture(getFacadeTexture().clone());
		copy.setBoxTexture(getBoxTexture().clone());
		copy.setBackTexture(getBackTexture().clone());
		copy.setProperties((Properties) getProperties().clone());
		return copy;
	}
	
	
	public DoorHandle getDoorHandle(String facadeName) {
		if(doorHandles == null)
			return null;
		return doorHandles.get(facadeName);
	}

	public void putDoorHandle(String pieceName, DoorHandle doorHandle) {
		if(this.doorHandles == null)
			this.doorHandles = new HashMap<String, DoorHandle>();
		this.doorHandles.put(pieceName, doorHandle);
	}
	
	

	public HashMap<String, DoorHandle> getDoorHandles() {
		return doorHandles;
	}

	public void setDoorHandles(HashMap<String, DoorHandle> doorHandles) {
		this.doorHandles = doorHandles;
	}
	
	

	public Profile getProfile() {
		return profile;
	}

	public void setProfile(Profile profile) {
		this.profile = profile;
	}

	@Override
	public String getName() {
		return designObject.getName();
	}
	
}
