package gdxapp.Commun;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap.Format;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.PixmapIO.PNG;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ScreenUtils;

import dressing.config.WorkspaceConfiguration;
import dressing.model.ProjectManager;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ScreenshotFactory {


    private static int	counter	= 1;
    
    
    public static void savePixmapAsPng(Pixmap pixmap, String path) {
    	FileHandle fh = new FileHandle(path);
    	if(fh.exists()) {
             PixmapIO.writePNG(fh, pixmap);
             pixmap.dispose();
             Gdx.app.log("screenshot", "Screenshot saved to " + fh);
    	}else {
    		System.err.println(path + " doesn t exist");
    	}
    }

    public static void saveScreenshot(final int w, final int h, final String prefix)
    {
        try
        {
            FileHandle fh;
            do
            {
                if (Gdx.app.getType() == Application.ApplicationType.Desktop)
                {
                    fh = Gdx.files.local("bin/screenshot_" + prefix + "_" + counter++ + ".png");
                }
                else
                {
                    fh = Gdx.files.local("screenshot_" + prefix + "_" + counter++ + ".png");
                }
            }
            while (fh.exists());
            final Pixmap pixmap = getScreenshot(0, 0, w, h, true);
            PixmapIO.writePNG(fh, pixmap);
            pixmap.dispose();
            Gdx.app.debug("screenshot", "Screenshot saved to " + fh);

        }
        catch (final Exception e)
        {
        }
    }
    
    public static void saveCapture(final int w, final int h, int targetWidth, final String path)
    {
        try
        {
        	float aspectRatio = h/(w + 0.00001f);
            FileHandle fh = Gdx.files.absolute(path);
            int frameBufferWidth =  Gdx.graphics.getWidth();
            int frameBufferHeight = Gdx.graphics.getHeight();
            int xStart = (frameBufferWidth - w)/2;
            int yStart = (frameBufferHeight - h)/2;
            final Pixmap pixmap = getScreenshot(xStart, yStart, Math.min(frameBufferWidth - xStart , w) , Math.min(frameBufferHeight - yStart, w), true);
            int targetHeight = Math.round(targetWidth * aspectRatio);
            
            Pixmap scaled = new Pixmap(targetWidth, targetHeight, pixmap.getFormat());
            scaled.drawPixmap(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, targetWidth, targetHeight);
            PixmapIO.writePNG(fh, scaled);
            pixmap.dispose();
            scaled.dispose();
            Gdx.app.log("screenshot", "Screenshot saved to " + fh);
        }
        catch (final Exception e)
        {
        }
    }

    public static void saveScreen(final int w, final int h, final String prefix)
    {
    	
        try
        {
            FileHandle fh;
//            do
//            {
               fh = new FileHandle(new File("" + File.separator + prefix));
//            }
//            while (fh.exists());
            final Pixmap pixmap = getScreenshot(0, 0, w, h, false);
//            PixmapIO.writePNG(fh, pixmap);
            try {
    			PNG writer = new PNG((int)(pixmap.getWidth() * pixmap.getHeight() * 1.5f)); // Guess at deflated size.
    			try {
    				writer.setFlipY(true);
    				writer.write(fh, pixmap);
    			} finally {
    				writer.dispose();
    			}
    		} catch (IOException ex) {
    			throw new GdxRuntimeException("Error writing PNG: " + fh, ex);
    		}
            pixmap.dispose();
            Gdx.app.log("screenshot", "Screenshot saved to " + fh);

        }
        catch (final Exception e)
        {
        }
    }
    public static Pixmap getScreenshot(final int x, final int y, final int w, final int h, final boolean yDown)
    {

        final Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(x, y, w, h);

        if (yDown)
        {
            // Flip the pixmap upside down
            final ByteBuffer pixels = pixmap.getPixels();
            final int numBytes = w * h * 4;
            final byte[] lines = new byte[numBytes];
            final int numBytesPerLine = w * 4;
            for (int i = 0; i < h; i++)
            {
                pixels.position((h - i - 1) * numBytesPerLine);
                pixels.get(lines, i * numBytesPerLine, numBytesPerLine);
            }
            pixels.clear();
            pixels.put(lines);
        }

        return pixmap;
    }
}
