package dressing.ui.stock;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

import dressing.model.stock.Article;
import dressing.model.stock.ModelAccessoire;
import dressing.model.stock.ModelQuincaillerie;
import dressing.ui.util.MesureWidow;

import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.wb.swt.SWTResourceManager;

public class AccessoiresListEditor {

	protected Shell shell;
	private Table table;
	List<Article> articles=new ArrayList<Article>();
	private TableViewer tableViewer;
	/**
	 * Launch the application.
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			AccessoiresListEditor window = new AccessoiresListEditor();
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Open the window.
	 */
	public void open() {
		Display display = Display.getDefault();
		createContents();
		shell.setText("Liste des Accessoires et Quincailleries");
		
		shell.open();
		shell.layout();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

	/**
	 * Create contents of the window.
	 */
	protected void createContents() {
		shell = new Shell();
		shell.setSize(652, 361);
		shell.setText("Liste des Accessoires et Quincailleries");
		
		ScrolledComposite scrolledComposite = new ScrolledComposite(shell, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
		scrolledComposite.setBounds(0, 0, 636, 312);
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);
		
		tableViewer = new TableViewer(scrolledComposite, SWT.FULL_SELECTION);
		tableViewer.setUseHashlookup(true);
		table = tableViewer.getTable();
		table.setHeaderBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		tableViewer.setContentProvider(ArrayContentProvider.getInstance());

		TableViewerColumn tableViewerColumnNom = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnNom.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Article) {
					return ((Article) element).getName();
				}else {
					return "";
				}
			}
		});
		TableColumn tblclmnNom = tableViewerColumnNom.getColumn();
		tblclmnNom.setWidth(100);
		tblclmnNom.setText("Nom");
		
		TableViewerColumn tableViewerColumnCode = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnCode = tableViewerColumnCode.getColumn();
		tblclmnCode.setWidth(100);
		tblclmnCode.setText("Code");
		tableViewerColumnCode.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Article) {
					if(element instanceof ModelAccessoire) {
						if(((ModelAccessoire) element).getAccessoire()!=null && ((ModelAccessoire) element).getAccessoire().getAccessoire()!=null)
						{
							return  ((ModelAccessoire) element).getAccessoire().getAccessoire().getCode();
						}
					}else if(element instanceof ModelQuincaillerie) {
						if( ((ModelQuincaillerie) element).getQuincaillerie()!=null &&  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie()!=null)
						{
							return  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie().getCode();
						}
					}
				}
				return "";
				
			}
		});
		TableViewerColumn tableViewerColumnNumber = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnNumber.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Article) {
					return String.valueOf(((Article) element).getNumber());
				}else {
					return "";
				}
			}
		});
		TableColumn tblclmnNombre = tableViewerColumnNumber.getColumn();
		tblclmnNombre.setWidth(100);
		tblclmnNombre.setText("Nombre");
		
		TableViewerColumn tableViewerColumnFamille = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnFamille = tableViewerColumnFamille.getColumn();
		tblclmnFamille.setWidth(100);
		tblclmnFamille.setText("Famille");
		tableViewerColumnFamille.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Article) {
					if(element instanceof ModelAccessoire) {
						if(((ModelAccessoire) element).getAccessoire()!=null && ((ModelAccessoire) element).getAccessoire().getAccessoire()!=null
								&& ((ModelAccessoire) element).getAccessoire().getAccessoire().getParentFamily()!=null)
						{
							return  ((ModelAccessoire) element).getAccessoire().getAccessoire().getParentFamily().getName();
						}
					}else if(element instanceof ModelQuincaillerie) {
						if( ((ModelQuincaillerie) element).getQuincaillerie()!=null &&  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie()!=null
								&&  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie().getParentFamily()!=null)
						{
							return  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie().getParentFamily().getName();
						}
					}
				}
				return "";
				
			}
		});
		TableViewerColumn tableViewerColumnPrix = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnPrix = tableViewerColumnPrix.getColumn();
		tblclmnPrix.setWidth(100);
		tblclmnPrix.setText("Prix");
		tableViewerColumnPrix.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Article) {
					if(element instanceof ModelAccessoire) {
						if(((ModelAccessoire) element).getAccessoire()!=null && ((ModelAccessoire) element).getAccessoire().getAccessoire()!=null)
						{
							return  ((ModelAccessoire) element).getAccessoire().getAccessoire().getPrix()*((ModelAccessoire) element).getNumber()+"";
						}
					}else if(element instanceof ModelQuincaillerie) {
						if( ((ModelQuincaillerie) element).getQuincaillerie()!=null &&  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie()!=null)
						{
							return  ((ModelQuincaillerie) element).getQuincaillerie().getQuincaillerie().getPrix()*((ModelQuincaillerie) element).getNumber()+"";
						}
					}
				}
				return "";
			}
		});
		TableViewerColumn tableViewerColumnType = new TableViewerColumn(tableViewer, SWT.NONE);
		tableViewerColumnType.setLabelProvider(new ColumnLabelProvider() {
			public Image getImage(Object element) {
				// TODO Auto-generated method stub
				return null;
			}
			public String getText(Object element) {
				if(element !=null && element instanceof Article) {
					return element instanceof ModelAccessoire? "Accessoire":"Quincaillerie";
				}else {
					return "";
				}
			}
		});
		TableColumn tblclmnType = tableViewerColumnType.getColumn();
		tblclmnType.setMoveable(true);
		tblclmnType.setWidth(100);
		tblclmnType.setText("Type");
		scrolledComposite.setContent(table);
		scrolledComposite.setMinSize(table.computeSize(SWT.DEFAULT, SWT.DEFAULT));
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				Rectangle area1 = AccessoiresListEditor.this.getShell().getClientArea();
				scrolledComposite.setBounds(area1);
				Rectangle area2 = scrolledComposite.getClientArea();
				int width = area2.width;

				Point oldSize = table.getSize();
				if (oldSize.x > area2.width) {
					// table is getting smaller so make the columns
					// smaller first and then resize the table to
					// match the client area width
					int columnWidth = (width) / 6;
					tblclmnNom.setWidth(columnWidth);
					tblclmnNombre.setWidth(columnWidth);
					tblclmnType.setWidth(columnWidth);
					tblclmnCode.setWidth(columnWidth);
					tblclmnPrix.setWidth(columnWidth);
					tblclmnFamille.setWidth(columnWidth);
					table.setSize(area2.width, area2.height);
				} else {
					// table is getting bigger so make the table
					// bigger first and then make the columns wider
					// to match the client area width
					int columnWidth = (width) / 6;
					table.setSize(area2.width, area2.height);
					tblclmnNom.setWidth(columnWidth);
					tblclmnNombre.setWidth(columnWidth);
					tblclmnType.setWidth(columnWidth);
					tblclmnCode.setWidth(columnWidth);
					tblclmnPrix.setWidth(columnWidth);
					tblclmnFamille.setWidth(columnWidth);
				}
			}
			
		};
		table.setSortColumn(tblclmnType);
		tableViewer.setComparator(new ViewerComparator());
		tableViewer.setInput(articles);
		getShell().addControlListener(adaptor);
	}

	public Shell getShell() {
		return shell;
	}

	public void setShell(Shell shell) {
		this.shell = shell;
	}

	public Table getTable() {
		return table;
	}

	public void setTable(Table table) {
		this.table = table;
	}

	public List<Article> getArticles() {
		return articles;
	}

	public void setArticles(List<Article> articles) {
		this.articles = articles;
//		tableViewer.setInput(articles);
//		tableViewer.refresh();
	}
	
}
