package dressing.ui.separator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;

public class SeparatorWelcomePage extends WizardPage{

	Piece2DCreator piece ;
	PropertyChangeListener pcl;
	PropertyChangeListener pcl2;
	boolean errorfound=false;
	protected SeparatorWelcomePage(String pageName,Piece2DCreator piece) {
		super(pageName);
		this.piece = piece;
		setTitle("Créer un nouveau separateur");
		setDescription("Veuillez renseigner les propriétés de votre separateur");		
		// TODO Auto-generated constructor stub
	}


	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		SeparatorCompositeWizard compo1 = new SeparatorCompositeWizard(parent, SWT.NONE,piece);
		setControl(compo1);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {				
						if(piece.isSepratortransversal())
						{
							piece.setPiecetype(PieceType.SEPRATEUR_TRANSVERSANT);
						}
						else
						{
							piece.setPiecetype(PieceType.SEPRATEUR_NORMAL);
						}
						piece.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre separateur", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		//ajouter un propertychangelistener pour override le seppostion lorsque choisire separator isometrique
		pcl2 =new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(evt.getPropertyName().equals("isSepIsometrique")
						&& evt.getSource().getClass().equals(Piece2DCreator.class)
						&& ((Piece2DCreator)evt.getSource()).getPiece2DInstance()!=null
						&&((Piece2DCreator)evt.getSource()).getPiece2DInstance().getClass().equals(Separator.class)) {
					
						if(evt.getNewValue().equals(false)) {
							if(piece.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
								piece.setSeparationposition((piece.getParent().getHauteurint()-piece.getMaterial().getEpaisseur())/2);
							}else if (piece.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
								piece.setSeparationposition((piece.getParent().getLongeurint()-piece.getMaterial().getEpaisseur())/2);
							} else if (piece.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
								piece.setSeparationposition((piece.getParent().getProfondeurint()-piece.getMaterial().getEpaisseur())/2);
							} 
						}						
						if(evt.getNewValue().equals(true)) {
							piece.setSeparationposition(50);
						}
						//
						if(evt.getOldValue().equals(false)&& evt.getNewValue().equals(true)) {
							piece.setPositionCalculationType(PositionCalculationType.POURCENT);
						}
						if(evt.getOldValue().equals(true)&& evt.getNewValue().equals(false)) {
							piece.setPositionCalculationType(PositionCalculationType.FIX);
						}
					}
//				if(evt.getPropertyName().equals("seprationaxe")){
//					if(!piece.getIsSepIsometrique()) {
//						if(piece.getSeprationaxe().equals(SeprationAxe.YAXIS)) {
//							piece.setSeparationposition((piece.getParent().getHauteurint()-piece.getMaterial().getEpaisseur())/2);
//						}else if (piece.getSeprationaxe().equals(SeprationAxe.XAXIS)) {
//							piece.setSeparationposition((piece.getParent().getLongeurint()-piece.getMaterial().getEpaisseur())/2);
//						} else if (piece.getSeprationaxe().equals(SeprationAxe.ZAXIS)) {
//							piece.setSeparationposition((piece.getParent().getProfondeurint()-piece.getMaterial().getEpaisseur())/2);
//						} 
//					}
//				}
				}
		};
		piece.addPropertyChangeListener(pcl);
		piece.addPropertyChangeListener(pcl2);
	}
@Override
public boolean isPageComplete() {
	// TODO Auto-generated method stub
	boolean b = !errorfound;
	return b;
}
public void clearlistners() {
	piece.removePropertyChangeListener(pcl);
	piece.removePropertyChangeListener(pcl2);

}
}
