package dressing.ui.project;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;
import dressing.controller.ProjectCreator;
import dressing.controller.ProjectCreator.CornerType;
import dressing.model.ModelProvider;
import dressing.ui.util.SingleImageItemLabelProvider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;

public class CreateKitchenComposite extends Composite{
	
	private DataBindingContext m_bindingContext;
	PropertyChangeListener listener;
	private Spinner spinner_h;
	private Spinner spinner_w;
	private TableComboViewer tableComboViewer;
	private TableComboViewer tableComboViewer_1;
	private TableComboViewer tableComboVwr_facademat;

	private Object backMaterial;
	private Object primaryMaterial;
	private ProjectCreator creator;
	private Button btnNorthWall;
	private Button btnSouthWall;
	private Button btnWestWall;
	private Button btnEastWall;
	private Composite compositeKitchenDraw;
	KitchenDraw2D kitchendraw;
	private Spinner spnNorthwestL;
	private Spinner spnNorthEastL;
	private Spinner spnNorthwestH;
	private Spinner spnNorthEastH;
	private Spinner spnSouthWestH;
	private Spinner spnSouthEastH;
	private Spinner spnSouthWestL;
	private Spinner spnSouthEastL;
	private Combo combo;
	private ComboViewer comboViewerNorthEastCorner;
	private Combo combo_1;
	private ComboViewer comboViewerNorthWestCorner;
	private Combo combo_2;
	private ComboViewer comboViewerSouthWestCorner;
	private Combo combo_3;
	private ComboViewer comboViewerSouthEastCorner;
	
	byte edgeSelection = 0;
	float[] cornerParameters = new float[] {0,0,0, 0,0,0, 0,0,0 ,0,0,0};
	
	
	public CreateKitchenComposite(Composite parent, int style,ProjectCreator creator) {
		super(parent, style);
		this.creator=creator;
		
		getShell().setSize(700, 600);
		getShell().setLocation(getDisplay().getBounds().width/2-350, getDisplay().getBounds().height/2-300);
		setLayout(new GridLayout(2, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		composite.setLayout(new FillLayout(SWT.VERTICAL));
		
		Group grpGroup = new Group(composite, SWT.NONE);
		grpGroup.setText("Dimensions");
		grpGroup.setLayout(new GridLayout(2, false));
		FormData fd_text = new FormData();
		fd_text.right = new FormAttachment(100, -50);
		
		Label lblLongueur = new Label(grpGroup, SWT.NONE);
		lblLongueur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblLongueur.setText("Longeur");
		
		spinner_w = new Spinner(grpGroup, SWT.BORDER);
		spinner_w.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_w.setMaximum(10000);
		spinner_w.setMinimum(1);
		spinner_w.setSelection(Math.round(creator.getKitchenShapeBuilder().getWidth()));
		spinner_w.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				int value =  spinner_w.getSelection();
				creator.getKitchenShapeBuilder().setWidth(value);
				
			}
		});
		
		Label lblLargeur = new Label(grpGroup, SWT.NONE);
		lblLargeur.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		lblLargeur.setText("Largeur");
		
		spinner_h = new Spinner(grpGroup, SWT.BORDER);
		spinner_h.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		spinner_h.setMaximum(10000);
		spinner_h.setMinimum(1);
		spinner_h.setSelection(Math.round(creator.getKitchenShapeBuilder().getHeight()));
		spinner_h.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				int value = spinner_h.getSelection();
				creator.getKitchenShapeBuilder().setHeight(value);
			}
		});
		
		Composite composite_1 = new Composite(this, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
		composite_1.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		Group grpGroup_1 = new Group(composite_1, SWT.NONE);
		grpGroup_1.setText("Modèle(Materiaux MDF du Coupe)");
		grpGroup_1.setLayout(new GridLayout(2, false));
		
		Label lblMateriau = new Label(grpGroup_1, SWT.NONE);
		lblMateriau.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMateriau.setText("Caisson");
		
		tableComboViewer = new TableComboViewer(grpGroup_1, SWT.NONE);
		TableCombo tableCombo = tableComboViewer.getTableCombo();
		tableCombo.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo.defineColumns(new String[] {"Texture", "Epaisseur"});
		tableCombo.setDisplayColumnIndex(0);
		tableCombo.setEditable(false);
		tableComboViewer.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewer.setLabelProvider(new SingleImageItemLabelProvider(this));
		tableComboViewer.setInput(ModelProvider.getMateriallist());
		
		//
		Label lblMateriauface = new Label(grpGroup_1, SWT.NONE);
		lblMateriauface.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMateriauface.setText("Façade");
		
		tableComboVwr_facademat = new TableComboViewer(grpGroup_1, SWT.NONE);
		TableCombo tableCombo_matface = tableComboVwr_facademat.getTableCombo();
		tableCombo_matface.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		tableCombo_matface.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_matface.defineColumns(new String[] {"Texture", "Epaisseur"});
		tableCombo_matface.setDisplayColumnIndex(0);
		tableCombo_matface.setEditable(false);
		tableComboVwr_facademat.setContentProvider(ArrayContentProvider.getInstance());
		tableComboVwr_facademat.setLabelProvider(new SingleImageItemLabelProvider(this));
		tableComboVwr_facademat.setInput(ModelProvider.getMateriallist());
		//
		Label lblMatrielDeDos = new Label(grpGroup_1, SWT.NONE);
		lblMatrielDeDos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblMatrielDeDos.setText("Fond");
		
		tableComboViewer_1 = new TableComboViewer(grpGroup_1, SWT.NONE);
		TableCombo tableCombo_1 = tableComboViewer_1.getTableCombo();
		tableCombo_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		tableCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableCombo_1.defineColumns(new String[] {"Texture", "Epaisseur"});
		tableCombo_1.setDisplayColumnIndex(0);
		tableCombo_1.setEditable(false);
		tableComboViewer_1.setContentProvider(ArrayContentProvider.getInstance());
		tableComboViewer_1.setLabelProvider(new SingleImageItemLabelProvider(this));
		
		Composite composite_2 = new Composite(this, SWT.NONE);
		composite_2.setLayout(new GridLayout(5, false));
		composite_2.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		
		comboViewerNorthWestCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_1 = comboViewerNorthWestCorner.getCombo();
		combo_1.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType)comboViewerNorthWestCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 0);
			}
		});
		combo_1.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		comboViewerNorthWestCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerNorthWestCorner.setLabelProvider(new LabelProvider());
		comboViewerNorthWestCorner.setInput(CornerType.values());
		spnNorthwestL = new Spinner(composite_2, SWT.BORDER);
		spnNorthwestL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnNorthwestL.getSelection() * 0.001f;
				setCornerParameter(1, value);
			}
		});
		spnNorthwestL.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		spnNorthwestL.setMaximum(100000000);

		btnNorthWall = new Button(composite_2, SWT.CHECK);
		btnNorthWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(0, btnNorthWall.getSelection());
			}
		});
		btnNorthWall.setLayoutData(new GridData(SWT.CENTER, SWT.TOP, false, false, 1, 1));
		
		spnNorthEastL = new Spinner(composite_2, SWT.BORDER);
		spnNorthEastL.setMaximum(100000);
		spnNorthEastL.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		spnNorthEastL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnNorthEastL.getSelection() * 0.001f;
				setCornerParameter(3, value);
			}
		});
		
		
		comboViewerNorthEastCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo = comboViewerNorthEastCorner.getCombo();
		combo.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType)comboViewerNorthWestCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 3);
			}
		});
		combo.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		comboViewerNorthEastCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerNorthEastCorner.setLabelProvider(new LabelProvider());
		comboViewerNorthEastCorner.setInput(CornerType.values());
		spnNorthwestH = new Spinner(composite_2, SWT.BORDER);
		spnNorthwestH.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				 float value = spnNorthwestH.getSelection() * 0.001f;
				 setCornerParameter(0, value);
			}
		});
		spnNorthwestH.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, false, false, 1, 1));
		spnNorthwestH.setMaximum(100000000);
		compositeKitchenDraw = new Composite(composite_2, SWT.NONE);
		compositeKitchenDraw.setLayout(new FillLayout(SWT.HORIZONTAL));
		compositeKitchenDraw.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 3, 3));
		kitchendraw=new KitchenDraw2D(compositeKitchenDraw, SWT.NONE,this.creator.getKitchenShapeBuilder());
		kitchendraw.setLayout(new FillLayout(SWT.HORIZONTAL));
		
		spnNorthEastH = new Spinner(composite_2, SWT.BORDER | SWT.WRAP);
		spnNorthEastH.setLayoutData(new GridData(SWT.RIGHT, SWT.TOP, false, false, 1, 1));
		spnNorthEastH.setMaximum(100000000);
		spnNorthEastH.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				float value = spnNorthEastH.getSelection() * 0.001f;
				setCornerParameter(4, value);	
			}
		});
		
		
		btnWestWall = new Button(composite_2, SWT.CHECK);
		btnWestWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(3, btnWestWall.getSelection());
			}
		});
		btnWestWall.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, true, 1, 1));

		btnEastWall = new Button(composite_2, SWT.CHECK);
		btnEastWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(1, btnEastWall.getSelection());
			}
		});
		btnEastWall.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, false, true, 1, 1));
		
		spnSouthWestH = new Spinner(composite_2, SWT.BORDER);
		spnSouthWestH.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthWestH.getSelection() * 0.001f;
				setCornerParameter(10, value);	
			}
		});
		spnSouthWestH.setMaximum(100000000);
		spnSouthWestH.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));

		spnSouthEastH = new Spinner(composite_2, SWT.BORDER | SWT.WRAP);
		spnSouthEastH.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthEastH.getSelection() * 0.001f;
				setCornerParameter(6, value);	
			}
		});
		spnSouthEastH.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		spnSouthEastH.setMaximum(100000000);
		
		comboViewerSouthWestCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_2 = comboViewerSouthWestCorner.getCombo();
		combo_2.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType) comboViewerSouthWestCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 9);
			}
		});
		combo_2.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));
		
		comboViewerSouthWestCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerSouthWestCorner.setLabelProvider(new LabelProvider());
		comboViewerSouthWestCorner.setInput(CornerType.values());
		
		spnSouthWestL = new Spinner(composite_2, SWT.BORDER);
		spnSouthWestL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthWestL.getSelection() * 0.001f;
				setCornerParameter(9, value);
			}
		});
		spnSouthWestL.setLayoutData(new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1));
		spnSouthWestL.setMaximum(100000000);

		btnSouthWall = new Button(composite_2, SWT.CHECK);
		btnSouthWall.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setEdgeSelection(2, btnSouthWall.getSelection());
			}
		});
		btnSouthWall.setLayoutData(new GridData(SWT.CENTER, SWT.BOTTOM, true, false, 1, 1));
		
		spnSouthEastL = new Spinner(composite_2, SWT.BORDER);
		spnSouthEastL.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				float value = spnSouthEastL.getSelection() * 0.001f;
				setCornerParameter(7, value);
			}
		});
		spnSouthEastL.setMaximum(100000000);
		spnSouthEastL.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		
		comboViewerSouthEastCorner = new ComboViewer(composite_2, SWT.READ_ONLY);
		combo_3 = comboViewerSouthEastCorner.getCombo();
		combo_3.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				CornerType selection = (CornerType) comboViewerSouthEastCorner.getStructuredSelection().getFirstElement();
				setCornerType(selection, 6);
			}
		});
		combo_3.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, false, false, 1, 1));
		comboViewerSouthEastCorner.setContentProvider(ArrayContentProvider.getInstance());
		comboViewerSouthEastCorner.setLabelProvider(new LabelProvider());
		comboViewerSouthEastCorner.setInput(CornerType.values());
		
		tableComboViewer_1.setInput(ModelProvider.getMateriallist());
		listener=new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				
			}
		};
		if(this.creator != null) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			m_bindingContext = initDataBindings();
//			this.creator.addPropertyChangeListener(listener);
		}

	}
	protected void setCornerType(CornerType selection, int offset) {
		switch (selection) {
		case Rectancle:
			cornerParameters[offset + 2] = 1;
			break;
		case Angle:
			cornerParameters[offset + 2] = 0;
			break;
		case None:
			cornerParameters[offset] = 0;
			cornerParameters[offset + 1] = 0;
			cornerParameters[offset + 2] = 0;
			break;
		default:
			throw new IllegalArgumentException("Unexpected value: " + selection);
		}		
		creator.getKitchenShapeBuilder().setMiddlePoint(cornerParameters);

	}
	protected void setCornerParameter(int index, float value) {
		this.cornerParameters[index] = value;
		creator.getKitchenShapeBuilder().setMiddlePoint(cornerParameters);

	}
	protected void setEdgeSelection(int i, boolean selection) {
		int mask = 1 << i;
		if(selection) {
			this.edgeSelection |= mask;
		}else {
			this.edgeSelection &= ~mask;
		}
		creator.getKitchenShapeBuilder().setEdges(edgeSelection);
	}
	public ProjectCreator getCreator() {
		return creator;
	}

	@Override
	public void redraw() {
		super.redraw();
		if(kitchendraw != null) {
			kitchendraw.setFocus();
			kitchendraw.redraw();
		}
		
	}
	public void setCreator(ProjectCreator creator) {
		this.creator = creator;
		if(this.creator != null) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			m_bindingContext = initDataBindings();
		}
	}

	public Object getBackMaterial() {
		return backMaterial;
	}

	public void setBackMaterial(Object backMaterial) {
		this.backMaterial = backMaterial;
	}

	public Object getPrimaryMaterial() {
		return primaryMaterial;
	}

	public void setPrimaryMaterial(Object primaryMaterial) {
		this.primaryMaterial = primaryMaterial;
	}
	public void clearlistners() {
		creator.removePropertyChangeListener(listener);
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observeSingleSelectionTableComboViewer = ViewerProperties.singleSelection().observe(tableComboViewer);
		IObservableValue basematerialCreatorObserveValue = BeanProperties.value("basematerial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer, basematerialCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboViewer_1 = ViewerProperties.singleSelection().observe(tableComboViewer_1);
		IObservableValue backmaterialCreatorObserveValue = BeanProperties.value("backmaterial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboViewer_1, backmaterialCreatorObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionTableComboVwr_facademat = ViewerProperties.singleSelection().observe(tableComboVwr_facademat);
		IObservableValue facematerialCreatorObserveValue = BeanProperties.value("facematerial").observe(creator);
		bindingContext.bindValue(observeSingleSelectionTableComboVwr_facademat, facematerialCreatorObserveValue, null, null);
		//
		return bindingContext;
	}
}
