package dressing.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.lifecycle.PreSave;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.awt.SWT_AWT;
import dressing.model.Caisson;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.IUpdateStructure;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Tirroir;
import dressing.model.usinage.Usinage;
import dressing.ui.DesignObject3DComposite;
import dressing.ui.Piece2DComposite;
import dressing.ui.caisson.CaissonCompositeEditor;
import dressing.ui.caisson.CaissonCompositeWizard;
import dressing.ui.cuisine.CuisineCompositeEditor;
import dressing.ui.design.PublicParam.MechanicDesignComposite;
import dressing.ui.dressing.DressingCompositeEditor;
import dressing.ui.dressing.DressingCompositeWizard;
import dressing.ui.separator.SeparatorCompositeEditor;
import dressing.ui.space3dfree.MechanicDesignEditor;
import dressing.ui.tiroire.TiroireCompositeEditor;
import dressing.ui.usinage.RainureEditorComposite;
import dressing.ui.usinage.UsinageCamEditorComposite;
import param.MechanicDesign;

public class Editor  implements IUpdateStructure {

	Composite dynamiceditor=null;
	
	@Inject ESelectionService selectionService;
	@Inject
	IEventBroker eventBroker;
	Object editelement =null;
	Composite parentcomposite=null;
	public Editor() {
	}

	@Inject
	private MDirtyable dirty;
	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		
		selectionService.addSelectionListener("dressing.part.projectexplorer",new ISelectionListener() {
			
			@Override
			public void selectionChanged(MPart part, Object selection) {
				if(editelement!=null && selection!=null && !editelement.equals(selection))
				{
					if(dirty.isDirty())	
					{
						String nameofelemnt ="";
						if(editelement instanceof DesignObject3D)
						{
							nameofelemnt =((DesignObject3D)editelement).getName();
						}
						boolean rep = MessageDialog.openConfirm(parent.getShell(), "Edition non enregistré", " Voulez vous enregister l'edition en cours : "+nameofelemnt);
						if(rep)
						{
							try {
								run();
							} catch (DesignException e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
							//rester dans la meme fentre
							return;
						}
						else
						{
							cancel();
						}
					}
				}
				//imed bug 1462
				if(selection instanceof Cuisine) {
					changeeditortoCuisine((Cuisine)selection);
				}
				else if(selection instanceof Dressing)
				{
					changeeditortoDressing( (Dressing)selection);
				}
				else if(selection instanceof Caisson)
				{
					changeeditortoCuisson((Caisson)selection);
				}
				else if(selection instanceof Space3DFree)
				{
					changeeditortoSpace3DFree((Space3DFree)selection);
				}
				else if(selection instanceof Separator) {
					changeeditortoSeparator((Separator)selection);
				}
				else if(selection instanceof Piece2D)
				{
					changeeditortoPiece2d((Piece2D)selection);
				}
				else if(selection instanceof Tirroir){
					changeeditortoTirroir((Tirroir) selection);
				}
				else if(selection instanceof Usinage) {
					changeeditortoUsinageCam((Usinage) selection);
				}
				else
				{
					changeeditortoDefault(selection);
				}
			
			}

		});
		
		if(editelement==null)
		{
			parentcomposite = parent;
			dynamiceditor = new Composite(parentcomposite,  SWT.NONE);			
		}


	}

	@PreDestroy
	public void dispose() {
		if(dynamiceditor!= null)
		{
			dynamiceditor.dispose();
			editelement = null;
		}
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
	private void changeeditortoSeparator(Separator selection){
		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof SeparatorCompositeEditor ) {
//			((SeparatorCompositeEditor)dynamiceditor).setSeparator((Separator) selection);
//		}else {
			dispose();
			dynamiceditor = new SeparatorCompositeEditor(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);	
			((SeparatorCompositeEditor)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	private void changeeditortoDressing(Dressing selection)
	{
		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof DressingCompositeEditor ) {
//			((DressingCompositeEditor)dynamiceditor).setDressing((Dressing) selection);
//		}else {
			dispose();
			dynamiceditor = new DressingCompositeEditor(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);	
			((DressingCompositeEditor)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	private void changeeditortoUsinage(Usinage selection)
	{
		editelement = selection;

			dispose();
			dynamiceditor = new RainureEditorComposite(parentcomposite,  SWT.NONE,selection);	
			((RainureEditorComposite)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
		
	}
	private void changeeditortoUsinageCam(Usinage selection)
	{
		editelement = selection;
		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof UsinageCamEditorComposite ) {
			((UsinageCamEditorComposite)dynamiceditor).setUsin( selection);
		}else {
			dispose();
			dynamiceditor = new UsinageCamEditorComposite(parentcomposite,  SWT.NONE,selection);	
			((UsinageCamEditorComposite)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
		}
	}
	private void changeeditortoSpace3DFree(Space3DFree selection)
	{
		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof UsinageCamEditorComposite ) {
//			((UsinageCamEditorComposite)dynamiceditor).setUsin( selection);
//		}else {
			dispose();
			dynamiceditor = new MechanicDesignEditor(parentcomposite,  SWT.NONE,selection);	
			//dynamiceditor = new MechanicDesignComposite((MechanicDesign) selection.getMechanicDesignDefinition(),parentcomposite,  SWT.NONE);	
			((MechanicDesignEditor)dynamiceditor).setDirty(dirty);
			((MechanicDesignEditor)dynamiceditor).setEventBroker(eventBroker);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
	}
	private void changeeditortoCuisine(Cuisine selection)
	{
		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof CuisineCompositeEditor ) {
//			((CuisineCompositeEditor)dynamiceditor).setCuisine((Cuisine) selection);
//		}else {
			dispose();
			dynamiceditor = new CuisineCompositeEditor(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);	
			((CuisineCompositeEditor)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	private void changeeditortoCuisson(Caisson selection) {

		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof CaissonCompositeEditor ) {
//			((CaissonCompositeEditor)dynamiceditor).setCuisson((Caisson) selection);
//		}else {
			dispose();
			dynamiceditor = new CaissonCompositeEditor(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);
			((CaissonCompositeEditor)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	private void changeeditortoSpacefree3d(Space3DFree selection) {

		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof CaissonCompositeEditor ) {
//			((CaissonCompositeEditor)dynamiceditor).setCuisson((Space3D) selection);
//		}else {
			dispose();
			dynamiceditor = new CaissonCompositeEditor(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);
			((CaissonCompositeEditor)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	private void changeeditortoTirroir(Tirroir selection) {
		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof TiroireCompositeEditor ) {
//			((TiroireCompositeEditor)dynamiceditor).setTiroire((Tirroir) selection);
//		}else {
			dispose();
			dynamiceditor = new TiroireCompositeEditor(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);
			((TiroireCompositeEditor)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	private void changeeditortoDefault(Object selection)
	{
		dispose();
		editelement = selection;
		dynamiceditor = new Composite(parentcomposite,  SWT.NONE);
		dynamiceditor.pack();
		parentcomposite.requestLayout();
	}

	private void changeeditortoPiece2d(Piece2D selection) {
		editelement = selection;
//		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof Piece2DComposite ) {
//			((Piece2DComposite)dynamiceditor).setPiece2D((Piece2D) selection);
//		}else {
			dispose();
			dynamiceditor = new Piece2DComposite(parentcomposite,  SWT.NONE,selection,UpdateValueStrategy.POLICY_UPDATE);
			((Piece2DComposite)dynamiceditor).setDirty(dirty);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
//		}
		
	}
	@Persist
	@Override
	public void run() throws DesignException {
		// TODO Auto-generated method stub
		if(dynamiceditor instanceof IUpdateStructure)
		{
			dirty.setDirty(false); //meme si il y une erreur
			((IUpdateStructure) dynamiceditor).run();
		}
		
	}

	@Override
	public void cancel() {
		// TODO Auto-generated method stub
		if(dynamiceditor instanceof IUpdateStructure)
		{
			((IUpdateStructure) dynamiceditor).cancel();
		}
		dirty.setDirty(false);
	}
	@Persist
	public void save() throws DesignException {
		run();
	}
	
}
