package dressing.ui.library;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;

import dressing.controller.EtagereCreator;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.EtagereType;
import dressing.model.types.PieceType;
import dressing.model.types.EtagereReferenceType;

public class ExportModelWizard extends Wizard {
	@Inject
	IEclipseContext eclipsecontext;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	CaissonCuisine caisson;
	ExportModelWelcomePage welcomePage;

	public CaissonCuisine getCaisson() {
		return caisson;
	}

	public void setCaisson(CaissonCuisine caisson) {
		this.caisson = caisson;
	}

	public ExportModelWizard() {
		super();
		setWindowTitle("Exporter un caisson");
	}

	@Override
	public void addPages() {
		welcomePage = new ExportModelWelcomePage("Welcome Page", caisson);
		addPage(welcomePage);
		
		
	}

	@Override
	public boolean performFinish() {
		for (IWizardPage page : getPages()) {
			((WizardPage) page).setErrorMessage("");
		}
		try {
			
		Cuisine cuisine=	welcomePage.getCuisine();
		caisson.setName(welcomePage.getCaissonName());
		caisson.setParentdesign(cuisine);
		caisson.constructDebitage();
		caisson.evaluate();
		cuisine.addElement(caisson);
		cuisine.constructDebitage();
		cuisine.evaluate();
//		caisson.createUsinage();
		cuisine.propagateUpdateToChildrens(null);
		welcomePage.clearlistners();
		} catch (DesignException | GeometricEngineException e) {
			for (IWizardPage page : getPages()) {
				((WizardPage) page).setErrorMessage(e.getMessage());
				e.printStackTrace();
			}
			return false;
		}
		return true;

	}

	@Override
	public boolean canFinish() {
		if (!welcomePage.isPageComplete())
			return false;
		
		return true;
	}

}
