package dressing.ui.engine3d.sceneconfig;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;

import dressing.model.ModelProvider;
import dressing.ui.engine3d.SceneTexture;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.assets.AssetsTextures;
import gdxapp.scenes.ScenePreferences;
import gdxapp.shaders.PbrMaterial;

import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;

public class WallConfigComposite extends Composite{
	
	private String wallStyle;
	private SceneTexture texture;
	private ScenePreferences preferences;
	
	private static HashMap<String, String> styles;
	
	private Button btnPreview;
	private TableComboViewer tcvTexture;
	private TableComboViewer tcvStyles;	
	private Spinner spnHeight;
	Spinner spnThickness;
	

	public WallConfigComposite(Composite parent, int style, ScenePreferences preferences) {
		super(parent, style);
		this.preferences = preferences;
		this.styles = AssetsTextures.getInstance().getWallStyles();
		
		setLayout(new GridLayout(1, false));
		
		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setBounds(0, 0, 64, 64);
		
		CBanner banner = new CBanner(composite, 0);
		banner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		banner.setRightWidth(300);
		banner.setRightMinimumSize(new Point(300, 300));
		banner.setBounds(0, 0, 580, 307);
		
		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_1);
		composite_1.setLayout(new GridLayout(1, false));
		
		btnPreview = new Button(composite_1, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_2);
		GridLayout gl_composite_2 = new GridLayout(1, false);
		gl_composite_2.marginBottom = 50;
		gl_composite_2.marginTop = 50;
		composite_2.setLayout(gl_composite_2);
		
		Composite composite_3 = new Composite(composite_2, SWT.NONE);
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_3.setBounds(0, 0, 261, 57);
		composite_3.setLayout(new GridLayout(2, false));
		
		Label lblType = new Label(composite_3, SWT.NONE);
		lblType.setText("Style");
		lblType.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER,  false,true, 1, 1));

		tcvStyles = new TableComboViewer(composite_3, SWT.NONE);
		tcvStyles.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				setWallStyle((String) tcvStyles.getStructuredSelection().getFirstElement());
			}
		});
		TableCombo tilesTC = tcvStyles.getTableCombo();
		tilesTC.setEditable(false);
		tilesTC.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tcvStyles.setContentProvider(ArrayContentProvider.getInstance());
		tcvStyles.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				return element.toString();
			}
		});
		tcvStyles.setInput(styles.keySet());
	
		Label lblTexture = new Label(composite_3, SWT.NONE);
		lblTexture.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
		lblTexture.setText("Texture");
		
		tcvTexture = new TableComboViewer(composite_3, SWT.NONE);
		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				setTexture((SceneTexture) tcvTexture.getStructuredSelection().getFirstElement());
			}
		});
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setLabelProvider(new SingleImageItemLabelProvider(composite_3));
		
		Label lblHauteur = new Label(composite_3, SWT.NONE);
		lblHauteur.setText("Hauteur");
		
		spnHeight = new Spinner(composite_3, SWT.BORDER);
		spnHeight.setMaximum(10000);
		spnHeight.setMinimum(1);
		spnHeight.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnHeight.setSelection(Math.round( 1000 * preferences.getWallHeight()));
		spnHeight.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				preferences.setWallHeight(spnHeight.getSelection() / 1000.0f);
			}
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				preferences.setWallHeight(spnHeight.getSelection() / 1000.0f);				
			}
		});
		Label lblEpaisseur = new Label(composite_3, SWT.NONE);
		lblEpaisseur.setText("Épaisseur");
		
		spnThickness = new Spinner(composite_3, SWT.BORDER);
		spnThickness.setMaximum(500);
		spnThickness.setMinimum(50);
		spnThickness.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnThickness.setSelection(Math.round(1000 * preferences.getWallwidth()));
		spnThickness.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				preferences.setWallwidth(spnThickness.getSelection() / 1000.0f);
			}
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				preferences.setWallwidth(spnThickness.getSelection() / 1000.0f);				
			}
		});
		// test list texture
		tcvTexture.setInput(ModelProvider.getTextures(CATEGORY.WALL));
		if(preferences!=null&& preferences.getWallMtl()!=null&&preferences.getWallMtl().getAlbedoMapPath()!=null) {
			try {
				tcvTexture.setSelection(new StructuredSelection(ModelProvider.getTexture(preferences.getWallMtl().getAlbedoMapPath())));
				wallStyle=preferences.getWallMtl().getNormalMapPath();
				if(wallStyle!=null) {
					Optional<String> optionelStyle=styles.keySet().parallelStream().filter(new Predicate<String>() {

						@Override
						public boolean test(String t) {
							if(t!=null && wallStyle.contentEquals(styles.get(t))) {
								return true;
							}
							return false;
						}
					}).findFirst();
					if(optionelStyle!=null && optionelStyle.isPresent()) {
						wallStyle=optionelStyle.get();
					}
				}
				if(wallStyle != null) {
					tcvStyles.setSelection(new StructuredSelection(wallStyle));
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	protected void textureChanged() {
		btnPreview.setImage(this.texture.getPreview());
		apply();
	}
	
	public SceneTexture getTexture() {
		return texture;
	}

	public void setTexture(SceneTexture texture) {
		if(this.texture != texture) {
			this.texture = texture;
			textureChanged();
		}
	}
	
	public String getWallStyle() {
		return wallStyle;
	}

	public void setWallStyle(String wallStyle) {
		this.wallStyle = wallStyle;
		apply();
	}
	
	public void apply() {
		if(wallStyle != null && texture !=null) {
			String normalMapPath = styles.get(wallStyle);
			PbrMaterial wallMaterial = AssetsTextures.getInstance().getMaterial("Wall");
			wallMaterial.setAlbedoMapPath(texture.getPath());
			if(!normalMapPath.contentEquals(""))
				wallMaterial.setNormalMapPath(normalMapPath);
			preferences.setWallMtl(wallMaterial);
			preferences.setWallHeight(spnHeight.getSelection() / 1000.0f);
			preferences.setWallwidth(spnThickness.getSelection() / 1000.0f);
		}
	}
}
