package dressing.ui.editorWindows;

import java.util.ArrayList;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wb.swt.ResourceManager;

import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import param.Accessoire;
import param.ArticleFamily;
import param.ArticleFamilyGroup;
import param.BaseObject;
import param.DesignClassGroup;
import param.DesignClasse;
import param.MechanicDesign;
import param.MechanicDesignGroup;
import param.Option;
import param.ParamFactory;
import param.Quincaillerie;

import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.List;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.widgets.Label;

public class LibraryDesignsConfigWidow extends org.eclipse.jface.window.Window {

	private ArticleFamilyGroup familiesGroup;
	private String filterText = "";
	private String filterAticleText = "";
	private DesignClassGroup classes;
	private MechanicDesignGroup designgroup;
	private MechanicDesign design;

	public LibraryDesignsConfigWidow(Shell parentShell) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM | SWT.APPLICATION_MODAL | SWT.FILL_WINDING);
		setBlockOnOpen(true);
		this.classes = ModelProvider.getModelroot().getClasses();
	}

	public Shell shell;

	private static LibraryDesignsConfigWidow instance;
	private Table tabledesignOptions;
	private TableViewer tableViewerDesignOptions;
	private Text txtSearchDesignGroups;
	private SashForm sashForm;
	private TableColumn tblclmnAPrix;
	private TableViewerColumn tableViewerColumnAPrice;
	private TableColumn tblclmnACode;
	private TableViewerColumn tableViewerColumnACode;
	private TableColumn tblclmnANom;
	private TableViewerColumn tableVwrClmnAName;
	private Composite holderComposite;
	private Composite clientAreaComposite;
	private Composite buttonBarAccessoires;
	private Button btnAddDesignOption;
	private Button btnModifyDesignOption;
	private Button btnDeleteDesignOption;
	private Button btnViewDesignOption;
	private Composite compositeDesigns;
	private Text txtSearchDesigns;
	private List listDesignGroups;
	private ListViewer listViewerDesignGroups;
	private List listDesigns;
	private ListViewer listViewerDesigns;
	private Composite tableHolderDesignsOptions;
	private TableColumn tblclmnLabel;
	private TableViewerColumn tableViewerColumnLabel;
	private Composite composite;
	private TableColumn tblclmnPublic;
	private TableViewerColumn tableViewerColumnISPublic;
	private Button btnDupliquer;
	private TableViewerColumn tableViewerColumnRemise;
	private TableViewerColumn tableViewerColumnMaxRemise;
	private TableViewerColumn tableViewerColumnTva;

	public static LibraryDesignsConfigWidow getInstance(Shell shell2) {
		synchronized (LibraryDesignsConfigWidow.class) {
			if (instance == null) {
				instance = new LibraryDesignsConfigWidow(shell2);
				instance.create();
				instance.constrainShellSize();
				instance.setBlockOnOpen(true);
				instance.getShell().setMaximized(true);

			}
			return instance;
		}
	}

	@Override
	public void create() {
		super.create();
		getShell().setImage(ResourceManager.getPluginImage("Dressing", "icons/supercadICon32.jpg"));
	}

	/**
	 * Launch the application.
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			Shell shell = new Shell();

			LibraryDesignsConfigWidow window = new LibraryDesignsConfigWidow(shell);
			window.open();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@Override
	protected boolean canHandleShellCloseEvent() {
		return true;
	}

	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		hide();
	}

	/**
	 * Create contents of the window.
	 * 
	 * @return
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		this.shell = parent.getShell();
		parent.getShell().setText("Articles");
		shell.addShellListener(getShellListener());
		holderComposite = new Composite(parent, SWT.FILL);
		holderComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		holderComposite.setTouchEnabled(true);
		holderComposite.setLayout(new FillLayout(SWT.HORIZONTAL));

		clientAreaComposite = new Composite(holderComposite, SWT.NONE);
		clientAreaComposite.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		clientAreaComposite.setLayout(new FillLayout(SWT.HORIZONTAL));

		sashForm = new SashForm(clientAreaComposite, SWT.BORDER | SWT.SMOOTH);
		sashForm.setBackground(SWTResourceManager.getColor(SWT.COLOR_GRAY));

		ScrolledComposite scrolledCompositeDesignGroups = new ScrolledComposite(sashForm, SWT.BORDER | SWT.V_SCROLL);
		scrolledCompositeDesignGroups.setMinWidth(250);
		scrolledCompositeDesignGroups.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		scrolledCompositeDesignGroups.setExpandHorizontal(true);
		scrolledCompositeDesignGroups.setExpandVertical(true);

		Composite compositeDesignGroups = new Composite(scrolledCompositeDesignGroups, SWT.NONE);
		compositeDesignGroups.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridLayout gl_compositeDesignGroups = new GridLayout(1, true);
		gl_compositeDesignGroups.marginWidth = 0;
		gl_compositeDesignGroups.marginHeight = 0;
		compositeDesignGroups.setLayout(gl_compositeDesignGroups);

		txtSearchDesignGroups = new Text(compositeDesignGroups, SWT.BORDER);
		GridData gd_txtSearchDesignGroups = new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1);
		gd_txtSearchDesignGroups.widthHint = 128;
		txtSearchDesignGroups.setLayoutData(gd_txtSearchDesignGroups);
		txtSearchDesignGroups.setMessage("Rechercher");

		listViewerDesignGroups = new ListViewer(compositeDesignGroups, SWT.BORDER | SWT.V_SCROLL);
		listViewerDesignGroups.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				LibraryDesignsConfigWidow.this.designgroup = (MechanicDesignGroup) listViewerDesignGroups
						.getStructuredSelection().getFirstElement();
				listViewerDesigns.setInput(designgroup);
				listViewerDesigns.refresh();
			}
		});
		listDesignGroups = listViewerDesignGroups.getList();
		GridData gd_listDesignGroups = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_listDesignGroups.heightHint = 339;
		gd_listDesignGroups.widthHint = 150;
		listDesignGroups.setLayoutData(gd_listDesignGroups);
		compositeDesignGroups.setTabList(new Control[] { txtSearchDesignGroups, listDesignGroups });
		scrolledCompositeDesignGroups.setContent(compositeDesignGroups);
		scrolledCompositeDesignGroups.setMinSize(new Point(250, 111));

		composite = new Composite(sashForm, SWT.NONE);
		composite.setLayout(new GridLayout(1, false));

		compositeDesigns = new Composite(composite, SWT.NONE);
		GridData gd_compositeDesigns = new GridData(SWT.FILL, SWT.FILL, false, true, 1, 1);
		gd_compositeDesigns.heightHint = 200;
		compositeDesigns.setLayoutData(gd_compositeDesigns);
		compositeDesigns.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		GridLayout gl_compositeDesigns = new GridLayout(1, true);
		gl_compositeDesigns.marginHeight = 0;
		gl_compositeDesigns.marginWidth = 0;
		compositeDesigns.setLayout(gl_compositeDesigns);

		txtSearchDesigns = new Text(compositeDesigns, SWT.BORDER);
		txtSearchDesigns.setBackground(SWTResourceManager.getColor(SWT.COLOR_WHITE));
		txtSearchDesigns.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false, 1, 1));
		txtSearchDesigns.setMessage("Rechercher");

		listViewerDesigns = new ListViewer(compositeDesigns, SWT.BORDER | SWT.V_SCROLL);
		listDesigns = listViewerDesigns.getList();
		listDesigns.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		tableHolderDesignsOptions = new Composite(composite, SWT.NONE);
		GridData gd_tableHolderDesignsOptions = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_tableHolderDesignsOptions.widthHint = 493;
		gd_tableHolderDesignsOptions.heightHint = 246;
		tableHolderDesignsOptions.setLayoutData(gd_tableHolderDesignsOptions);
		tableHolderDesignsOptions.setSize(441, 440);
		GridLayout gl_tableHolderDesignsOptions = new GridLayout(1, false);
		gl_tableHolderDesignsOptions.marginHeight = 0;
		gl_tableHolderDesignsOptions.marginWidth = 0;
		gl_tableHolderDesignsOptions.verticalSpacing = 0;
		gl_tableHolderDesignsOptions.horizontalSpacing = 0;
		tableHolderDesignsOptions.setLayout(gl_tableHolderDesignsOptions);

		tableViewerDesignOptions = new TableViewer(tableHolderDesignsOptions, SWT.BORDER | SWT.FULL_SELECTION);
		tableViewerDesignOptions.setUseHashlookup(true);
		tabledesignOptions = tableViewerDesignOptions.getTable();
		GridData gd_tableAccessoires = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		gd_tableAccessoires.heightHint = 308;
		tabledesignOptions.setLayoutData(gd_tableAccessoires);
		tabledesignOptions.setHeaderBackground(SWTResourceManager.getColor(SWT.COLOR_CYAN));
		tabledesignOptions.setLinesVisible(true);
		tabledesignOptions.setHeaderVisible(true);
		// create column "Désignation"
		tableVwrClmnAName = createColumn(tableViewerDesignOptions, new DesignOptionNameColumnLabelProvider(),
				"Désignation", 150);
		tblclmnANom = tableVwrClmnAName.getColumn();

		// create column "Label"
		tableViewerColumnLabel = createColumn(tableViewerDesignOptions, new DesignOptionLabelLabelProvider(), "Label",
				150);
		tblclmnLabel = tableViewerColumnLabel.getColumn();

		// create column "code"
		tableViewerColumnACode = createColumn(tableViewerDesignOptions, new DesignOptionCodeLabelProvider(),
				"Réference", 150);
		tblclmnACode = tableViewerColumnACode.getColumn();

		// create column "Prix"
		tableViewerColumnAPrice = createColumn(tableViewerDesignOptions, new DesignOptionPriceLabelProvider(), "Prix",
				100);
		tblclmnAPrix = tableViewerColumnAPrice.getColumn();
		// create column "Public"
		tableViewerColumnISPublic = createColumn(tableViewerDesignOptions,
				new DesignOptionIsPublicColumnLabelProvider(), "Public", 100);
		tblclmnPublic = tableViewerColumnISPublic.getColumn();
		// create column "Remise"
		tableViewerColumnRemise = createColumn(tableViewerDesignOptions, new DesignOptionRemiseLabelProvider(), "%Remise",
				100);
		// create column "%Max Remise"
		tableViewerColumnMaxRemise = createColumn(tableViewerDesignOptions, new DesignOptionMaxRemiseLabelProvider(), "%Max Remise",
				100);
		// create column "%TVA"
		tableViewerColumnTva = createColumn(tableViewerDesignOptions, new DesignOptionTVALabelProvider(), "%TVA",
				100);
		buttonBarAccessoires = new Composite(tableHolderDesignsOptions, SWT.NONE);
		buttonBarAccessoires.setLayoutData(new GridData(SWT.RIGHT, SWT.BOTTOM, true, false, 1, 1));
		GridLayout gl_buttonBarAccessoires = new GridLayout(5, true);
		gl_buttonBarAccessoires.marginHeight = 0;
		gl_buttonBarAccessoires.horizontalSpacing = 0;
		buttonBarAccessoires.setLayout(gl_buttonBarAccessoires);
		
		btnDupliquer = new Button(buttonBarAccessoires, SWT.NONE);
		GridData gd_btnDupliquer = new GridData(SWT.LEFT, SWT.BOTTOM, false, false, 1, 1);
		gd_btnDupliquer.heightHint = 30;
		btnDupliquer.setLayoutData(gd_btnDupliquer);
		btnDupliquer.setText("Dupliquer");
		btnDupliquer.setGrayed(true);
		btnDupliquer.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));

		btnViewDesignOption = new Button(buttonBarAccessoires, SWT.NONE);
		GridData gd_btnViewDesignOption = new GridData(SWT.FILL, SWT.BOTTOM, false, false, 1, 1);
		gd_btnViewDesignOption.heightHint = 30;
		btnViewDesignOption.setLayoutData(gd_btnViewDesignOption);
		btnViewDesignOption.setText("Voir");
		btnViewDesignOption.setGrayed(true);
		btnViewDesignOption.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		btnAddDesignOption = new Button(buttonBarAccessoires, SWT.NONE);
		btnAddDesignOption.setGrayed(true);
		GridData gd_btnAddDesignOption = new GridData(SWT.FILL, SWT.BOTTOM, false, true, 1, 1);
		gd_btnAddDesignOption.heightHint = 30;
		btnAddDesignOption.setLayoutData(gd_btnAddDesignOption);

		btnAddDesignOption.setText("Ajouter");
		btnAddDesignOption.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));

		btnModifyDesignOption = new Button(buttonBarAccessoires, SWT.NONE);
		GridData gd_btnModifyDesignOption = new GridData(SWT.FILL, SWT.BOTTOM, false, false, 1, 1);
		gd_btnModifyDesignOption.heightHint = 30;
		btnModifyDesignOption.setLayoutData(gd_btnModifyDesignOption);
		btnModifyDesignOption.setText("Modifier");
		btnModifyDesignOption.setGrayed(true);
		btnModifyDesignOption.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));

		btnDeleteDesignOption = new Button(buttonBarAccessoires, SWT.NONE);
		GridData gd_btnDeleteDesignOption = new GridData(SWT.FILL, SWT.BOTTOM, false, false, 1, 1);
		gd_btnDeleteDesignOption.heightHint = 30;
		btnDeleteDesignOption.setLayoutData(gd_btnDeleteDesignOption);
		btnDeleteDesignOption.setText("Supprimer");
		btnDeleteDesignOption.setGrayed(true);
		btnDeleteDesignOption.setBackground(SWTResourceManager.getColor(SWT.COLOR_LIST_SELECTION));
		tableViewerDesignOptions.setContentProvider(ArrayContentProvider.getInstance());
		listViewerDesigns.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				LibraryDesignsConfigWidow.this.design = (MechanicDesign) listViewerDesigns.getStructuredSelection()
						.getFirstElement();
				tableViewerDesignOptions.setInput(LibraryDesignsConfigWidow.this.design.getOptions().getOptions());
				tableViewerDesignOptions.refresh();

			}
		});
		sashForm.setWeights(new int[] { 100, 400 });
		clientAreaComposite.setTabList(new Control[] { sashForm });
		holderComposite.setTabList(new Control[] { clientAreaComposite });
		addControl();
		return holderComposite;

	}

	private TableViewerColumn createColumn(TableViewer table,CellLabelProvider labelprovider,String name,int width) {
		TableViewerColumn	tableViewerColumn = new TableViewerColumn(table, SWT.NONE);
		tableViewerColumn.setLabelProvider(labelprovider);
		TableColumn	tblclmn = tableViewerColumn.getColumn();
		tblclmn.setMoveable(true);
		tblclmn.setWidth(width);
		tblclmn.setText(name);
		return tableViewerColumn;
	}

	public void addControl() {
		listViewerDesignGroups.setContentProvider(new ListDesignGroupsContentProvider());
		listViewerDesignGroups.setLabelProvider(new LabelProvider() {
			/**
			 * @param element
			 * @return
			 */
			@Override
			public String getText(Object element) {
				if (element instanceof MechanicDesignGroup) {
					MechanicDesignGroup group = (MechanicDesignGroup) element;
					return group.getName();
				}

				return super.getText(element);
			}
		});
		listViewerDesignGroups.setInput(classes);
		listViewerDesigns.setContentProvider(new ListDesignsContentProvider());
		listViewerDesigns.setLabelProvider(new LabelProvider() {
			/**
			 * @param element
			 * @return
			 */
			@Override
			public String getText(Object element) {
				if (element instanceof MechanicDesign) {
					MechanicDesign design = (MechanicDesign) element;
					return design.getName();
				}

				return super.getText(element);
			}
		});
		listViewerDesigns.setInput(designgroup);
		tableViewerDesignOptions.setContentProvider(ArrayContentProvider.getInstance());
		btnAddDesignOption.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Option option = ParamFactory.eINSTANCE.createOption();
				option.setCode(design.getCode());
				option.setName(design.getName());
				option.setLabel(design.getName());
				option.setPrice(design.getPrice());
				option.setRemise(design.getRemise());
				option.setMaxRemise(design.getMaxRemise());
				option.setTva(design.getTva());
				
				design.getOptions().getOptions().add(option);
				
				designOptionEditorWindow window = new designOptionEditorWindow(getShell(), EditorWindow.create, option);
				int returnCode = window.open();
				if (returnCode == Window.OK) {
					
					tableViewerDesignOptions.refresh();
				}else {
					design.getOptions().getOptions().remove(option);
				}
			}
			
		});
		btnModifyDesignOption.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				Option option = (Option) tableViewerDesignOptions.getStructuredSelection()
						.getFirstElement();
				if (option != null) {
					designOptionEditorWindow window = new designOptionEditorWindow(getShell(), EditorWindow.update, option);
					int returnCode = window.open();
					if (returnCode == Window.OK) {
						tableViewerDesignOptions.refresh();
					}
				}

			}
		});
		btnDupliquer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				Option option = (Option) tableViewerDesignOptions.getStructuredSelection()
						.getFirstElement();
				if (option != null) {
					Option copy=EcoreUtil.copy(option);
					design.getOptions().getOptions().add(copy);

					designOptionEditorWindow window = new designOptionEditorWindow(getShell(), EditorWindow.update, copy);
					int returnCode = window.open();
					if (returnCode == Window.OK) {
						tableViewerDesignOptions.refresh();
					}else {
						design.getOptions().getOptions().remove(copy);
					}
				}

			}
		});
		btnViewDesignOption.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				Option option = (Option) tableViewerDesignOptions.getStructuredSelection()
						.getFirstElement();
				if (option != null) {
					designOptionEditorWindow window = new designOptionEditorWindow(getShell(), EditorWindow.View, option);
					window.open();
				}

			}
		});
		btnDeleteDesignOption.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				Option option = (Option) tableViewerDesignOptions.getStructuredSelection()
						.getFirstElement();
				if (option != null) {
					boolean confirm = MessageDialog.openConfirm(getShell(), "Supprimer Option d'élément",
							"voulez vous suupprimer Option d'élément " + option.getName() + ":" + option.getCode());
					if (confirm) {
						if (option.getGroup() != null) {
							option.getGroup().getOptions().remove(option);
							ResourceManagers.getIntance().saveLibraryResource();
						}
						tableViewerDesignOptions.refresh();
					}

				}

			}
		});
		ViewerFilter filter = new ViewerFilter() {

			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				if (element != null) {
					String name;
					String code;
					boolean iscontainTxtFilter = false;
					if (element != null && element instanceof Accessoire) {
						name = ((Accessoire) element).getName();
						code = ((Accessoire) element).getCode();

					} else if (element != null && element instanceof Quincaillerie) {
						name = ((Quincaillerie) element).getName();
						code = ((Quincaillerie) element).getCode();
					} else {
						return false;
					}

					iscontainTxtFilter = filterAticleText.equals("")
							|| (name != null && name.toUpperCase().contains(filterAticleText.toUpperCase()))
							|| (code != null && code.toUpperCase().contains(filterAticleText.toUpperCase()));

					return iscontainTxtFilter;
				}
				return false;
			}

		};
//		tableViewerDesignOptions.addFilter(filter);

		// In order to let a column fit to it’s contents width you can invoke the
		// columns pack method like that.

		txtSearchDesignGroups.addKeyListener(new KeyListener() {

			@Override
			public void keyReleased(KeyEvent e) {
				filterText = txtSearchDesignGroups.getText();
				listViewerDesignGroups.refresh();
			}

			@Override
			public void keyPressed(KeyEvent e) {
				// TODO Auto-generated method stub

			}
		});

		ControlAdapter adaptor2 = new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				Rectangle area2 = LibraryDesignsConfigWidow.this.getShell().getClientArea();
				holderComposite.setBounds(area2);
				int tableHeight = tableHolderDesignsOptions.getSize().y - buttonBarAccessoires.getSize().y;
				int width = tableHolderDesignsOptions.getSize().x - tableHolderDesignsOptions.getBorderWidth() * 2;
				int tablewidth = width;
				if (tableHolderDesignsOptions.getVerticalBar() != null) {
					tablewidth -= tableHolderDesignsOptions.getVerticalBar().getSize().x;
				}
				if(tabledesignOptions.getVerticalBar()!=null ) {
					width = tablewidth - tabledesignOptions.getVerticalBar().getSize().x;
				}
				
				width -= tabledesignOptions.getBorderWidth() * 2;
				
				Point oldSize = tabledesignOptions.getSize();
				if (oldSize.x > tablewidth) {
					// table is getting smaller so make the columns
					// smaller first and then resize the table to
					// match the client area width
					int columnWidth = (width) / 8;
					for (TableColumn column : tabledesignOptions.getColumns()) {
						column.setWidth(columnWidth);
					}

					tabledesignOptions.setSize(tablewidth,
							tableHeight - tabledesignOptions.getHorizontalBar().getSize().y);

				} else {
					// table is getting bigger so make the table
					// bigger first and then make the columns wider
					// to match the client area width
					int columnWidth = (width) / 8;
					tabledesignOptions.setSize(tablewidth,
							tableHeight - tabledesignOptions.getHorizontalBar().getSize().y);

					for (TableColumn column : tabledesignOptions.getColumns()) {
						column.setWidth(columnWidth);
					}

				}
			}

		};
		holderComposite.addControlListener(adaptor2);

		getShell().addControlListener(adaptor2);

	}

	public synchronized void show() {
		if (!shell.isDisposed()) {
			listViewerDesignGroups.setInput(getClasses());
			listViewerDesignGroups.refresh();
			tableViewerDesignOptions.refresh();
			LibraryDesignsConfigWidow.this.shell.setVisible(true);
			LibraryDesignsConfigWidow.this.shell.setActive();
		}

	}

	public synchronized void hide() {
		if (!shell.isDisposed()) {

			LibraryDesignsConfigWidow.this.shell.setVisible(false);
		}

	}

	public DesignClassGroup getClasses() {
		return classes;
	}

	public void createController() {

	}

	class ArticleFamilleLAbelProvider extends LabelProvider {

		@Override
		public String getText(Object element) {
			if (element instanceof ArticleFamily) {
				return ((ArticleFamily) element).getName();
			}
			return "";
		}

		@Override
		public Image getImage(Object element) {

			return super.getImage(element);
		}

	}

	class ListAccessoireContentProvider implements IStructuredContentProvider {

		@Override
		public Object[] getElements(Object inputElement) {
			ArrayList<BaseObject> articles = new ArrayList<BaseObject>();
			if (inputElement instanceof ArticleFamily) {
				getArticles((ArticleFamily) inputElement, articles);
			}
			if (inputElement instanceof ArticleFamilyGroup) {
				if (((ArticleFamilyGroup) inputElement).getFamilles() != null
						&& ((ArticleFamilyGroup) inputElement).getFamilles().size() > 0) {
					for (ArticleFamily sub_family : ((ArticleFamilyGroup) inputElement).getFamilles()) {
						getArticles(sub_family, articles);
					}
				}
			}
			return articles.toArray();
		}

		public void getArticles(ArticleFamily family, ArrayList<BaseObject> articles) {
			if (family != null && articles != null) {
				if (family.getAccessoires() != null && family.getAccessoires().size() > 0) {
					articles.addAll(family.getAccessoires());
				}
				if (family.getFamilies() != null && family.getFamilies().size() > 0) {
					for (ArticleFamily sub_family : family.getFamilies()) {
						getArticles(sub_family, articles);
					}
				}
			}
		}
	}

	class ListQuicaillerieContentProvider implements IStructuredContentProvider {

		@Override
		public Object[] getElements(Object inputElement) {
			ArrayList<BaseObject> articles = new ArrayList<BaseObject>();
			if (inputElement instanceof ArticleFamily) {
				getArticles((ArticleFamily) inputElement, articles);
			}
			if (inputElement instanceof ArticleFamilyGroup) {
				if (((ArticleFamilyGroup) inputElement).getFamilles() != null
						&& ((ArticleFamilyGroup) inputElement).getFamilles().size() > 0) {
					for (ArticleFamily sub_family : ((ArticleFamilyGroup) inputElement).getFamilles()) {
						getArticles(sub_family, articles);
					}
				}
			}
			return articles.toArray();
		}

		public void getArticles(ArticleFamily family, ArrayList<BaseObject> articles) {
			if (family != null && articles != null) {

				if (family.getQuincailleries() != null && family.getQuincailleries().size() > 0) {
					articles.addAll(family.getQuincailleries());
				}
				if (family.getFamilies() != null && family.getFamilies().size() > 0) {
					for (ArticleFamily sub_family : family.getFamilies()) {
						getArticles(sub_family, articles);
					}
				}
			}
		}
	}

	class ListDesignGroupsContentProvider implements IStructuredContentProvider {

		@Override
		public Object[] getElements(Object inputElement) {
			ArrayList<BaseObject> articles = new ArrayList<BaseObject>();
			if (inputElement instanceof DesignClassGroup) {
				getGroups((DesignClassGroup) inputElement, articles);
			}

			return articles.toArray();
		}

		public void getGroups(DesignClassGroup family, ArrayList<BaseObject> articles) {
			if (family != null && articles != null) {

				if (family.getDesignClasse() != null && family.getDesignClasse().size() > 0) {
					for (DesignClasse sub_family : family.getDesignClasse()) {
						articles.addAll(sub_family.getCategorie());
					}
				}
			}
		}
	}

	class ListDesignsContentProvider implements IStructuredContentProvider {

		@Override
		public Object[] getElements(Object inputElement) {
			ArrayList<BaseObject> articles = new ArrayList<BaseObject>();
			if (inputElement instanceof MechanicDesignGroup) {
				getDesigns((MechanicDesignGroup) inputElement, articles);
			}

			return articles.toArray();
		}

		public void getDesigns(MechanicDesignGroup family, ArrayList<BaseObject> articles) {
			if (family != null && articles != null) {

				if (family.getMechanicdesign() != null && family.getMechanicdesign().size() > 0) {
					articles.addAll(family.getMechanicdesign());

				}
			}
		}
	}

	class DesignOptionNameColumnLabelProvider extends ColumnLabelProvider {

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getName();
			}

			return element == null ? "" : element.toString();
		}

	}
	class DesignOptionIsPublicColumnLabelProvider extends ColumnLabelProvider {

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).isPublic()?"Oui":"Non";
			}

			return element == null ? "" : element.toString();
		}

	}

	class DesignOptionCodeLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getCode();
			}
			return element == null ? "" : element.toString();
		}
	}

	class DesignOptionPriceLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getPrice() + "";
			}
			return element == null ? "" : element.toString();
		}
	}
	class DesignOptionRemiseLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getRemise() + "";
			}
			return element == null ? "" : element.toString();
		}
	}
	class DesignOptionMaxRemiseLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getMaxRemise() + "";
			}
			return element == null ? "" : element.toString();
		}
	}
	class DesignOptionTVALabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getTva() + "";
			}
			return element == null ? "" : element.toString();
		}
	}
	
	class DesignOptionLabelLabelProvider extends ColumnLabelProvider {
		public Image getImage(Object element) {
			// TODO Auto-generated method stub
			return null;
		}

		public String getText(Object element) {
			if (element instanceof Option) {
				return ((Option) element).getLabel();
			}
			return element == null ? "" : element.toString();
		}
	}
}