package dressing.ui.dressing;

import java.awt.print.Pageable;
import java.util.HashMap;

import javax.inject.Inject;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;

import dressing.controller.DressingCreator;
import dressing.model.Caisson;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.Project3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PortType;



public class DressingWizard extends Wizard{

	//L injection ne peut etre en marche que si on creer l objet avec contextfactory et non pas avec l objet new
	@Inject
	IEclipseContext  eclipsecontext;

	@Inject
	private EHandlerService handlerService;
	
	@Inject
	private ECommandService commandService;

	Project3D project3d;
	DressingCreator dress = new DressingCreator();
	DressingWelcomePage welcompage;
	DressingSecondPage secondpage;
	public DressingWizard () {
		setWindowTitle("Nouveau dressing");		
		//temporaiement pour le moement	
	
	}

	@Override
	public void addPages() {
		welcompage = new DressingWelcomePage("WelcomePage",dress);
		secondpage = new DressingSecondPage("secondpage", dress);
		addPage(welcompage);		
		addPage(secondpage);		
//		addPage(new DressingSecondPage("SecondPage",dress));
	}

	@Override
	public boolean performFinish() {
		for(IWizardPage page :getPages())
		{
			((WizardPage) page).setErrorMessage("");
		}
			try {
				this.dress.create();
				welcompage.clearlistners();
				secondpage.clearlistners();
				this.project3d.addElement(dress.getDressingInstance());		
			} catch (DesignException  | GeometricEngineException e) {
				for(IWizardPage page :getPages())
				{
					((WizardPage) page).setErrorMessage(e.getMessage());
				}
					return false;
			}

					
			return true;
	}
	
public void setProject3d(Project3D project3d) {
	this.project3d = project3d;	
	dress.setParent(project3d);
}
private void createcuissonwizard()
{
//	HashMap<String,Object> parammap = new HashMap<>();
//	parammap.put("dressing.commandparameter.autogenerate", "true");
//	eclipsecontext.set("wizard.dressing.object", dress);
//	ParameterizedCommand command = commandService.createCommand("dressing.command.addcuissonwizard", parammap);
//	handlerService.executeHandler(command);
	eclipsecontext.set("wizard.dressing.object", dress);
	Command command =  commandService.getCommand("dressing.command.addcuissonwizard");
	ExecutionEvent evt = new ExecutionEvent();
	try {
		command.executeWithChecks(evt);
	} catch (ExecutionException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (NotDefinedException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (NotEnabledException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	} catch (NotHandledException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
}
	private void callexitcmd()
	{
//		ParameterizedCommand command = commandService.createCommand("org.eclipse.ui.file.exit", null);
//		handlerService.executeHandler(command);
		
		
		Command quitcmd =  commandService.getCommand("org.eclipse.ui.file.exit");
		quitcmd.addExecutionListener(new IExecutionListener() {
			
			@Override
			public void preExecute(String commandId, ExecutionEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void postExecuteSuccess(String commandId, Object returnValue) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void postExecuteFailure(String commandId, ExecutionException exception) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void notHandled(String commandId, NotHandledException exception) {
				// TODO Auto-generated method stub
				
			}
		});
		ExecutionEvent evt = new ExecutionEvent();
		try {
			quitcmd.executeWithChecks(evt);
		} catch (ExecutionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NotDefinedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NotEnabledException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NotHandledException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
//		handlerService.executeHandler(quitcmd);
	}
	@Override
	public boolean canFinish() {
		IWizardPage[] pages = getPages();
		for (IWizardPage page : pages) {
			if (!page.isPageComplete()) {
				return false;
			}
		}
		return true;
	}
}
