package dressing.reporting.data.handle;

import java.text.DecimalFormat;

import dressing.model.stock.Article;
import dressing.ui.util.StaticUiObjects;

public class ArticleCoupe implements Cloneable{
	private String name;
	private Article article;
	private String imagePath;
	private String code;
	private double number;
	private double price;
	private double totalPrice;
	private String stotalPrice;
	private String articlePrice;
	private int ordre;
	private int rowHeigh=10;
	public ArticleCoupe(Article article,int ordre) {
		this.article=article;
		this.name=article.getName();
		this.code=this.article.getArticle().getCode()==null ||this.article.getArticle().getCode().isEmpty()?"":this.article.getArticle().getCode();
		this.number=this.article.getNumber();
		this.price=this.article.getArticle().getPrix();
		this.imagePath=(this.article.getArticle().getImage()==null
				|| this.article.getArticle().getImage().getPath()==null
				||this.article.getArticle().getImage().getPath().isEmpty())?"":this.article.getArticle().getImage().getPath();		
		this.ordre=ordre;
		this.rowHeigh=this.imagePath==null || this.imagePath.isEmpty()?40:104;
		calculate();
	}
	
	public void calculate() {
		this.totalPrice=this.number*this.price;
		
		this.stotalPrice = StaticUiObjects.decimalMoneyFormat.format(totalPrice);
		this.articlePrice=StaticUiObjects.decimalMoneyFormat.format(this.price);
	}
	public int getOrdre() {
		return ordre;
	}
	
	public void setOrdre(int ordre) {
		this.ordre = ordre;
	}

	public boolean isImageExist() {
		return !(this.imagePath==null || this.imagePath.isEmpty());
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Article getArticle() {
		return article;
	}
	public void setArticle(Article article) {
		this.article = article;
	}
	public String getImagePath() {
		return imagePath;
	}
	public void setImagePath(String imagePath) {
		this.imagePath = imagePath;
	}
	public String getCode() {
		return code;
	}
	public void setCode(String code) {
		this.code = code;
	}
	public double getNumber() {
		return number;
	}
	public void setNumber(double number) {
		this.number = number;
		calculate();
	}
	public double getPrice() {
		return price;
	}
	public void setPrice(double price) {
		this.price = price;
	}
	public double getTotalPrice() {
		return totalPrice;
	}
	public void setTotalPrice(double totalPrice) {
		this.totalPrice = totalPrice;
	}

	public String getStotalPrice() {
		return stotalPrice;
	}

	public String getArticlePrice() {
		return articlePrice;
	}

	public int getRowHeigh() {
		return rowHeigh;
	}
	
	
}
