package dressing.model.evalutor;

import java.util.ArrayList;
import javax.script.ScriptEngine;

import org.mozilla.javascript.engine.RhinoScriptEngine;
import org.mozilla.javascript.engine.RhinoScriptEngineFactory;

public class GeomtericEngine {
	private static RhinoScriptEngineFactory engineFactory = new RhinoScriptEngineFactory();
	private static ScriptEngine engine = engineFactory.getScriptEngine();
	private static ScriptEngine logicalEngine = engineFactory.getScriptEngine();
	private ArrayList<Equation> equations = new ArrayList<>();
	private ArrayList<Equation> forwardequations = new ArrayList<>();
	private ArrayList<String> dependencystack = new ArrayList<>();
	private static GeomtericEngine instance;
	/**
	 * Returns an instance of GeomtericEngine. Since instances of this
	 * class do not maintain any state, they can be shared between multiple
	 * clients.
	 *
	 * @return an instance of GeomtericEngine
	 *
	 * @since 3.5
	 */
	public static GeomtericEngine getInstance() {
		synchronized(GeomtericEngine.class) {
			if (instance == null) {
				instance = new GeomtericEngine();
			}
			return instance;
		}
	}
	public GeomtericEngine() {
	}

	public void setEquations(ArrayList<Equation> equations) {
		this.equations = equations;
	}

	public ArrayList<Equation> getEquations() {
		return equations;
	}

	public void resolveAll() throws GeometricEngineException {
		// permet de savoir si il y a un boucle
		dependencystack.clear();

		// On reset les equations pour un calcul complet
		for (Equation equ : equations) {
			equ.reset();
		}

		for (Equation equ : equations) {
			if (!equ.isEvaluated()) {
				equ.resolve(engine, equations, dependencystack);
			}

		}
	}

	// Used if the model is already resolved
	public void resolveforward(String key, double value) throws GeometricEngineException {
		// permet de savoir si il y a un boucle
		dependencystack.clear();
		forwardequations.clear(); // l'ensemble des equation a reevamluer

		// detecter l'arbre a modifier

		forwardchaining(key);

		for (Equation equ : forwardequations) {
			equ.reset();// reeavaluer les equation forward
		}
		// put value into properties.
		Equation startequation = Equation.FIND_EQUATION(key, equations);
		if (startequation == null)
			throw new GeometricEngineException("Symbol not found " + key);

		// Write value to propertie
		startequation.setEvaluation(value);
		startequation.printEvaluation();

		for (Equation equ : forwardequations) {
			if (!equ.isEvaluated()) {
				equ.resolve(engine, equations, dependencystack);
			}
		}
	}

	private void forwardchaining(String key) throws GeometricEngineException {
		for (Equation equ : equations) {
			if (equ.isDependentTo(key)) {
				if (!forwardequations.contains(equ)) {
					forwardequations.add(equ);
					forwardchaining(equ.getKey());
				} else {
					throw new GeometricEngineException("Inifinite dependency loop " + key + " in equation "
							+ equ.getKey() + " = " + equ.getExpr());
				}
			}
		}
	}

	public static final ScriptEngine getEngine() {
		return engine;
	}

	public static final ScriptEngine getLogicalEngine() {
		return logicalEngine;
	}

	@Override
	protected void finalize() throws Throwable {
		// TODO Auto-generated method stub
		super.finalize();
	}

	public void dispose() {
		equations.clear();
		forwardequations.clear();
		dependencystack.clear();
		// ne pas faire le null des array car ils sont dans state singlaeton dans le
		// objet appelant
	}
}
