package dressing.model.cam;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import dressing.cam.model.Operation;
import dressing.cam.model.Tool;

public class Layer {

	private List<Operation> operations = new ArrayList<Operation>();
	private Tool tool;

	public Layer() {
		super();
	}

	public Layer(List<Operation> operations) {
		super();
		this.operations = operations;
	}

	public Layer(List<Operation> operations, Tool tool) {
		super();
		this.operations = operations;
		this.tool = tool;
	}

	public List<Operation> getOperations() {
		return operations;
	}

	public void setOperations(List<Operation> operations) {
		this.operations = operations;
	}

	public Tool getTool() {
		return tool;
	}

	public void setTool(Tool tool) {
		this.tool = tool;
	}


	public boolean addOpperation(Operation op) {
		if(op.getTool().equals(this.tool)) {
			return this.operations.add(op);
		}
		return false;
	}

	public boolean removeOperation(Operation op) {
		if(this.operations.contains(op)) {
			return this.operations.remove(op);
		}
		return false;
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public PropertyChangeSupport getPropertyChangeSupport() {
		return propertyChangeSupport;
	}

	public void setPropertyChangeSupport(PropertyChangeSupport propertyChangeSupport) {
		this.propertyChangeSupport = propertyChangeSupport;
	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

}
