package dressing.model;

import java.util.ArrayList;
import java.util.List;

import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.RainureDebitageFormulas;
import dressing.model.debitage.SuportBasDebitageFormulas;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.SupportMeubleBasType;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;

/**
 * @Bug 0001866: ajouter les support pour les caisson bas 
 *  {@link SupportMeubleBas}  est le model Accessoire du support des caisson bas
 * @author Imed
 *
 */
public class SupportMeubleBas extends Accessoire {

	SupportMeubleBasType supportType=SupportMeubleBasType.BACK_LEFT;	
			
	@Override
	public boolean canHold(DesignObject3D child) {
		if(child instanceof Usinage) {
			return true;
		}
		return false;
	}
	
	@Override
	public boolean isdrawable() {
		return false;
	}
	
	@Override
	public List getChildren() {
		if(childs==null ) {
			childs =new ArrayList<DesignObject3D>();
		}
		return childs;
	}
	
	public SupportMeubleBasType getSupportType() {
		return supportType;
	}
	public void setSupportType(SupportMeubleBasType supportType) {
		SupportMeubleBasType oldValue = this.supportType;
		this.supportType = supportType;
		firePropertyChange("supportType", oldValue, supportType);
	}

	@Override
	public SupportMeubleBas clone() {

		SupportMeubleBas support=new SupportMeubleBas();
		support.setSupportType(getSupportType());
		support=(SupportMeubleBas) this.copy(support);
		return support;
	}
	
	/**
	 * @author imed 
	 * @Bug 0001217 
	 * Créer les trous d'usinage necessaire pour cette Accessoire(Support Bas {@link SupportMeubleBas})
	 * créer les trous d'usinage 
	 */
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		
		Piece2D piece=(Piece2D) getParentdesign();

		Trou tr1=new Trou(Direction.YPLUS);
		Trou tr2=new Trou(Direction.YPLUS);
		Trou tr3=new Trou(Direction.YPLUS);
		Trou tr4=new Trou(Direction.YPLUS);
		
		tr1.setTrouType(TrouType.SUPPORT_BAS_BACK_LEFT);
		tr2.setTrouType(TrouType.SUPPORT_BAS_BACK_RIGHT);
		tr3.setTrouType(TrouType.SUPPORT_BAS_FRONT_LEFT);
		tr4.setTrouType(TrouType.SUPPORT_BAS_FRONT_RIGHT);

		tr1.setMother(this); 
		tr2.setMother(this);
		tr3.setMother(this); 
		tr4.setMother(this);
		
		tr1.setName("Trou 1 "+this.getName());
		tr2.setName("Trou 2 "+this.getName());		
		tr3.setName("Trou 3 "+this.getName());
		tr4.setName("Trou 4 "+this.getName());
		
		tr1.setParentdesign(piece);
		tr2.setParentdesign(piece);
		tr3.setParentdesign(piece);
		tr4.setParentdesign(piece);
		
		tr1.constructDebitage();
		tr1.evaluate();
		
		tr2.constructDebitage();
		tr2.evaluate();
		
		tr3.constructDebitage();
		tr3.evaluate();
		
		tr4.constructDebitage();
		tr4.evaluate();
		
		piece.addElement(tr1);
		piece.addElement(tr2);
		piece.addElement(tr3);
		piece.addElement(tr4);
	}
	
	@Override
	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null|| !(formulas instanceof SuportBasDebitageFormulas)) {
			formulas = new SuportBasDebitageFormulas();
		}
		return formulas; 
	}
}
