 
package dressing.handlers;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Project3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.DesignType;

import javax.inject.Inject;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;

public class AddUsinageTrou {
@Inject ESelectionService selectionService;
	
	@Inject
	IEclipseContext  eclipsecontext;
	@Execute
	public void execute() {
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && !(o instanceof Project3D) && o instanceof DesignObject3D)
		{
			DesignObject3D object3d =(DesignObject3D)o;
			if(!object3d.getDesignType().equals(DesignType.GENERIC)) {
				try {
					object3d.deleteUsinage();
					object3d.createUsinage();
				} catch (GeometricEngineException | DesignException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}	
		}	
	}
	
	
	@CanExecute
	public boolean canExecute() {
		Object o = selectionService.getSelection("dressing.part.tree");
		//Voire l element de l arbre selectionne
		if(o!=null && !(o instanceof Project3D) && o instanceof DesignObject3D)
		{
			return true;
		}	
			return false;
	}
		
}