package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.SeprationAxe;
import dressing.model.CaissonCuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Materiaux;
public class CaissonCuisineCreator implements Creator{
	public final static double COLONNE_HAUTEUR = 2050;
	public final static double COLONNE_PROFONDEUR = 560;
	public final static double COLONNE_LONGEUR = 600;
	String name;
	double longeur = 600;
	double hauteur = 720;
	double profondeur = 560;
	private Materiaux basematerial=new Materiaux();
	private Materiaux backmaterial=new Materiaux();
	DosType dostype = DosType.DOSINTERIEUR;
	CuisineCaissonType caissoncuisineType=CuisineCaissonType.haut;
	CaissonMontageType caissonMontageType=CaissonMontageType.CAISSON_MONTAGE_I;
	CaissonCuisine caissonC;
	DesignObject3D parent;
	CaissonType cuissontype = CaissonType.MILIEU;
	boolean withporte=false;	
	boolean withDos=false;


	public boolean isWithDos() {
		return withDos;
	}
	public void setWithDos(boolean withDos) {
		boolean oldValue = this.withDos;
		this.withDos = withDos;
		firePropertyChange("withDos", oldValue, withDos);
	}
	public void setCuissontype(CaissonType cuissontype) {
			CaissonType oldValue = this.cuissontype;
			this.cuissontype = cuissontype;
			firePropertyChange("cuissontype", oldValue, cuissontype);
	}
	public CaissonType getCuissontype() {
			return cuissontype;
	}
	public Materiaux getBasematerial() {
		return basematerial;
	}
	
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(
			this);
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName,
				listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
			propertyChangeSupport.firePropertyChange(propertyName, oldValue,
					newValue);
	}

	public void setBasematerial(Materiaux basematerial) {
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}
	public Materiaux getBackmaterial() {
		return backmaterial;
	}
	public void setBackmaterial(Materiaux backmaterial) {
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}
	public DosType getDostype() {
		return dostype;
	}
	public void setDostype(DosType dostype) {
		DosType oldValue = this.dostype;
		this.dostype = dostype;
		firePropertyChange("dostype", oldValue, dostype);
	}
	public CaissonCuisine getCaisson() {
		return caissonC;
	}
	public void setCaisson(CaissonCuisine caissonC) {
		CaissonCuisine oldValue = this.caissonC;
		this.caissonC = caissonC;
		firePropertyChange("caissonC", oldValue, caissonC);
	}
	public DesignObject3D getParent() {
		return parent;
	}
	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		setBackmaterial(parent.getBackmaterial());
		setBasematerial(parent.getBasematerial());
		setHauteur(parent.getHauteurext());
		setProfondeur(parent.getProfondeurext());
		firePropertyChange("parent", oldValue, parent);
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}
	public double getLongeur() {
		return longeur;
	}
	public void setLongeur(double longeur) {
		double oldValue = this.longeur;
		this.longeur = longeur;
		firePropertyChange("longeur", oldValue, longeur);
	}
	public double getHauteur() {
		return hauteur;
	}
	public void setHauteur(double hauteur) {
		double oldValue = this.hauteur;
		this.hauteur = hauteur;
		firePropertyChange("hauteur", oldValue, hauteur);
	}
	public double getProfondeur() {
		return profondeur;
	}
	public void setProfondeur(double profondeur) {
		double oldValue = this.profondeur;
		this.profondeur = profondeur;
		firePropertyChange("profondeur", oldValue, profondeur);
	}
	 
	public boolean isWithporte() {
		return withporte;
	}
	public void setWithporte(boolean withporte) {
		boolean oldValue = this.withporte;
		this.withporte = withporte;
		firePropertyChange("withporte", oldValue, withporte);
	}
	public void create() throws DesignException, GeometricEngineException{
		// TODO Auto-generated method stub
		createSubElements();
		//rectifier le xpos en fonctions des caissons qui existe deja
		rectifyXpos();
	}
	
	public DesignObject3D getCaissonInstance() {
		// TODO Auto-generated method stub
		return caissonC;
	}
	
	
public CuisineCaissonType getCaissoncuisineType() {
	return caissoncuisineType;
}
public void setCaissoncuisineType(CuisineCaissonType caissoncuisineType) {
//	if(caissoncuisineType.equals(CuisineCaissonType.colonne)) {
//		setHauteur(COLONNE_HAUTEUR);
//		setProfondeur(COLONNE_PROFONDEUR);
//		setLongeur(COLONNE_LONGEUR);
//	}
////	else if(this.caissoncuisineType.equals(CuisineCaissonType.colonne)&&! caissoncuisineType.equals(CuisineCaissonType.colonne)) {
////		setHauteur(parent.getHauteurext());
////		setProfondeur(parent.getProfondeurext());
////		setLongeur(800);
////	}
	
	CuisineCaissonType oldValue = this.caissoncuisineType;
	this.caissoncuisineType = caissoncuisineType;
	firePropertyChange("caissoncuisinetype", oldValue, this.caissoncuisineType);
}
	/**
	 * on doit appeler cette methode si on veuty faire la mise a jour de la position de xpos 
	 * lorsque on ajoute un caisson manuellment
	 * @throws DesignException 
	 * @throws GeometricEngineException 
	 */
	private void rectifyXpos() throws GeometricEngineException, DesignException {

		double xpos = 0.0f;

		// calculer la somme des caissons existants
			List<DesignObject3D> childsList = this.getParent().getChilds();
			for (DesignObject3D a : childsList) {
				xpos += a.getLongeurext();
					
			}
			caissonC.setXpos(xpos);
	}
	public void check() throws DesignException
	{
		if (getName() == null || getName().isEmpty())
			throw new DesignException("Le nom de caisson cuisine est obligatoire");

		if (getBasematerial() == null)
			throw new DesignException("Le matérieaux de base doit être rensigné");

		if (getBackmaterial() == null)
			throw new DesignException("Le matérieaux de dos doit être rensigné");

		if (getBasematerial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de base doit être superieur à 1 mm");

		if (getBackmaterial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de dos doit être superieur à 1 mm");

	}
	public void createSubElements() throws DesignException, GeometricEngineException
	{
		check();		//On met le controle dans une seule fonction
		caissonC = new CaissonCuisine();
		caissonC.setName(getName());
		caissonC.setBackmaterial(getBackmaterial());
		caissonC.setBackmaterialfree(true);
		caissonC.setBasematerialfree(true);
		caissonC.setBasematerial(getBasematerial());
		caissonC.setLongeurext(getLongeur());
		caissonC.setHauteurext(getHauteur());
		caissonC.setProfondeurext(getProfondeur());
		caissonC.setCuissontype(CaissonType.MONO_CAISSON);
		caissonC.setPorttype(PortType.FRANCAISE);
		caissonC.setCaissoncuisineType(getCaissoncuisineType());
		caissonC.setCaissonMontageType(CaissonMontageType.CAISSON_MONTAGE_L);
		caissonC.setParentdesign(parent);
		caissonC.constructDebitage();

		
		caissonC.evaluate();		

		
		Piece2DCreator piececreator = new Piece2DCreator();
//		//creer les pieces necessaires

		piececreator.setName("Bas");
		//Imed bug 0001710 correction calcul de debitage de rainure
		piececreator.setBackmaterial(getBackmaterial());
		piececreator.setBasematerial(getBasematerial());
		if(caissonC.getCaissoncuisineType().equals(CuisineCaissonType.Bas_sousevier))
		{
			piececreator.setPiecetype(PieceType.BAS_CUISSON_SOUSEVIER);
		}
		else {
			piececreator.setPiecetype(PieceType.BAS_CUISSON);
		}
		piececreator.setMaterial(caissonC.getBasematerial());
		piececreator.setParent(caissonC);		
		piececreator.create();
		caissonC.addElement(piececreator.getPiece2DInstance());
		

		
		if(caissonC.getCaissoncuisineType().equals(CuisineCaissonType.haut)||caissonC.getCaissoncuisineType().equals(CuisineCaissonType.colonne))
		{
			piececreator.setName("Haut");
			piececreator.setPiecetype(PieceType.HAUT_CUISSON);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
		}
		else
		{
			
			piececreator.setName("Bande Arriere");
			piececreator.setPiecetype(PieceType.BANDE_ARRIERE);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
			
			piececreator.setName("Bande Avant");
			piececreator.setPiecetype(PieceType.BANDE_AVANT);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
		}

		if(caissonC.getCaissoncuisineType().equals(CuisineCaissonType.Bas_four)) {
			piececreator.setName("BANDE_FOUR_BAS_FACE");
			piececreator.setPiecetype(PieceType.BANDE_FOUR_BAS_FACE);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
			
			piececreator.setName("BANDE_FOUR_BAS_GAUCHE1");
			piececreator.setPiecetype(PieceType.BANDE_FOUR_BAS_GAUCHE1);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
			
			piececreator.setName("BANDE_FOUR_BAS_GAUCHE2");
			piececreator.setPiecetype(PieceType.BANDE_FOUR_BAS_GAUCHE2);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
			
			
			
			piececreator.setName("BANDE_FOUR_BAS_DROITE1");
			piececreator.setPiecetype(PieceType.BANDE_FOUR_BAS_DROITE1);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
			
			piececreator.setName("BANDE_FOUR_BAS_DROITE2");
			piececreator.setPiecetype(PieceType.BANDE_FOUR_BAS_DROITE2);
			piececreator.setMaterial(getBasematerial());
			piececreator.setParent(caissonC);	
			piececreator.create();
			caissonC.addElement(piececreator.getPiece2DInstance());
		}
		
		piececreator.setName("Cote Droite");
		piececreator.setPiecetype(PieceType.DROITE_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.setParent(caissonC);		
		piececreator.create();
		caissonC.addElement(piececreator.getPiece2DInstance());

		
		
		piececreator.setName("Cote Gauche");
		piececreator.setPiecetype(PieceType.GAUCHE_CUISSON);
		piececreator.setMaterial(getBasematerial());
		piececreator.setParent(caissonC);	
		piececreator.create();
		caissonC.addElement(piececreator.getPiece2DInstance());

		if(isWithDos() )
		{

				piececreator.setName("Dos");
				if(getDostype().equals(DosType.DOSEXTERIEUR))
				{
					piececreator.setPiecetype(PieceType.DOS_EXTERIRUR);
				}
				else if( getDostype().equals(DosType.DOSINTERIEUR))
				{
					piececreator.setPiecetype(PieceType.DOS_INTERIEUR);
				}

				piececreator.setMaterial(getBackmaterial());
				piececreator.create();
				caissonC.addElement(piececreator.getPiece2DInstance());
		}

	
	}
}
