package reporting.htmlReporting.model;

public class HtmlPageSeparator extends HtmlElement {
	private static HtmlPageSeparator instance;
	
	public static HtmlPageSeparator getInstance() {
		synchronized(HtmlPageSeparator.class) {
			if (instance == null) {
				instance = new HtmlPageSeparator();
			}
			return instance;
		}
	}
	public HtmlPageSeparator() {
		this("content");
		HtmlStyleAttribute style=new HtmlStyleAttribute();
		setText("page separator");
		style.appendAttribute("visibility", "hidden");
		style.appendAttribute("height", "0px");
		style.appendAttribute("overflow", "hidden");
		style.appendAttribute("page-break-after", "always");
		appendAttribute("style", style);
	}

	public HtmlPageSeparator(String name) {
		super(name);
	}

}
