package dressing.ui.project;

import java.util.List;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import dressing.model.ModelProvider;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.WorldObject;
import gdxapp.shaders.PbrMaterial;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class FloorSettingFormComposite extends Composite {

	private GeometryObject worldObject;
	private TableComboViewer tcvTexture;
	private Button btnPreview;

	protected FloorSettingFormComposite FloorSettingFormCompositeinstance;

	public FloorSettingFormComposite getFloorSettingFormCompositeinstance() {
		return FloorSettingFormCompositeinstance;
	}

	public void setFloorSettingFormCompositeinstance(FloorSettingFormComposite floorSettingFormCompositeinstance) {
		FloorSettingFormCompositeinstance = floorSettingFormCompositeinstance;
	}

	SingleImageItemLabelProvider labelProvider;
	private Spinner SPepaisseur;
	private Spinner SPhauteure;

	public FloorSettingFormComposite(Composite parent, int style, GeometryObject worldObjectX, List input) {
		super(parent, style);
		this.worldObject = worldObjectX;
		setLayout(new GridLayout(1, false));

		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setLayout(new GridLayout(1, false));

		CBanner banner = new CBanner(composite, SWT.NONE);
		banner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, true, 1, 1));
		banner.setRightWidth(300);
		banner.setRightMinimumSize(new Point(300, 300));
		banner.setLocation(0, 0);

		Composite composite_1 = new Composite(banner, SWT.NONE);
		banner.setLeft(composite_1);
		GridLayout gl_composite_1 = new GridLayout(1, true);
		gl_composite_1.marginBottom = 50;
		gl_composite_1.marginTop = 50;
		composite_1.setLayout(gl_composite_1);

		Composite composite_3 = new Composite(composite_1, SWT.NONE);
		composite_3.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_3.setLayout(new GridLayout(2, false));

		labelProvider = new SingleImageItemLabelProvider(composite_3);

		Label lblTexture = new Label(composite_3, SWT.NONE);
		lblTexture.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
		lblTexture.setText("Motif");

		tcvTexture = new TableComboViewer(composite_3, SWT.NONE);
		TableCombo tcTexture = tcvTexture.getTableCombo();
		tcTexture.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		tcvTexture.setContentProvider(ArrayContentProvider.getInstance());
		tcvTexture.setLabelProvider(labelProvider);
		tcvTexture.setInput(input);

		tcvTexture.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				textureChanged();
			}
		});

		Composite composite_2 = new Composite(banner, SWT.NONE);
		banner.setRight(composite_2);
		composite_2.setLayout(new GridLayout(1, false));
		btnPreview = new Button(composite_2, SWT.NONE);
		btnPreview.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
	
		Label lblHauteur = new Label(composite_1, SWT.NONE);
		lblHauteur.setText("Hauteur");

		SPhauteure = new Spinner(composite_1, SWT.BORDER);
		SPhauteure.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		SPhauteure.setMaximum(5000);
		SPhauteure.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				if(worldObject != null) {
					float hauteur = SPhauteure.getSelection() / 1000f;
					worldObject.getRealWorldPosition().y = hauteur;
				}
			}
		});


		Label lblEpaisseur = new Label(composite_1, SWT.NONE);
		lblEpaisseur.setText("Épaisseur");

		SPepaisseur = new Spinner(composite_1, SWT.BORDER);
		SPepaisseur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		SPepaisseur.setMaximum(10000);
		SPepaisseur.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
				if(worldObject != null) {
					float epaisseur = SPepaisseur.getSelection() / 1000f;
					worldObject.setRealWorldDimension(worldObject.getGeometry().getRealWorldDimension(epaisseur));
				}
			}
		});

		if(worldObject != null)
			bind();

	}

	public void bind() {
		PbrMaterial material = worldObject.getGeometry().getBorder().getMaterial();
		PbrMaterial selection = ModelProvider.findMaterial(null ,material.getName());
		tcvTexture.setSelection(new StructuredSelection(selection));
		
		int height = Math.round(worldObject.getRealWorldPosition().y * 1000);
		SPhauteure.setSelection(height);
		
		int thickness = Math.round(worldObject.getRealWorldDimension().y * 1000);
		SPepaisseur.setSelection(thickness);
	}

	protected void textureChanged() {
		PbrMaterial floorMtl = (PbrMaterial) tcvTexture.getStructuredSelection().getFirstElement();
		if (floorMtl != null) {
			if (btnPreview != null)
				btnPreview.setImage(ModelProvider.getTexture(floorMtl.getAlbedoMapPath()).getPreview());
			worldObject.getGeometry().getBorder().setMaterial(floorMtl);
		}

	}

	public WorldObject getWorldObject() {
		return this.worldObject;
	}

	public void setWorldObject(GeometryObject worldObject) {
		this.worldObject = worldObject;
		bind();
	}
	
	public void setMaterialsList(List<PbrMaterial> materials) {
		if(this.tcvTexture != null)
			this.tcvTexture.setInput(materials);
	}
	

}
