package dressing.ui.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Kitchen;
import dressing.model.ObservableEntity;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;
import dressing.model.Project3D;
import dressing.model.ProjectManager;
import dressing.model.ProjectRoot;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.SuperCadProject;
import dressing.model.Tirroir;
import dressing.model.TreeElement;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.usinage.Usinage;
import dressing.ui.ProjectTreeContentProvider;
import dressing.ui.cam.parts.GcodeEditorPart;
import dressing.ui.modelprovders.DimHLabelProvider;
import dressing.ui.modelprovders.DimLLabelProvider;
import dressing.ui.modelprovders.DimPLabelProvider;
import dressing.ui.modelprovders.TreeElementLabelProvider;
import dressing.ui.util.ListenerSelection;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.e4.ui.workbench.modeling.EPartService.PartState;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormAttachment;

public class ProjectExplorerPart {

	@Inject
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;
	@Inject
	EPartService partService;
	@Inject
	private EHandlerService handlerService;
	@Inject
	private EModelService modelService;
	@Inject
	private ECommandService commandService;
	
	@Inject
	 MWindow window;
	@Inject
	private MDirtyable dirty;
	@Inject
	private IEventBroker eventBroker;

	SuperCadProject project;
	ProjectRoot root;
	Object selectedObj;
	TreeViewer treeViewer;
	ListenerSelection listenerSelection;
	@PostConstruct
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new FormLayout());
		this.treeViewer = new TreeViewer(composite, SWT.BORDER | SWT.MULTI);
		Tree tree = treeViewer.getTree();
		FormData fd_tree = new FormData();
		fd_tree.top = new FormAttachment(0);
		fd_tree.left = new FormAttachment(0);
		fd_tree.bottom = new FormAttachment(100);
		fd_tree.right = new FormAttachment(100);
		tree.setLayoutData(fd_tree);

		treeViewer.setContentProvider(new ProjectTreeContentProvider());

		TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn column = viewerColumn.getColumn();
		column.setText("Nom");
		column.setWidth(300);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new TreeElementLabelProvider()));

		TreeViewerColumn viewerColumnL = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn columnL = viewerColumnL.getColumn();
		columnL.setText("Longeur");
		columnL.setWidth(50);
		viewerColumnL.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimLLabelProvider()));
		
		TreeViewerColumn viewerColumnH = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn columnH = viewerColumnH.getColumn();
		columnH.setText("Largeur");
		columnH.setWidth(50);
		viewerColumnH.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimHLabelProvider()));
		TreeViewerColumn viewerColumnP = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn columnP = viewerColumnP.getColumn();
		columnP.setText("Profondeur");
		columnP.setWidth(50);
		viewerColumnP.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimPLabelProvider()));

		
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				Object selectionobj = selection.size() == 1 ? selection.getFirstElement() : selection.toList();
				selectionService.setSelection(selectionobj);
				selectedObj = selectionobj;
			}
		});
		listenerSelection=new ListenerSelection(selectionService);
		root = ProjectManager.getManager().getRoot();

		root.addPropertyChangeListener(new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				if(!treeViewer.getControl().isDisposed()){
					treeViewer.getControl().getDisplay().asyncExec(new Runnable() {
						@Override
						public void run() {
							if(!treeViewer.getControl().isDisposed()){
								treeViewer.refresh(true);
								treeViewer.getAutoExpandLevel();
								dirty.setDirty(true);
							}
						}
					});
				}
			}
		});

		treeViewer.setInput(this.root);

		eventBroker.subscribe("newprojectcreated", new EventHandler() {
			@Override
			public void handleEvent(Event event) {
				ProjectManager.getManager().openCurrentProject();
				project = ProjectManager.getManager().getCurrentProject();
				root.setProject(project);
				project.setRoot(root);

			}
		});

		eventBroker.subscribe("Add_MODEL", new EventHandler() {
			@Override
			public void handleEvent(Event event) {
				Object obj = ProjectExplorerPart.this.selectedObj;
				if (obj != null && obj instanceof Kitchen) {
					Object data = event.getProperty("org.eclipse.e4.data");
					if (data != null && data instanceof Space3D) {
						DesignObject3D designobject = (DesignObject3D) data;
						Kitchen kitchen = (Kitchen) obj;
						try {
							kitchen.addElement(designobject);
						} catch (DesignException e) {
							e.printStackTrace();
						}
					}
				}
			}
		});
		

		treeViewer.addOpenListener(new IOpenListener() {

			@Override
			public void open(OpenEvent event) {

				// DesignObject3D object= (DesignObject3D) event.getSelection();
				IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				Object selectionobj = selection.size() == 1 ? selection.getFirstElement() : selection.toList();
				if (selectionobj instanceof Piece2D) {
					Collection<MPart> parts = partService.getParts();
					for (MPart par : parts) {
						if (par.getElementId().equals("dressing.ui.cam.parts.GcodeEditorPart")) {
							GcodeEditorPart p = (GcodeEditorPart) par.getObject();
							if (p != null && p.getPiece().equals((Piece2D) selectionobj)) {
								partService.activate(par);
								partService.bringToTop(par);
								return;
							}
						}
					}
					MPart part = partService.createPart("dressing.ui.cam.parts.GcodeEditorPart");

					// Set the input

					part.getTransientData().put("piece", (Piece2D) selectionobj);

					boolean isontop = part.isOnTop();
					// Add to editor part stack

					MPartStack editorStack = (MPartStack) partService.findPart("dressing.partstack.9");

					// editorStack.getChildren().add(part);
					// modelService.find(id, searchRoot)
					// Show
					MUIElement stack = modelService.find("dressing.partstack.9", window);
					part.setCloseable(true);
					part.setLabel(((Piece2D) selectionobj).getName());
					partService.showPart(part, PartState.ACTIVATE);
				}
			}
		});

		// menu
		MenuManager menuMgr = new MenuManager();

		Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
		menuMgr.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				if (treeViewer.getSelection().isEmpty()) {
					return;
				}
				if (treeViewer.getSelection() instanceof IStructuredSelection) {
					IStructuredSelection selection = (IStructuredSelection) treeViewer.getSelection();
					Object object = selection.getFirstElement();
					// Imed bug 0001710 ajouter une action pour exporter un projet vers dxf
					Action exportdxfAction = new Action("Exporter DXF") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.exportdxf", null);
							handlerService.executeHandler(cmd);
						};
					};
					Action exportgcodeActionAction = new Action("Exporter Gcode") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.saveas", null);
							handlerService.executeHandler(cmd);
						};
					};
					Action generateGcodeAction = new Action("Générer Usinage") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.generategcode",
									null);
							handlerService.executeHandler(cmd);
						};
					};
					Action generateFicheDebitAction=new Action("Générer rapport fiche du débitage") {
						public void run() {
							ParameterizedCommand cmd = commandService.createCommand("dressing.command.ficheDebit",null);
							handlerService.executeHandler(cmd);
						};
					};
					if(object instanceof Kitchen) {
						manager.add(generateGcodeAction);
					}
					
					if ((object instanceof DesignObject3D&& !(object instanceof Usinage))|| object instanceof Kitchen) {
						manager.add(new Action("Copier les pièces vers Excell -Sans Grouper") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_NONE);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});

						manager.add(new Action("Copier les pièces vers Excell -Grouper Tous") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_ALL);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Parent") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_PARENT);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Projet") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_PROJECT);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Dressing") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby",
										Piece2DCoupe.GROUPBY_DRESSING);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Copier les pièces vers Excell -Grouper par Caisson") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.copyexcell.groupby", Piece2DCoupe.GROUPBY_CAISSON);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);
								handlerService.executeHandler(cmd);
							};
						});
						
						manager.add(new Action("Générer SVG") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.svgsubject.piece", "svg");
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.AppliquerAccessoire", param);
								handlerService.executeHandler(cmd);
							};
						});
						//
						manager.add(new Action("Appliquer Accessoires") {
							public void run() {
								ArrayList<DesignObject3D>listpiece=new ArrayList<DesignObject3D>();
								listpiece=(ArrayList<DesignObject3D>) ((DesignObject3D)object).getChilds();
								String objectname=((DesignObject3D)object).getName();
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.AppliquerAccessoire", objectname);
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.AppliquerAccessoire", param);
								handlerService.executeHandler(cmd);
							};
						});
						
						
					}

					if (object instanceof SuperCadProject) {

						manager.add(new Action("Ajouter un dressing") {
							public void run() {
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.create.wizard", null);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Ajouter une cuisine") {
							public void run() {
								ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.cuisine",
										null);
								handlerService.executeHandler(cmd);
							};
						});
						manager.add(new Action("Fermer") {
							public void run() {
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.close.project", null);
								handlerService.executeHandler(cmd);
							};
						});

						manager.add(new Action("Générer rapport avec usinage") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.reportWithUsin", "true");
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.birtreport", param);
								handlerService.executeHandler(cmd);
							};
						});

						manager.add(new Action("Générer rapport avec usinage Côtés") {
							public void run() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.reportWithUsin", "false");
								param.put("dressing.commandparameter.reportWithUsinCote", "true");
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.birtreport", param);
								handlerService.executeHandler(cmd);
							};
							public boolean isEnabled() {
								HashMap<String, Object> param = new HashMap<>();
								param.put("dressing.commandparameter.reportWithUsin", "false");
								param.put("dressing.commandparameter.reportWithUsinCote", "true");
								ParameterizedCommand cmd = commandService
										.createCommand("dressing.command.birtreport", param);
								return handlerService.canExecute(cmd);
							};
							
						});
						manager.add(generateFicheDebitAction);
					}
					// Imed bug 0001710 ajouter une action pour exporter un projet vers dxf
					if(object!=null && (object instanceof Kitchen || object instanceof SuperCadProject || object instanceof Space3DFree)) 
					{	manager.add(exportdxfAction);
						manager.add(exportgcodeActionAction);
						manager.add(generateGcodeAction);
					}
					if (object instanceof DesignObject3D && !(object instanceof Project3D)) {
						manager.add(new Action("Supprimer") {
							public void run() {
								ParameterizedCommand cmd = commandService.createCommand("dressing.command.delete",
										null);
								handlerService.executeHandler(cmd);
							};
						});
					}
				}
			}
		});
		menuMgr.setRemoveAllWhenShown(true);
		treeViewer.getControl().setMenu(menu);

	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		treeViewer.getControl().setFocus();
	}

	@Persist
	public void save() throws DesignException {
		if(ProjectManager.getManager().getCurrentProject()!=null)
		{
			ProjectManager.getManager().saveProject(ProjectManager.getManager().getCurrentProject(),false,false);
			dirty.setDirty(false);
		}
	}

}
