package dressing.ui.library;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;

import dressing.controller.EtagereCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.Caisson;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;

public class ExportModelWelcomePage extends WizardPage {
	PropertyChangeListener pcl;
	boolean serrorfound = true;
	boolean terrorfound = true;
	Cuisine cuisine;
	Caisson caisson;
	LibraryModelsTree modelTreeComposite;
	String caissonName;
	ISelectionChangedListener selectlistener;
	public ExportModelWelcomePage(String pageName, Caisson casisson) {
		super(pageName);
		setTitle("Etagere information");
		setDescription("S'il vous plais entrer le nom de votre model");
		setPageComplete(false);
		setCaisson(casisson);
	}

	@Override
	public void createControl(Composite parent) {
		modelTreeComposite = new LibraryModelsTree(parent, SWT.BORDER);
		setCaissonName(getCaisson().getName());
		modelTreeComposite.setCaissonName(getCaissonName());
		setControl(modelTreeComposite);
		selectlistener =new ISelectionChangedListener() {
			
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				  IStructuredSelection selection = (IStructuredSelection) event.getSelection();
			    if(selection!=null &&selection.size()==1
			    		&&( selection.getFirstElement() instanceof Cuisine )) {
			    	cuisine=(Cuisine) selection.getFirstElement();
			    	serrorfound = false;
			    	setPageComplete(true);
			    }else {
			    	serrorfound = true;
			    	setPageComplete(false);
			    }
			}
		};
		modelTreeComposite.addSelectionListner(selectlistener);
		modelTreeComposite.getCaissonNameTextField().addModifyListener(new ModifyListener() {
			
			@Override
			public void modifyText(ModifyEvent e) {
				String caissonName = modelTreeComposite.getCaissonNameTextField().getText();
				if(caissonName==null ||caissonName.isEmpty() ) {
					terrorfound = true;
			    	setPageComplete(false);
				}else {
					setCaissonName(caissonName);
					terrorfound = false;
					setPageComplete(true);
				}
					
			}
		});
		String caissonName = modelTreeComposite.getCaissonNameTextField().getText();
		if(caissonName==null ||caissonName.isEmpty() ) {
			terrorfound = true;
		}else {
			terrorfound = false;
		}
		 IStructuredSelection selection = (IStructuredSelection) modelTreeComposite.getSelection();
		    if(selection!=null &&selection.size()==1
		    		&&( selection.getFirstElement() instanceof Cuisine ||selection.getFirstElement() instanceof Dressing )) {
		    	serrorfound = false;
		    	setPageComplete(true);
		    }else {
		    	serrorfound = true;
		    	setPageComplete(false);
		    }
		
	}
	
	public Cuisine getCuisine() {
		return cuisine;
	}

	public void setCuisine(Cuisine cuisine) {
		this.cuisine = cuisine;
	}

	public Caisson getCaisson() {
		return caisson;
	}

	public String getCaissonName() {
		return caissonName;
	}

	public void setCaissonName(String caissonName) {
		this.caissonName = caissonName;
	}

	public void setCaisson(Caisson caisson) {
		this.caisson = caisson;
	}
	public void clearlistners() {
		modelTreeComposite.removeSelectionListner(selectlistener);
	}

	@Override
	public boolean isPageComplete() {

		boolean b = !serrorfound&&!terrorfound;
		return b;
	}

}
