package dressing.ui.caissonciosine;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.CaissonCuisineCreator;
import dressing.controller.CuisineCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.DesignException;
import dressing.model.Separator;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;
import dressing.ui.cuisine.CuisineWizardComposite;

public class CaissonCuisineWizardPage extends WizardPage {
	CaissonCuisineCreator caisson;
	PropertyChangeListener pcl;
	PropertyChangeListener pcl2;
	boolean errorfound=false;
	
	
	public CaissonCuisineCreator getCaisson() {
		return caisson;
	}

	public void setCaisson(CaissonCuisineCreator caisson) {
		this.caisson = caisson;
	}

	/**
	 * Create the wizard.
	 */
	public CaissonCuisineWizardPage() {
		super("wizardPage");
		setTitle("Wizard Page title");
		setDescription("Wizard Page description");
	}

	public CaissonCuisineWizardPage(String pageName, CaissonCuisineCreator caisson) {
		// TODO Auto-generated constructor stub
		super(pageName);
		setTitle("Wizard Page title");
		setDescription("Wizard Page description");
		setPageComplete(false);
		setCaisson(caisson);
	}

	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		CaissonCuisineDialogComposite container = new CaissonCuisineDialogComposite(parent, SWT.BORDER,caisson);
		
		setControl(container);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {						
						caisson.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre cuisine", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		caisson.addPropertyChangeListener(pcl);
		//ajouter un propertychangelistener pour override le seppostion lorsque choisire separator isometrique
		pcl2 =new PropertyChangeListener() {
					
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
						if(evt.getPropertyName().equals("caissoncuisinetype")){
							if(evt.getNewValue().equals(CuisineCaissonType.colonne)) {
								caisson.setProfondeur(CaissonCuisineCreator.COLONNE_PROFONDEUR);
								caisson.setLongeur(CaissonCuisineCreator.COLONNE_LONGEUR);
								caisson.setHauteur(CaissonCuisineCreator.COLONNE_HAUTEUR);
							}
							else if(evt.getOldValue().equals(CuisineCaissonType.colonne)&&	!(evt.getNewValue().equals(CuisineCaissonType.colonne))) {
								caisson.setHauteur(caisson.getParent().getHauteurext());
								caisson.setProfondeur(caisson.getParent().getProfondeurext());
								caisson.setLongeur(600);
							}
						
						}

	}
		};
	caisson.addPropertyChangeListener(pcl2);
	}

	@Override
	public boolean isPageComplete() {
		// TODO Auto-generated method stub
		boolean b = !errorfound;
		return b;
	}
	public void clearlistners() {
		caisson.removePropertyChangeListener(pcl);
	}

}
