package dressing.model;

import java.util.ArrayList;
import java.util.List;

import dressing.model.debitage.Debitage;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.TrouType;
import dressing.model.usinage.Direction;
import dressing.model.usinage.Trou;

public class Etagere extends Piece2D {


	Space3D parentspace;
	double sepposition;
	PositionCalculationType postype;
	SeprationAxe sepaxe;
	double retraitFacade=0;
	
	
	
	public double getRetraitFacade() {
		return retraitFacade;
	}

	public void setRetraitFacade(double retraitFacade) {
		double oldValue=this.retraitFacade;
		this.retraitFacade = retraitFacade;
		firePropertyChange("retraitFacade", oldValue,retraitFacade);	
	}

	public Space3D getParentspace() {
		return parentspace;
	}
	
	public void setParentspace(Space3D parentspace) {
		Space3D oldValue=this.parentspace;
		this.parentspace = parentspace;
		firePropertyChange("parentspace", oldValue,parentspace);	
	}

	public double getSepposition() {
		return sepposition;
	}

	public void setSepposition(double sepposition) {
		double oldValue=this.sepposition;
		this.sepposition = sepposition;
		firePropertyChange("sepposition", oldValue,sepposition);	
	}

	public PositionCalculationType getPostype() {
		return postype;
	}

	public void setPostype(PositionCalculationType postype) {		
		PositionCalculationType oldValue=this.postype;
		this.postype = postype;
		firePropertyChange("postype", oldValue,postype);
	}

	public SeprationAxe getSepaxe() {
		return sepaxe;
	}

	public void setSepaxe(SeprationAxe sepaxe) {
		SeprationAxe oldValue=this.sepaxe;
		this.sepaxe = sepaxe;
		firePropertyChange("sepaxe", oldValue,sepaxe);
	}

	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		return super.canHold(child);
	}
	public Etagere() {
		super();
		// TODO Auto-generated constructor stub
	}

	public Etagere(Space3D parentspace, double sepposition, PositionCalculationType postype, SeprationAxe sepaxe , double retraitFacade) {
		super();
		this.parentspace = parentspace;
		this.sepposition = sepposition;
		this.postype = postype;
		this.sepaxe = sepaxe;
		this.retraitFacade=retraitFacade;
	}
	
	//0001217: ajouter le calcul des rainure et les trous d'usinage
	//parcourir les piece(cotes) supporteur et créer pour chacun deux trous 
	//et dans le debitage en calcul son positions dynamyquement en dépendent de ses régle spécifique 
	//et le position relative de ce etage qui se n'appelle "ParentEtagere" pour que le position de ces trous soit toujours correcte; 	
	@Override
	public void createUsinage() throws GeometricEngineException, DesignException {
		List<Piece2D> cotes=getcotebrohters();
		DesignObject3D caisson= getRootCaisson();
		for(Piece2D piece:cotes) {
			Trou tr1=new Trou();
			tr1.setTrouType(TrouType.ETAGERE_MOBILE_BACK);
			tr1.setMother(this);
			Trou tr2=new Trou();
			tr2.setTrouType(TrouType.ETAGERE_MOBILE_FRONT);
			tr2.setMother(this);
			if(piece.getPiecetype().equals(PieceType.GAUCHE_CUISSON)) {
				tr1.setDirection(Direction.XMINUS);
				tr2.setDirection(Direction.XMINUS);
			}else if(piece.getPiecetype().equals(PieceType.DROITE_CUISSON)) {
				tr1.setDirection(Direction.XPLUS);
				tr2.setDirection(Direction.XPLUS);
			}
			tr1.setName("Trou 1 "+this.getName());
			tr2.setName("Trou 2 "+this.getName());

			piece.addElement(tr1);
			piece.addElement(tr2);
			if(piece.debitage!=null)
				piece.debitage.createupdateDebitage();
			else
				piece.constructDebitage();
			
			piece.evaluate();	
			piece.propagateUpdateToChildrens(null);
		}
		
	}
	//0001217: ajouter le calcul des rainure et les trous d'usinage
	//pour claculer les trous des support de l'etgare en doit chercher les cotée supporteur
	public List<Piece2D> getcotebrohters(){
		List<Piece2D> cotes=new ArrayList<Piece2D>();
		DesignObject3D caisson= getRootCaisson();
		for(DesignObject3D piece:caisson.getChilds()) {
			if(piece instanceof Piece2D) {
				Piece2D piece2d=(Piece2D) piece;
				if(piece2d.getPiecetype().equals(PieceType.GAUCHE_CUISSON)||piece2d.getPiecetype().equals(PieceType.DROITE_CUISSON)) {
					cotes.add(piece2d);
				}
			}
		}				
		return cotes;
	}
	
	@Override
	public DesignObject3D clone() {
		Etagere etagere=new Etagere();
		try {
			etagere=(Etagere) this.copy(etagere);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return etagere;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Etagere etagere=(Etagere) object;
		etagere=(Etagere) super.copy(etagere);
		etagere.setSepposition(getSepposition());
		etagere.setRetraitFacade(getRetraitFacade());
		etagere.setPostype(getPostype());
		etagere.setSepaxe(getSepaxe());
		return etagere;
	}
}
