package dressing.model;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.PortType;


public class Dressing extends Space3D {
	 final static double MIN_LONGEUR=200;
	 final static double MIN_PROFONDEUR=200;
	 final static double MIN_HAUTEUR=200;	
	 final static double MIN_CUISSON_LONGEUR_INTERNE=100;
	 final static double MIN_CUISSON_PROFONDEUR_INTERNE=100;
	 final static double MIN_CUISSON_HAUTEUR_INTERNE=100;
	 final static double MIN_POSITION_ETAGERE_FIXE=50;
	 final static double MIN_ETAGERE_INTER_DISTANCE=10;
	 final static double RAINURE_DOS_POSITION_OFFSET=10;
	 final static double RAINURE_DOS_DEPTH=3.5;
	 final static double PORT_JEU=3;
	 final static double PORT_MAX_LONGEUR=600;
	 final static double ETAGERE_MOBILE_JEU=1;
	 PortType porttype;
	 String chantier;
	 String etage;
	 String appartement;
	 private CaissonMontageType caissonmontageType;
	 public Dressing() {
		// TODO Auto-generated constructor stub
//		 this.addPropertyChangeListener(new PropertyChangeListener() {
//			
//			@Override
//			public void propertyChange(PropertyChangeEvent evt) {
//				// TODO Auto-generated method stub
//				if(evt.getPropertyName()=="longeurextfree"  && 
//						((Caisson)evt.getSource()).getParentdesign() == Dressing.this) {
//					//
//							try
//							{
//								update();
//							}
//							catch( Exception e)
//							{
//							System.out.println(e.getMessage());	
//							}
//					//
//				}
//			}
//		});
	}
	public String getChantier() {
		return chantier;
	}

	public void setChantier(String chantier) {
		
		String oldValue = this.chantier;
		this.chantier = chantier;
		firePropertyChange("chantier", oldValue, chantier);
	}

	public String getEtage() {
		return etage;
	}

	public void setEtage(String etage) {
		String oldValue = this.etage;
		this.etage = etage;
		firePropertyChange("etage", oldValue, etage);
	
	}

	public String getAppartement() {
		return appartement;
	}

	public void setAppartement(String appartement) {
		
		String oldValue = this.appartement;
		this.appartement = appartement;
		firePropertyChange("appartement", oldValue, appartement);
	}

	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		return true;
	}
	
	
	
	public String printDescription()
	{		
		String s="";
		s+=" Dressing "  + getChantier() +"\n";
		s+=" Dressing "  + getEtage() +"\n";
		s+=" Dressing "  + getAppartement() +"\n";
		s+=" Dressing "  + getName() +"\n";
		s+=" Longeur extenre "  + getLongeurext() +" mm \n";
		s+=" Hauteur extenre "  + getHauteurext() +" mm \n";
		s+=" Profondeur extenre "  + getProfondeurext() +" mm \n";		
		s+=" Longeur interne "  + getLongeurint() +" mm \n";
		s+=" Hauteur interne "  + getHauteurint() +" mm \n";
		s+=" Profondeur interne "  + getProfondeurint() +" mm \n";
		
		s+="#################### Les sous elements ########## \n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	
	
	public CaissonMontageType getCaissonmontageType() {
		return caissonmontageType;
	}
	public void setCaissonmontageType(CaissonMontageType caissonmontageType) {		
		CaissonMontageType oldValue = this.caissonmontageType;
		this.caissonmontageType = caissonmontageType;
		firePropertyChange("caissonmontageType", oldValue, caissonmontageType);
	}
	public PortType getPorttype() {
		return porttype;
	}



	public void setPorttype(PortType porttype) {
		PortType oldValue = this.porttype;
		this.porttype = porttype;
		firePropertyChange("porttype", oldValue, porttype);
	}



	public void update()  throws Exception{
		// TODO Auto-generated method stub
		//Detect modification in longeur
		double longeurdressing = this.getLongeurext();
		double sumcuisson=0;
		double ecart=0;
		double cuissonscalablecount=0;
		double cuissonsecartpart=0;
		double sumcuissonlongeur=longeurdressing;
		for(DesignObject3D obj : getChilds())
		{
			if(obj instanceof Caisson)
			{
				sumcuisson+=obj.getLongeurext();
				if(((Caisson) obj).isLongeurextfree())
				{
					sumcuissonlongeur-= obj.getLongeurext();
					continue;
				}
				else
				{
					cuissonscalablecount++;
				}
				
			}
		}
		if(sumcuisson!=longeurdressing)
		{
			ecart=longeurdressing-sumcuisson;
		}
		if(ecart!=0 && cuissonscalablecount>0)
		{
			//Ajouter la longeur restante pour tous les cuissons equivalents
			cuissonsecartpart=ecart/cuissonscalablecount;
		}
//		int ecartpart = (int)(cuissonsecartpart);
//		int reminder = (int) (ecart - cuissonsecartpart * cuissonscalablecount);
		int dispathcounter = 0;
		double cuissonlongeur=(int)(sumcuissonlongeur/cuissonscalablecount);
		int reminder = (int) (sumcuissonlongeur - cuissonlongeur * cuissonscalablecount);
		 for (DesignObject3D obj : getChilds()) {
		 	if (obj instanceof Caisson) {
				Caisson cuis = (Caisson) obj;
		 		cuis.updateMaterialFromParent(this);
		 		if(!cuis.isHauteurextfree())
		 			cuis.setHauteurext(getHauteurext());
		 				
		 		if(!cuis.isProfondeurextfree())		
					cuis.setProfondeurext(getProfondeurext());
		 				
		 		if (!cuis.isLongeurextfree()) {
		 			dispathcounter++;
		 			if (dispathcounter < cuissonscalablecount)
//						cuis.setLongeurext(cuis.getLongeurext() + ecartpart);
		 				cuis.setLongeurext(cuissonlongeur);	
		 			else
//						cuis.setLongeurext(cuis.getLongeurext() + ecartpart + reminder);
						cuis.setLongeurext(cuissonlongeur + reminder);	
		 				}
				try {
					cuis.propagateUpdateToChildrens(this);
					cuis.setErrorexist(false);
					cuis.setErrormsg("");
				} catch (Exception e) {
					// TODO: handle exception
					cuis.setErrorexist(true);
					cuis.setErrormsg(e.getMessage());
					this.setErrorexist(true);
					this.setErrormsg(e.getMessage());
					firePropertyChange("project.error", null, true);
					throw e;
				} finally {

				}

			}
		}
		setUpdatechildsPositions();
		this.setErrorexist(false);
		this.setErrormsg("");
//		firePropertyChange("project.modify", null, this);
		firePropertyChange("project.recalculate", null, this);
	}

	public void setLongeurSumOfchilds() {
		// TODO Auto-generated method stub
		double length=0;
		for(Object c : this.getChilds())
		{
			if(c instanceof Caisson)
			{
				length+= ((Caisson) c).getLongeurext();
			}
		}
		setLongeurext(length);
	}
	public void setUpdatechildsPositions() {
		// TODO Auto-generated method stub
		double xposcounter=0;
		for(DesignObject3D des : getChilds())
		{
			if(des instanceof Caisson)
			{
				des.setXpos(xposcounter);
				xposcounter+=des.getLongeurext();
			}
		}
	}
	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return getLongeurext();
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return getHauteurext();
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return getProfondeurext();
	}
	@Override
	public double getXPosition() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public double getYPosition() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public double getZPosition() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public List getChildren() {
		// TODO Auto-generated method stub
		return getChilds();
	}
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public void addElement(DesignObject3D child) throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		super.addElement(child);

		if(child!=null && !(this instanceof Cuisine))
		{
			child.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if(evt==null ) 
						return;
					if(evt.getSource()== null || !(evt.getSource() instanceof Caisson) ||
							((Caisson)evt.getSource()).getParentdesign()== null )
					return;
			
					if(((Caisson)evt.getSource()).getParentdesign().equals(Dressing.this)) 
					{
						if((evt.getPropertyName()=="longeurextfree" 								
							||(evt.getPropertyName()=="longeurext" &&
							((Caisson)evt.getSource()).isLongeurextfree()&&
							((Caisson)evt.getSource()).getLongeurext()< Dressing.this.getLongeurext())))
						{
								try
								{
									update();
								}
								catch( Exception e)
								{
								System.out.println(e.getMessage());	
								}
						}
					}
				}
			});
		}
		
	}
	@Override
	public void initafterread() {
		// TODO Auto-generated method stub
		super.initafterread();
			try {
				propagateUpdateToChildrens(null);
			} catch (GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (DesignException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
	}
	/**
	 * 
	 * @return L'objet design parent absolue dressing ou cuisine
	 */
	public DesignObject3D getRoot()
	{
		return this;
	}
	

	@Override
	public DesignObject3D clone() {
		Dressing space=new Dressing();
		try {
			space=(Dressing) this.copy((DesignObject3D)space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			e.printStackTrace();
		}
		return space;
	}
	@Override
	public DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException {
		Dressing dressing=(Dressing) object;
		dressing=(Dressing) super.copy(dressing);
		dressing.setPorttype(getPorttype());
		dressing.setChantier(getChantier());
		dressing.setEtage(getEtage());
		dressing.setAppartement(getAppartement());
		return dressing;
	}
}
