package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.jface.viewers.ISelection;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Materiaux;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;

public class DressingCreator implements Creator {
	public final static double MIN_LONGEUR = 200;
	public final static double MIN_PROFONDEUR = 200;
	public final static double MIN_HAUTEUR = 200;

	public final static double MIN_CUISSON_LONGEUR_INTERNE = 100;
	public final static double MIN_CUISSON_PROFONDEUR_INTERNE = 100;
	public final static double MIN_CUISSON_HAUTEUR_INTERNE = 100;
	public final static double MIN_POSITION_ETAGERE_FIXE = 50;
	public final static double MIN_ETAGERE_INTER_DISTANCE = 10;
	public final static double RAINURE_DOS_POSITION_OFFSET = 10;
	public final static double RAINURE_DOS_DEPTH = 3.5;
	public final static double PORT_JEU = 3;
	public final static double PORT_MAX_LONGEUR = 600;
	public final static double ETAGERE_MOBILE_JEU = 1;
	String name;
	String chantier;
	String etage;
	String appartement;
	double longeur = 3000;
	double hauteur = 2050;
	double profondeur = 650;

	int caissoncount = 3;
	Materiaux basematerial=new Materiaux();
	Materiaux backmaterial=new Materiaux();
	DosType dostype = DosType.DOSINTERIEUR;
	boolean withseprator = false;
	PositionCalculationType positionCalculationtype = PositionCalculationType.FIX;
	double separationposition;
	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
	boolean sepratortransversal = true;
	PortType porttype = PortType.FRANCAISE;
	Dressing dressing;
	DesignObject3D parent;
	boolean withporte = false;
	CaissonMontageType caissonMontageType=CaissonMontageType.CAISSON_MONTAGE_I;
	boolean separatorisometrique=false;
	PositionReferenceType sepPosRefType=PositionReferenceType.BAS;
	boolean sepnotisometrique=!separatorisometrique;
	double sepRetrait=0;
	double sepretraitderiere=0;

	public double getSepRetrait() {
		return sepRetrait;
	}
	public void setSepRetrait(double sepRetrait) {
		double oldValue = this.sepRetrait;
		this.sepRetrait = sepRetrait;
		firePropertyChange("sepRetrait", oldValue, sepRetrait);
	}
	public double getSepretraitderiere() {
		return sepretraitderiere;
	}
	public void setSepretraitderiere(double sepretraitderiere) {
		double oldValue = this.sepretraitderiere;
		this.sepretraitderiere = sepretraitderiere;
		firePropertyChange("sepretraitderiere", oldValue, sepretraitderiere);
	}
	public PositionCalculationType getPositionCalculationtype() {
		return positionCalculationtype;
	}
	public void setPositionCalculationtype(PositionCalculationType positionCalculationtype) {
		PositionCalculationType oldValue = this.positionCalculationtype;
		this.positionCalculationtype = positionCalculationtype;
		firePropertyChange("positionCalculationtype", oldValue, positionCalculationtype);
	}	
	public boolean isSepnotisometrique() {
		return !isSeparatorisometrique();
	}
	public void setSepnotisometrique(boolean sepnotisometrique) {
		boolean oldValue = this.sepnotisometrique;
		this.sepnotisometrique = sepnotisometrique;
		firePropertyChange("sepnotisometrique", oldValue, sepnotisometrique);
	}
	public PositionReferenceType getSepPosRefType() {
		return sepPosRefType;
	}
	public void setSepPosRefType(PositionReferenceType sepPosRefType) {
		PositionReferenceType oldValue=this.sepPosRefType;
		this.sepPosRefType = sepPosRefType;
		firePropertyChange("sepPosRefType", oldValue,sepPosRefType);
	}

	public boolean isSeparatorisometrique() {
		return separatorisometrique;
	}

	public void setSeparatorisometrique(boolean separatorisometrique) {
		boolean oldValue = this.separatorisometrique;
		this.separatorisometrique = separatorisometrique;
		firePropertyChange("separatorisometrique", oldValue, separatorisometrique);
		setSepnotisometrique(!this.separatorisometrique);
	}

	public String getChantier() {
		return chantier;
	}

	public void setChantier(String chantier) {
		
		String oldValue = this.chantier;
		this.chantier = chantier;
		firePropertyChange("chantier", oldValue, chantier);
	}

	public String getEtage() {
		return etage;
	}

	public void setEtage(String etage) {
		String oldValue = this.etage;
		this.etage = etage;
		firePropertyChange("etage", oldValue, etage);
	
	}

	public String getAppartement() {
		return appartement;
	}

	public void setAppartement(String appartement) {
		
		String oldValue = this.appartement;
		this.appartement = appartement;
		firePropertyChange("appartement", oldValue, appartement);
	}
	public CaissonMontageType getCaissonMontageType() {
		return caissonMontageType;
	}

	public void setCaissonMontageType(CaissonMontageType caissonMontageType) {
		CaissonMontageType oldValue = this.caissonMontageType;
		this.caissonMontageType = caissonMontageType;
		firePropertyChange("caissonMontageType", oldValue, caissonMontageType);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}

	public double getLongeur() {
		return longeur;
	}

	public void setLongeur(double longeur) {
		double oldValue = this.longeur;
		this.longeur = longeur;
		firePropertyChange("longeur", oldValue, longeur);
	}

	public double getHauteur() {
		return hauteur;
	}

	public void setHauteur(double hauteur) {
		double oldValue = this.hauteur;
		this.hauteur = hauteur;
		firePropertyChange("hauteur", oldValue, hauteur);
	}

	public double getProfondeur() {
		return profondeur;
	}

	public void setProfondeur(double profondeur) {
		double oldValue = this.profondeur;
		this.profondeur = profondeur;
		firePropertyChange("profondeur", oldValue, profondeur);
	}

	public PortType getPorttype() {
		return porttype;
	}

	public void setPorttype(PortType porttype) {
		PortType oldValue = this.porttype;
		this.porttype = porttype;
		firePropertyChange("porttype", oldValue, porttype);
	}

	public int getCaissoncount() {
		return caissoncount;
	}

	public void setCaissoncount(int caissoncount) {
		int oldValue = this.caissoncount;
		this.caissoncount = caissoncount;
		firePropertyChange("caissoncount", oldValue, caissoncount);
	}

	public Materiaux getBasematerial() {
		return basematerial;
	}

	public void setBasematerial(Materiaux basematerial) {
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}

	public Materiaux getBackmaterial() {
		return backmaterial;
	}

	public void setBackmaterial(Materiaux backmaterial) {
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

	public DosType getDostype() {
		return dostype;
	}

	public void setDostype(DosType dostype) {
		DosType oldValue = this.dostype;
		this.dostype = dostype;
		firePropertyChange("dostype", oldValue, dostype);
	}

	public boolean isWithseprator() {
		return withseprator;
	}

	public void setWithseprator(boolean withseprator) {
		boolean oldValue = this.withseprator;
		this.withseprator = withseprator;
		firePropertyChange("withseprator", oldValue, withseprator);
	}

	public boolean isSepratortransversal() {
		return sepratortransversal;
	}

	public void setSepratortransversal(boolean sepratortransversal) {
		boolean oldValue = this.sepratortransversal;
		this.sepratortransversal = sepratortransversal;
		firePropertyChange("sepratortransversal", oldValue, sepratortransversal);
	}
	

	public double getSeparationposition() {
		return separationposition;
	}

	public void setSeparationposition(double separationposition) {
		double oldValue = this.separationposition;
		this.separationposition = separationposition;
		firePropertyChange("separationposition", oldValue, separationposition);
	}

	public SeprationAxe getSeprationaxe() {
		return seprationaxe;
	}

	public void setSeprationaxe(SeprationAxe seprationaxe) {
		SeprationAxe oldValue = this.seprationaxe;
		this.seprationaxe = seprationaxe;
		firePropertyChange("seprationaxe", oldValue, seprationaxe);
	}

	public void setParent(DesignObject3D parent) {
		this.parent = parent;
	}

	public void create() throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		createSubElements();
	}

	public DesignObject3D getDressingInstance() {
		// TODO Auto-generated method stub
		return dressing;
	}

	public boolean isWithporte() {
		return withporte;
	}

	public void setWithporte(boolean withporte) {
		boolean oldValue = this.withporte;
		this.withporte = withporte;
		firePropertyChange("withporte", oldValue, withporte);
	}

	public void check() throws DesignException {
		if (getName() == null || getName().isEmpty())
			throw new DesignException("Le nom de dressing est obligatoire");

		if (getBasematerial() == null)
			throw new DesignException("Le matérieaux de base doit être rensigné");

		if (getBackmaterial() == null)
			throw new DesignException("Le matérieaux de dos doit être rensigné");

		if (getBasematerial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de base doit être superieur à 1 mm");

		if (getBackmaterial().getEpaisseur() <= 0)
			throw new DesignException("L'epaisseur de matérieaux de dos doit être superieur à 1 mm");

		if (caissoncount <= 0)
			throw new DesignException("Le nombre de cuisson doit être supérieur à 1");

//		if (porttype == PortType.COLISSANT)
//			throw new DesignException("Type " + porttype.toString() + " non supporté");

		if (getLongeur() < getProfondeur())
			throw new DesignException("La longeur de dressing est généralement plus grande que la profondeur");

		if (getLongeur() <= MIN_LONGEUR)
			throw new DesignException("La longeur minimum est de " + MIN_LONGEUR + " mm ");

		if (getHauteur() <= MIN_HAUTEUR)
			throw new DesignException("La hauteur minimum est de " + MIN_HAUTEUR + " mm ");

		if (getProfondeur() <= MIN_PROFONDEUR)
			throw new DesignException("La profondeur minimum est de " + MIN_PROFONDEUR + " mm ");

		double cuissonlongeurext = getLongeur() / caissoncount;

		double cuissonlongeurinterne = cuissonlongeurext - 2 * getBasematerial().getEpaisseur();

		if (cuissonlongeurinterne < MIN_CUISSON_LONGEUR_INTERNE)
			throw new DesignException("La longeur cuisson interne est inférieur à " + MIN_CUISSON_LONGEUR_INTERNE
					+ " mm  il faut vérifier la longeur de dressing , le nombre de cuisson ou bien l'epaisseur de matrieaux");

		double cuissonprofondeurext = getProfondeur();

		double cuissonprofondeurinterne = cuissonprofondeurext - getBackmaterial().getEpaisseur()
				- RAINURE_DOS_POSITION_OFFSET;

		if (cuissonprofondeurinterne < MIN_CUISSON_PROFONDEUR_INTERNE)
			throw new DesignException("La profendeur de  cuisson interne est inférieur à "
					+ MIN_CUISSON_PROFONDEUR_INTERNE
					+ " mm  il faut v�rifier la longeur de dressing , le nombre de cuisson ou bien l'epaisseur de matrieaux");

		double cuissonhauteurext = getHauteur();

		double cuissonhauteurinterne = cuissonhauteurext - 2 * getBasematerial().getEpaisseur();

		if (cuissonhauteurinterne < MIN_CUISSON_HAUTEUR_INTERNE)
			throw new DesignException("La hauteur de  cuisson interne est inférieur à " + MIN_CUISSON_HAUTEUR_INTERNE
					+ " mm  il faut v�rifier la longeur de dressing , le nombre de cuisson ou bien l'epaisseur de matrieaux");
		if (etage ==null )
			throw new DesignException(" l'etage du dressing doit etre renseigné");
		if ( appartement==null)
			throw new DesignException("l'appartement du dressing doit etre renseigné");
		if(getPositionCalculationtype().equals(PositionCalculationType.POURCENT)) {
			if(getSeparationposition()>=100) {
				throw new DesignException("le position de separation doit etre inférieur a 100%");
			}
		}
		if(getSepRetrait()+getSepretraitderiere()>getProfondeur()-100) {
			throw new DesignException(
					"la pronfondeur du separateur doit etre superieur ou egale a la profondeur minimale (100mm)");

		}
	}

	public void createSubElements() throws DesignException, GeometricEngineException {
		check(); // On met le controle dans une seule fonction

		dressing = new Dressing();
		dressing.setName(getName());
		//
		dressing.setChantier(parent.getName());
		dressing.setEtage(getEtage());
		dressing.setAppartement(getAppartement());
		//
		dressing.setBackmaterial(getBackmaterial());
		dressing.setBasematerial(getBasematerial());
		dressing.setHauteurext(getHauteur());
		dressing.setLongeurext(getLongeur());
		dressing.setProfondeurext(getProfondeur());
		dressing.setPorttype(getPorttype());
		dressing.setCaissonmontageType(getCaissonMontageType());
		dressing.setDostype(getDostype());
		dressing.setParentdesign(parent);
		dressing.constructDebitage();
		dressing.evaluate();

		double cuissonlongeurext = getLongeur() / caissoncount;
		int caissonlong = (int) cuissonlongeurext;
		int remind = (int) (getLongeur() - caissonlong * caissoncount);
		// Creation des cuisson avec des longeur identiques
		double xcounter = 0;
		for (int i = 0; i < caissoncount; i++) {

			CaissonCreator caissonmodel = new CaissonCreator();
			caissonmodel.setName("Caisson " + (i + 1));
			caissonmodel.setBackmaterial(getBackmaterial());
			caissonmodel.setBasematerial(getBasematerial());
			caissonmodel.setHauteur(getHauteur());
			caissonmodel.setCaissonMontageType(getCaissonMontageType());
			if (i < caissoncount - 1)
				caissonmodel.setLongeur(caissonlong);
			else
				caissonmodel.setLongeur(caissonlong + remind);

			caissonmodel.setProfondeur(getProfondeur());
			caissonmodel.setPorttype(getPorttype());
			caissonmodel.setParent(dressing);
			caissonmodel.setPorttype(getPorttype());
			caissonmodel.setDostype(getDostype());
			caissonmodel.setPositiontype(getPositionCalculationtype());
			caissonmodel.setSeparationposition(getSeparationposition());
			caissonmodel.setWithseprator(isWithseprator());
			caissonmodel.setSepratortransversal(isSepratortransversal());
			caissonmodel.setSeprationaxe(getSeprationaxe());
			caissonmodel.setWithporte(isWithporte());
			caissonmodel.setSeparatorisometrique(isSeparatorisometrique());
			caissonmodel.setSepPosRefType(getSepPosRefType());
			caissonmodel.setSepRetrait(getSepRetrait());
			caissonmodel.setSepretraitderiere(getSepretraitderiere());
			// Le dernier cuisson doit etre souple a la modificatioon
			// Le type de cuisson nous aide pour le calcul dressing colissant
			if (caissoncount >= 2 && i == 0) {
				caissonmodel.setCuissontype(CaissonType.EXTREME_GAUCHE);
			} else if (caissoncount >= 2 && i == caissoncount - 1) {
				caissonmodel.setCuissontype(CaissonType.EXTREME_DROITE);

			} else if (caissoncount == 1) {
				caissonmodel.setCuissontype(CaissonType.MONO_CAISSON);
			} else {
				caissonmodel.setCuissontype(CaissonType.MILIEU);
			}

			caissonmodel.create();
			dressing.addElement(caissonmodel.getCaissonInstance());
			// caissonmodel.getCaissonInstance().setXpos(xcounter);
			// xcounter+=caissonmodel.getCaissonInstance().getLongeurext();

		}
		// Changer le dernier cuisson en autocalcul�
		int debug = 0;
		debug++;
//dressing.printDescription();
	}

}
