package dressing.config.ui;

import java.io.File;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import dressing.config.persistence.ResourceManagers;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.cam.model.MachineCodeHandler;
import dressing.ui.util.EditorWindow;
import param.Configuration;
import param.MachineEngine;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Button;

public class MachineConfigEditor extends EditorWindow {
	ComboViewer machine;
	private Text text;
	private Button btnReflection;
	String[] extensions= { "*.png;*.jpg"};
	String logoPath="";
	public MachineConfigEditor(Shell parentShell) {
		super(parentShell);
		// TODO Auto-generated constructor stub
	}

	@Override
	protected Composite createClientArea(Composite parent) {
		Configuration config = ModelProvider.getModelroot().getConfig();
		MachineEngine element = config.getEngine();
		logoPath=ModelProvider.getModelroot().getConfig().getLogoPath();
		Composite composite = new Composite(parent, SWT.FILL);
		composite.setLayout(new GridLayout(3, false));
		parent.getShell().setText("Configuration");
		
		Label lblMachineCode = new Label(composite, SWT.NONE);
		lblMachineCode.setText("Machine code");
		machine = new ComboViewer(composite, SWT.READ_ONLY);
		Combo comboEmbaseType = machine.getCombo();
		comboEmbaseType.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		Label lblLogo = new Label(composite, SWT.NONE);
		lblLogo.setText("Logo");
		
		text = new Text(composite, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		if(logoPath!=null)
		{
			text.setText(logoPath);
		}
		Button button = new Button(composite, SWT.NONE);
		button.setText("...");
		button.addSelectionListener( new SelectionAdapter( ) {

			public void widgetSelected( SelectionEvent event )
			{
				FileDialog dialog = new FileDialog( parent.getShell());
				dialog.setFilterExtensions( extensions );
				dialog.setText( "Choisir un logo" );
				dialog.setFileName(logoPath);
				String fileName = dialog.open( );
				if ( fileName == null )
				{
					return;
				}
				// if file does not exist
				if ( ( new File( fileName ).exists( ) ) )
				{
					logoPath=fileName;
					if(logoPath!=null)
					{
						text.setText(logoPath);
					}
				}
			}}
		);
		Label lblReflection = new Label(composite, SWT.NONE);
		lblReflection.setText("Reflection");
		
		btnReflection = new Button(composite, SWT.CHECK);
		btnReflection.setSelection(config.isSceneReflection());
		machine.setContentProvider(ArrayContentProvider.getInstance());
		machine.setLabelProvider(MachineLabelProvider.getInstance());
		machine.setInput(ModelProvider.getModelroot().getMachineEngines().getEngines());
		machine.setSelection(new StructuredSelection(element), true);
		return composite;
	}

	@Override
	public void terminer() {
		Configuration config = ModelProvider.getModelroot().getConfig();
		IStructuredSelection selection=machine.getStructuredSelection();
		if(selection!=null && selection.size()==1)
		{
			Object o= selection.getFirstElement();
			if(o instanceof MachineEngine) {
				MachineEngine engine=(MachineEngine) o;
				ModelProvider.getModelroot().getConfig().setEngine(engine);
				MachineCodeHandler.getInstance().refresh();
				
			}
		}
		if(btnReflection.getSelection()!=config.isSceneReflection()) {
			config.setSceneReflection(btnReflection.getSelection());
			ProjectManager.getManager().getCurrentScene().requireRefresh=true;
		}
		if(text.getText()!=logoPath) {
			logoPath=text.getText();
		}
		config.setLogoPath(logoPath);
		ResourceManagers.getIntance().saveLibraryResource();
	}

	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		close();
	}
}
class MachineLabelProvider extends LabelProvider {
	private static MachineLabelProvider instance;
	public static MachineLabelProvider getInstance() {
		synchronized(MachineLabelProvider.class) {
			if (instance == null) {
				instance = new MachineLabelProvider();
			}
			return instance;
		}
	}
	@Override
	public String getText(Object element) {
		if(element!=null && element instanceof MachineEngine)
		{
			MachineEngine value=(MachineEngine) element;
			return value.getName();

		}else {
			return "";
		}
	}
}