package gdxapp.scenes;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import dressing.config.UserPreference;
import dressing.events.Event;
import dressing.events.EventDriver;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.assets.AssetsTextures;
import gdxapp.object3d.DoorHandle;
import gdxapp.shaders.PbrMaterial;
import jakarta.xml.bind.annotation.XmlRootElement;
import supercad.provider.FacadeHandleProvider;


@XmlRootElement(name="ScenePreferences")
public  class ScenePreferences
 {
	
	@Inject
	private transient IEventBroker eventBroker;

	private PbrMaterial wallMtl;
	private PbrMaterial floorMtl;
	private PbrMaterial marbleMtl;
		
	private PbrMaterial facadeMtl;
	private PbrMaterial boxMtl;
	private PbrMaterial backMtl;
	
	private float wallHeight = 2.5f;
	private float wallwidth = 0.1f;
	private float coinsSimpleFausseFacadeLegnth = 0.07f;
	private float plinthHeight = 0.15f;
		
	private DoorHandle doorHandle;
	
	
	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	private SceneTexture ceilingTexture;

	private SceneTexture facadeTexture;

	private SceneTexture BoxTexture;

	private SceneTexture BackTexture;

	
	public ScenePreferences() {
		super();
		if(UserPreference.getPreference().getScenePreferences() != null) {
			this.set(UserPreference.getPreference().getScenePreferences());
		}
	}

	
	public void set(ScenePreferences other) {
		setWallMtl(other.getWallMtl());
		setFloorMtl(other.getFloorMtl());
		setMarbleMtl(other.getMarbleMtl());
		setFacadeTexture(other.getFacadeTexture());
		setBoxTexture(other.getBoxTexture());
		setBackTexture(other.getBackTexture());
		setFacadeMtl(other.getFacadeMtl());
		setBoxMtl(other.getBoxMtl());
		setBackMtl(other.getBackMtl());
		setDoorHandle(other.getDoorHandle());
		//
		setWallHeight(other.getWallHeight());
		setWallwidth(other.getWallwidth());
		setCoinsSimpleFausseFacadeLegnth(other.getCoinsSimpleFausseFacadeLegnth());
		setCeilingTexture(other.getCeilingTexture());
	}


	public PbrMaterial getWallMtl() {
		if(wallMtl == null)
			wallMtl = AssetsTextures.getInstance().getMaterial("Wall");
		return wallMtl;
	}


	public void setWallMtl(PbrMaterial wallMtl) {
		this.wallMtl = wallMtl;
		propertyChangeSupport.firePropertyChange("wall material", null, wallMtl);
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.WALL_MATERIAL_CHANGED.name(), wallMtl));
	}

	public SceneTexture getCeilingTexture() {
		return ceilingTexture;
	}
	public void setCeilingTexture(SceneTexture ceilingtexture) {
		this.ceilingTexture = ceilingtexture;
	}
	
	public SceneTexture getFacadeTexture() {
		return facadeTexture;
	}

	public void setFacadeTexture(SceneTexture facadeTexture) {
		this.facadeTexture = facadeTexture;
	}

	public SceneTexture getBoxTexture() {
		return BoxTexture;
	}

	public void setBoxTexture(SceneTexture boxTexture) {
		BoxTexture = boxTexture;
	}

	public float getWallHeight() {
		return wallHeight;
	}

	public void setWallHeight(float wallHeight) {
		this.wallHeight = wallHeight;
	}
	
	public float getWallwidth() {
		return wallwidth;
	}

	public void setWallwidth(float wallwidth) {
		this.wallwidth = wallwidth;
	}

	public float getCoinsSimpleFausseFacadeLegnth() {
		return coinsSimpleFausseFacadeLegnth;
	}

	public void setCoinsSimpleFausseFacadeLegnth(float coinsSimpleFausseFacadeLegnth) {
		this.coinsSimpleFausseFacadeLegnth = coinsSimpleFausseFacadeLegnth;
	}


	public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
		if(this.propertyChangeSupport == null)
			propertyChangeSupport = new PropertyChangeSupport(this);
		this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
	}
	public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
		this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
	}
	
	public ScenePreferences clone() {
		ScenePreferences preferences =new ScenePreferences();
		preferences.set(this);
		return preferences;
	}


	

	public DoorHandle getDoorHandle() {
		if(doorHandle == null)
			doorHandle = FacadeHandleProvider.getInstance().getHandlers().get(0).cpy();
		return doorHandle;
	}

	public void setDoorHandle(DoorHandle doorHandle) {
		if(this.doorHandle == null || !this.doorHandle.equals(doorHandle)) {
			DoorHandle oldvalue=this.doorHandle;
			this.doorHandle = doorHandle;
			propertyChangeSupport.firePropertyChange("handle", oldvalue, doorHandle);
		}
	}

	public PbrMaterial getFloorMtl() {
		return floorMtl;
	}

	public void setFloorMtl(PbrMaterial floorMtl) {
		PbrMaterial oldvalue=this.floorMtl;
		this.floorMtl = floorMtl;
		propertyChangeSupport.firePropertyChange("floor mtl", oldvalue, floorMtl);
		EventDriver.getDriver().deliverEvent(new Event(SceneEvent.WALL_MATERIAL_CHANGED.name(), floorMtl));
	}


	public PbrMaterial getMarbleMtl() {
		return marbleMtl;
	}


	public void setMarbleMtl(PbrMaterial marbleMtl) {
		this.marbleMtl = marbleMtl;
	}


	public SceneTexture getBackTexture() {
		return BackTexture;
	}


	public void setBackTexture(SceneTexture backTexture) {
		BackTexture = backTexture;
	}


	public PbrMaterial getFacadeMtl() {
		return facadeMtl;
	}


	public void setFacadeMtl(PbrMaterial facadeMtl) {
		this.facadeMtl = facadeMtl;
		propertyChangeSupport.firePropertyChange("facade mtl", null, facadeMtl);

	}


	public PbrMaterial getBoxMtl() {
		return boxMtl;
	}

	public void setBoxMtl(PbrMaterial boxMtl) {
		this.boxMtl = boxMtl;
		propertyChangeSupport.firePropertyChange("box mtl", null, boxMtl);
	}


	public PbrMaterial getBackMtl() {
		return backMtl;
	}


	public void setBackMtl(PbrMaterial backMtl) {
		this.backMtl = backMtl;
		propertyChangeSupport.firePropertyChange("back mtl", null,backMtl);
	}
	
	

	public float getPlinthHeight() {
		return plinthHeight;
	}


	public void setPlinthHeight(float plinthHeight) {
		this.plinthHeight = plinthHeight;
	}


	public void initAfterRead() {
		this.propertyChangeSupport = new PropertyChangeSupport(this);
	}
	
	
	public void dispose() {
		for(PropertyChangeListener listener: this.propertyChangeSupport.getPropertyChangeListeners()) {
			this.propertyChangeSupport.removePropertyChangeListener(listener);
		}
		this.propertyChangeSupport = null;
	}
	

}
