package dressing.ui.engine3d.sceneconfig;

import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

import dressing.model.ProjectManager;
import dressing.ui.util.SingleImageItemLabelProvider;
import gdxapp.scenes.ScenePreferences;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;

public class SceneConfigWindow extends Window{

	private Shell shell;
	private HandlerConfigComposite handlePart;
	private WallConfigComposite wallPart;
	
	private ScenePreferences preferences;
	
	public SceneConfigWindow(Shell parentShell, ScenePreferences preferences) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
		this.preferences = preferences;
	}

	@Override
	protected Control createContents(Composite parent) {
		
		parent.setTouchEnabled(true);
		this.shell=parent.getShell();
		parent.getShell().setText("Configuration du scéne");
		shell.addShellListener(getShellListener());
		
		Composite composite = new Composite(parent, SWT.FILL);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite.setLayout(new GridLayout(1, false));
		composite.setTouchEnabled(true);
		
		Composite composite_1 = new Composite(composite, SWT.NONE);
		composite_1.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		composite_1.setLayout(new GridLayout(1, false));
		
		TabFolder tabFolder = new TabFolder(composite_1, SWT.NONE);
		tabFolder.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		
		SingleImageItemLabelProvider labelProvider = new SingleImageItemLabelProvider(parent);
		
		TabItem tbtmHandle = new TabItem(tabFolder, SWT.NONE);
		tbtmHandle.setText("Poignée");
		
		Composite composite_2 = new Composite(tabFolder, SWT.NONE);
		tbtmHandle.setControl(composite_2);
		composite_2.setLayout(new GridLayout(1, false));
		
		this.handlePart = new HandlerConfigComposite(composite_2, SWT.EMBEDDED);
		
		handlePart.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		TabItem tbtmNewItem = new TabItem(tabFolder, SWT.NONE);
		tbtmNewItem.setText("Mur");
		
		Composite composite_7 = new Composite(tabFolder, SWT.NONE);
		tbtmNewItem.setControl(composite_7);
		composite_7.setLayout(new GridLayout(1, false));
		
		this.wallPart = new WallConfigComposite(composite_7, SWT.NONE, this.preferences);
		wallPart.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		
		ControlAdapter adaptor=new ControlAdapter() {

			@Override
			public void controlResized(ControlEvent e) {
				 Rectangle area2= SceneConfigWindow.this.getShell().getClientArea();
			     composite.setBounds(area2);
			}
			
		};
		
		parent.addControlListener(adaptor);
		parent.getShell().addControlListener(adaptor);
		composite_1.addControlListener(adaptor);
		composite.addControlListener(adaptor);
		return composite;
	}

	protected Point getInitialSize() {
		return new Point(801, 500);
	}

	@Override
	protected void handleShellCloseEvent() {
		handlePart.updateDoorHandle();
		close();
	}
	
	
}
