package dressing.ui.dressing;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;


import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.IUpdateStructure;
import dressing.model.ModelProvider;
import dressing.model.types.PortType;
import dressing.ui.util.SingleImageItemLabelProvider;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import dressing.model.Materiaux;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Group;

public class DressingCompositeWizard extends Composite {

	private DataBindingContext m_bindingContext;
	private dressing.controller.DressingCreator dressing = new dressing.controller.DressingCreator();
	private ModelProvider modelprovider = new ModelProvider();

	private MDirtyable dirty;
	private int updatestragey = UpdateValueStrategy.POLICY_UPDATE;
	private Group grpMatrieaux;
	private Text nomtxt;
	private Text etagetxt;
	private Text apptxt;
	private ComboViewer comboViewer;
	private ComboViewer comboViewer_1;
	private Spinner spinnerlongeur;
	private Spinner spinnerhauteur;
	private Spinner spinnerprofondeur;
	private TableComboViewer tableComboViewermatprincipale;
	private TableComboViewer tableComboViewer_matdos;
	public DressingCompositeWizard(Composite parent, int style, dressing.controller.DressingCreator newDressing,int updatestrategy) {
		this(parent, style);
		this.updatestragey = updatestrategy;
		setDressing(newDressing);
	}

	public DressingCompositeWizard(Composite parent, int style) {
		super(parent, style);
		setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.verticalSpacing = 10;
		gridLayout.marginWidth = 10;
		gridLayout.marginHeight = 10;
		setLayout(gridLayout);
		
		Group grpInformations = new Group(this, SWT.NONE);
		GridData gd_grpInformations = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_grpInformations.widthHint = 443;
		grpInformations.setLayoutData(gd_grpInformations);
		grpInformations.setText("Informations");
		grpInformations.setLayout(new GridLayout(2, false));
		
		Label lblNom = new Label(grpInformations, SWT.NONE);
		lblNom.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNom.setText("Nom");
		
		nomtxt = new Text(grpInformations, SWT.BORDER);
		nomtxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		//
		Label lblEtage = new Label(grpInformations, SWT.NONE);
		lblEtage.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblEtage.setText("Etage");
		
		etagetxt = new Text(grpInformations, SWT.BORDER);
		etagetxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Label lblapp = new Label(grpInformations, SWT.NONE);
		lblapp.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblapp.setText("Appartement");
		
		apptxt = new Text(grpInformations, SWT.BORDER);
		apptxt.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		//
		
		grpMatrieaux = new Group(this, SWT.NONE);
		grpMatrieaux.setForeground(SWTResourceManager.getColor(SWT.COLOR_LINK_FOREGROUND));
		grpMatrieaux.setLayout(new GridLayout(2, false));
		GridData gd_grpMatrieaux = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_grpMatrieaux.widthHint = 437;
		grpMatrieaux.setLayoutData(gd_grpMatrieaux);
		grpMatrieaux.setText("Matérieaux");
		grpMatrieaux.setEnabled(true);
		grpMatrieaux.setVisible(true);
		Label lblNewLabel_1 = new Label(grpMatrieaux, SWT.NONE);
		lblNewLabel_1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText("Matériaux principale");
		
		comboViewer = new ComboViewer(grpMatrieaux, SWT.READ_ONLY);
		Combo combomatprinipale = comboViewer.getCombo();
		combomatprinipale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer.setContentProvider(ArrayContentProvider.getInstance());
		comboViewer.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewer.setInput(ModelProvider.getMateriallist());
		//
//		tableComboViewermatprincipale = new TableComboViewer(grpMatrieaux, SWT.READ_ONLY | SWT.BORDER);
//		tableComboViewermatprincipale.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		tableComboViewermatprincipale.getTableCombo().setShowTableHeader(true);
//		tableComboViewermatprincipale.getTableCombo().defineColumns(new String[] { "Texture","Epaisseur" });
//		tableComboViewermatprincipale.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
//		// do not allow editable
//		tableComboViewermatprincipale.getTableCombo().setEditable(false);
//		// set the content provider
//		tableComboViewermatprincipale.setContentProvider(ArrayContentProvider.getInstance());
//
//		// set the label provider
//		tableComboViewermatprincipale.setLabelProvider(new SingleImageItemLabelProvider(this));
//
//		// load the data
//		tableComboViewermatprincipale.setInput(modelprovider.getMateriallist());
		
		//
		
		
		//
		Label lblNewLabel_2 = new Label(grpMatrieaux, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText("Matérieaux dos");
		
		comboViewer_1 = new ComboViewer(grpMatrieaux, SWT.READ_ONLY);
		Combo combomatdos = comboViewer_1.getCombo();
		combomatdos.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_1.setContentProvider(ArrayContentProvider.getInstance());
		comboViewer_1.setLabelProvider(new LabelProvider() {
		     @Override
		     public String getText(Object element) {
		         if (element instanceof Materiaux) {
		        	 Materiaux mat = (Materiaux) element;
		             return mat.getName();
		         }
		         return super.getText(element);
		     }
		 });
		comboViewer_1.setInput(ModelProvider.getMateriallist());
		//
//		tableComboViewer_matdos = new TableComboViewer(grpMatrieaux, SWT.READ_ONLY | SWT.BORDER);
//		tableComboViewer_matdos.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		tableComboViewer_matdos.getTableCombo().setShowTableHeader(true);
//		tableComboViewer_matdos.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });
//
//		tableComboViewer_matdos.getTableCombo().setDisplayColumnIndex(0);
//		tableComboViewer_matdos.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
//		// do not allow editable
//		tableComboViewer_matdos.getTableCombo().setEditable(false);
//		// set the content provider
//		tableComboViewer_matdos.setContentProvider(ArrayContentProvider.getInstance());
//		
//		// set the label provider
//		tableComboViewer_matdos.setLabelProvider(new SingleImageItemLabelProvider(this));
//
//		// load the data
//		tableComboViewer_matdos.setInput(modelprovider.getMateriallist());	

		//
		Group grpDimensions = new Group(this, SWT.NONE);
		grpDimensions.setLayout(new GridLayout(2, false));
		GridData gd_grpDimensions = new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1);
		gd_grpDimensions.widthHint = 439;
		grpDimensions.setLayoutData(gd_grpDimensions);
		grpDimensions.setText("Dimensions");
		
		Label lblNewLabel_3 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_3.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_3.setText("Longeur");
		
		spinnerlongeur = new Spinner(grpDimensions, SWT.BORDER);
		spinnerlongeur.setMaximum(10000000);
		GridData gd_spinnerlongeur = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spinnerlongeur.widthHint = 320;
		spinnerlongeur.setLayoutData(gd_spinnerlongeur);
		
		Label lblNewLabel_4 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_4.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_4.setText("Hauteur");
		
		spinnerhauteur = new Spinner(grpDimensions, SWT.BORDER);
		spinnerhauteur.setMaximum(100000000);
		GridData gd_spinnerhauteur = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spinnerhauteur.widthHint = 190;
		spinnerhauteur.setLayoutData(gd_spinnerhauteur);
		
		Label lblNewLabel_5 = new Label(grpDimensions, SWT.NONE);
		lblNewLabel_5.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_5.setText("Profondeur");
		
		spinnerprofondeur = new Spinner(grpDimensions, SWT.BORDER);
		spinnerprofondeur.setMaximum(1000000000);
		GridData gd_spinnerprofondeur = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_spinnerprofondeur.widthHint = 210;
		spinnerprofondeur.setLayoutData(gd_spinnerprofondeur);
		m_bindingContext = initDataBindings();
		 
		//Ajouter le controle de dirty
		
		makedirtycontroller();
		}
	

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public dressing.controller.DressingCreator getDressing() {
		return dressing;
	}

	public void setDressing(dressing.controller.DressingCreator newDressing) {
		setDressing(newDressing, true);
	}
public ModelProvider getModelprovider() {
	return modelprovider;
}
public void setModelprovider(ModelProvider modelprovider) {
	this.modelprovider = modelprovider;
}
	public void setDressing(dressing.controller.DressingCreator newDressing, boolean update) {
		dressing = newDressing;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (dressing != null) {
				m_bindingContext = initDataBindings();
			}
//			//
//			FocusListener focus = new FocusListener() {
//				
//				@Override
//				public void focusLost(FocusEvent e) {
//					// TODO Auto-generated method stub
//					m_bindingContext.updateModels();
//				}
//				
//				@Override
//				public void focusGained(FocusEvent e) {
//					// TODO Auto-generated method stub
//					
//				}
//			};
//			spinner_hauteur.addFocusListener(focus);
//			spinner_profondeur.addFocusListener(focus);
//			spinnerlongeur.addFocusListener(focus);
		}
	}
	
	private DataBindingContext custominitDataBindings() {

		//
		return null;
	}
	
	public void setDirty(MDirtyable dirty) {
		this.dirty = dirty;
	}
	public MDirtyable getDirty() {
		return dirty;
	}
	public void updateDirty()
	{
		if(this.dirty!=null)
		{
			this.dirty.setDirty(true);
		}
	}
	protected void makedirtycontroller()
	{
		//Faire la mise ajour des controel pour qui enregistre le dirty
				Control [] ctrl = this.getChildren();
				for(Control ctr : this.getChildren())
				{
					if(ctr instanceof Text)
					{
						((Text) ctr).addKeyListener(new KeyListener() {
							
							@Override
							public void keyReleased(KeyEvent e) {
								// TODO Auto-generated method stub
								updateDirty();
							}
							
							@Override
							public void keyPressed(KeyEvent e) {
								// TODO Auto-generated method stub
								
							}
						});
					}
					else
					{
						ctr.addListener(SWT.Selection, event->updateDirty());//Pour les spinner et les chekbox labada expresseion
					}
				}
	}

	protected void makeerrorhandler(Control control)
	{
		// re-use an existing image
		Image image = FieldDecorationRegistry.getDefault().getFieldDecoration(FieldDecorationRegistry.DEC_ERROR)
				.getImage();
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
//		ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
//		IObservableMap observeMap = BeansObservables.observeMap(listContentProvider.getKnownElements(), Materiaux.class, "name");
//		comboViewer.setLabelProvider(new ObservableMapLabelProvider(observeMap));
//		comboViewer.setContentProvider(listContentProvider);
		
		//
//		ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
//		IObservableMap observeMap_1 = BeansObservables.observeMap(listContentProvider_1.getKnownElements(), Materiaux.class, "name");
//		comboViewer_1.setLabelProvider(new ObservableMapLabelProvider(observeMap_1));
//		comboViewer_1.setContentProvider(listContentProvider_1);
		//		
		IObservableValue observeSingleSelectionComboViewer = ViewerProperties.singleSelection().observe(comboViewer);
		IObservableValue basematerialDressingObserveValue = BeanProperties.value("basematerial").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer, basematerialDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_1 = ViewerProperties.singleSelection().observe(comboViewer_1);
		IObservableValue backmaterialDressingObserveValue = BeanProperties.value("backmaterial").observe(dressing);
		bindingContext.bindValue(observeSingleSelectionComboViewer_1, backmaterialDressingObserveValue, null, null);
		//
		//
//		IObservableValue observeSingleSelectiontTableComboViewermatprincipale = ViewerProperties.singleSelection().observe(tableComboViewermatprincipale);
//		IObservableValue basematerialDressingObserveValue = BeanProperties.value("basematerial").observe(dressing);
//		bindingContext.bindValue(observeSingleSelectiontTableComboViewermatprincipale, basematerialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
//		//
//		IObservableValue observeSingleSelectiontableComboViewer_matdos = ViewerProperties.singleSelection().observe(tableComboViewer_matdos);
//		IObservableValue backmaterialDressingObserveValue = BeanProperties.value("backmaterial").observe(dressing);
//		bindingContext.bindValue(observeSingleSelectiontableComboViewer_matdos, backmaterialDressingObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), null);
		//
		IObservableValue observeSelectionSpinnerlongeurObserveWidget = WidgetProperties.widgetSelection().observe(spinnerlongeur);
		IObservableValue longeurDressingObserveValue = BeanProperties.value("longeur").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinnerlongeurObserveWidget, longeurDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinnerhauteurObserveWidget = WidgetProperties.widgetSelection().observe(spinnerhauteur);
		IObservableValue hauteurDressingObserveValue = BeanProperties.value("hauteur").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinnerhauteurObserveWidget, hauteurDressingObserveValue, null, null);
		//
		IObservableValue observeSelectionSpinnerprofondeurObserveWidget = WidgetProperties.widgetSelection().observe(spinnerprofondeur);
		IObservableValue profondeurDressingObserveValue = BeanProperties.value("profondeur").observe(dressing);
		bindingContext.bindValue(observeSelectionSpinnerprofondeurObserveWidget, profondeurDressingObserveValue, null, null);
		//
		IObservableValue observeTextNomtxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(nomtxt);
		IObservableValue nameDressingObserveValue = BeanProperties.value("name").observe(dressing);
		bindingContext.bindValue(observeTextNomtxtObserveWidget, nameDressingObserveValue, null, null);
		//
		IObservableValue observeTextEtagetxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(etagetxt);
		IObservableValue etageDressingObserveValue = BeanProperties.value("etage").observe(dressing);
		bindingContext.bindValue(observeTextEtagetxtObserveWidget, etageDressingObserveValue, null, null);
		//
		IObservableValue observeTextApptxtObserveWidget = WidgetProperties.text(SWT.FocusOut).observe(apptxt);
		IObservableValue appartementDressingObserveValue = BeanProperties.value("appartement").observe(dressing);
		bindingContext.bindValue(observeTextApptxtObserveWidget, appartementDressingObserveValue, null, null);
		
		//
		return bindingContext;
	}
}
