package dressing.ui.caissonciosine;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import dressing.controller.CaissonCuisineCreator;
import dressing.controller.EtagereCreator;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.model.types.CuisineCaissonType;
import dressing.model.types.DosType;
import dressing.model.types.EtagereReferenceType;
import dressing.ui.util.SingleImageItemLabelProvider;
import dressing.ui.util.SwtTextFilter;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Spinner;

public class CaissonCuisineDialogComposite extends Composite {
	private TableComboViewer tableComboViewerBaseMaterial;
	private TableComboViewer tableComboViewerBackMaterial;
	ModelProvider modelProvider=new ModelProvider();
	CaissonCuisineCreator caisson;
	private DataBindingContext m_bindingContext;
	private Text Name;
	private Label lblBaseMaterial;
	private Label lblBackMaterial;
	private Combo referencecombo;
	private ComboViewer comboViewer_2;
	private Button btniswithdos;
	private Spinner spnlongeur;
	private Spinner spnhauteur;
	private Spinner spnprofondeur;
	private Combo combo;
	private ComboViewer comboViewerdosType;
	private Label lbltypedos;
	/**
	 * Create the composite.
	 * @param parent
	 * @param style
	 */

	public CaissonCuisineDialogComposite(Composite parent, int style, CaissonCuisineCreator caisson) {
		this(parent, style);
		setCaisson(caisson);
	
		if (caisson != null) {
			m_bindingContext = initDataBindings();
		}
	}
	
	public CaissonCuisineCreator getCaisson() {
		return caisson;
	}
	public void setCaisson(CaissonCuisineCreator caisson) {
		this.caisson = caisson;
	}
	public CaissonCuisineDialogComposite(Composite parent, int style) {
		super(parent, style);
		setEnabled(true);
		setLayout(new GridLayout(2, false));
		
		Label lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText("Name");
		
		 Name = new Text(this, SWT.BORDER);
		Name.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		//
		Label refrenceLabel = new Label(this, SWT.NONE);
		refrenceLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		refrenceLabel.setText("Type Caisson cuisine ");

		comboViewer_2 = new ComboViewer(this, SWT.READ_ONLY);
		referencecombo = comboViewer_2.getCombo();
		referencecombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		comboViewer_2.setContentProvider((ArrayContentProvider.getInstance()));
		comboViewer_2.setInput(CuisineCaissonType.values());
		
		//
		 lblBaseMaterial = new Label(this, SWT.NONE);
		lblBaseMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblBaseMaterial.setText("Materieaux principale");
		//
		tableComboViewerBaseMaterial = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewerBaseMaterial.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewerBaseMaterial.getTableCombo().setShowTableHeader(true);
		tableComboViewerBaseMaterial.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewerBaseMaterial.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewerBaseMaterial.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewerBaseMaterial.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewerBaseMaterial.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewerBaseMaterial.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewerBaseMaterial.setInput(modelProvider.getMateriallist());	
		
		
		//
		
		 lblBackMaterial = new Label(this, SWT.NONE);
		lblBackMaterial.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblBackMaterial.setText("materieaux secondaire");
		//
		tableComboViewerBackMaterial = new TableComboViewer(this, SWT.READ_ONLY | SWT.BORDER);
		tableComboViewerBackMaterial.getTableCombo().setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		tableComboViewerBackMaterial.getTableCombo().setShowTableHeader(true);
		tableComboViewerBackMaterial.getTableCombo().defineColumns(new String[] { "Texture", "Epaisseur" });

		tableComboViewerBackMaterial.getTableCombo().setDisplayColumnIndex(0);
		tableComboViewerBackMaterial.getTableCombo().getTextControl().setFont(SWTResourceManager.getFont("Segoe UI", 12, SWT.NORMAL));
		// do not allow editable
		tableComboViewerBackMaterial.getTableCombo().setEditable(false);
		// set the content provider
		tableComboViewerBackMaterial.setContentProvider(ArrayContentProvider.getInstance());
		
		// set the label provider
		tableComboViewerBackMaterial.setLabelProvider(new SingleImageItemLabelProvider(this));

		// load the data
		tableComboViewerBackMaterial.setInput(modelProvider.getMateriallist());	
		
		
		//
		
		Label lbllongeur = new Label(this, SWT.NONE);
		lbllongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lbllongeur.setText("longeur");
		
		spnlongeur = new Spinner(this, SWT.BORDER);
		spnlongeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnlongeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnlongeur.setMaximum(100000);
		
		Label lblhauteur = new Label(this, SWT.NONE);
		lblhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblhauteur.setText("hauteur");
		
		spnhauteur = new Spinner(this, SWT.BORDER);
		spnhauteur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		spnhauteur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		spnhauteur.setMaximum(100000);
		Label lblprofondeur = new Label(this, SWT.NONE);
		lblprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblprofondeur.setText("profondeur");
		 
		 spnprofondeur = new Spinner(this, SWT.BORDER);
		 spnprofondeur.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		 spnprofondeur.setFont(SWTResourceManager.getFont("Segoe UI", 10, SWT.NORMAL));
		 spnprofondeur.setMaximum(100000);
		 
		 lbltypedos = new Label(this, SWT.NONE);
		 lbltypedos.setText("Type de dos");
		 
		 comboViewerdosType = new ComboViewer(this, SWT.NONE);
		 combo = comboViewerdosType.getCombo();
		 combo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		 comboViewerdosType.setContentProvider((ArrayContentProvider.getInstance()));
		 comboViewerdosType.setInput(DosType.values());
		 
		 btniswithdos = new Button(this, SWT.CHECK);
		btniswithdos.setText("avec Dos");
		new Label(this, SWT.NONE);
		if(caisson!=null) {
			m_bindingContext = initDataBindings();
		}
	}


	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue observetextNameObserveWidget = WidgetProperties.text(SWT.Modify).observe(Name);
		IObservableValue etagerecountEtgCreatorObserveValue = BeanProperties.value("name").observe(caisson);
		bindingContext.bindValue(observetextNameObserveWidget, etagerecountEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionChecktraversantseperatorObserveWidget = WidgetProperties.widgetSelection().observe(btniswithdos);
		IObservableValue sepratortransversalDressingObserveValue = BeanProperties.value("withDos").observe(caisson);
		bindingContext.bindValue(observeSelectionChecktraversantseperatorObserveWidget, sepratortransversalDressingObserveValue, null, null);
		//
		IObservableValue observeSingleSelectiontableComboViewerBaseMaterial = ViewerProperties.singleSelection().observe(tableComboViewerBaseMaterial);
		IObservableValue basematerialcaissonObserveValue = BeanProperties.value("basematerial").observe(caisson);
		bindingContext.bindValue(observeSingleSelectiontableComboViewerBaseMaterial, basematerialcaissonObserveValue, null, null);
		//
		IObservableValue observeSingleSelectiontableComboViewerBackMaterial = ViewerProperties.singleSelection().observe(tableComboViewerBackMaterial);
		IObservableValue backmaterialcaissonObserveValue = BeanProperties.value("backmaterial").observe(caisson);
		bindingContext.bindValue(observeSingleSelectiontableComboViewerBackMaterial, backmaterialcaissonObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewer_2 = ViewerProperties.singleSelection().observe(comboViewer_2);
		IObservableValue etagereReferenceTypeEtgCreatorObserveValue = BeanProperties.value("caissoncuisineType").observe(caisson);
		bindingContext.bindValue(observeSingleSelectionComboViewer_2, etagereReferenceTypeEtgCreatorObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnlongeurObserveWidget = WidgetProperties.widgetSelection().observe(spnlongeur);
		IObservableValue longeurCaissonObserveValue = BeanProperties.value("longeur").observe(caisson);
		bindingContext.bindValue(observeSelectionSpnlongeurObserveWidget, longeurCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnhauteurObserveWidget = WidgetProperties.widgetSelection().observe(spnhauteur);
		IObservableValue hauteurCaissonObserveValue = BeanProperties.value("hauteur").observe(caisson);
		bindingContext.bindValue(observeSelectionSpnhauteurObserveWidget, hauteurCaissonObserveValue, null, null);
		//
		IObservableValue observeSelectionSpnprofondeurObserveWidget = WidgetProperties.widgetSelection().observe(spnprofondeur);
		IObservableValue profondeurCaissonObserveValue = BeanProperties.value("profondeur").observe(caisson);
		bindingContext.bindValue(observeSelectionSpnprofondeurObserveWidget, profondeurCaissonObserveValue, null, null);
		//
		IObservableValue observeSingleSelectionComboViewerdosType = ViewerProperties.singleSelection().observe(comboViewerdosType);
		IObservableValue dostypeCaissonObserveValue = BeanProperties.value("dostype").observe(caisson);
		bindingContext.bindValue(observeSingleSelectionComboViewerdosType, dostypeCaissonObserveValue, null, null);
		//
		IObservableValue observeVisibleComboObserveWidget = WidgetProperties.visible().observe(combo);
		bindingContext.bindValue(observeVisibleComboObserveWidget, sepratortransversalDressingObserveValue, null, null);
		//
		IObservableValue observeVisibleLbltypedosObserveWidget = WidgetProperties.visible().observe(lbltypedos);
		bindingContext.bindValue(observeVisibleLbltypedosObserveWidget, sepratortransversalDressingObserveValue, null, null);
		//
		return bindingContext;
	}
}
