package dressing.model;

import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

import com.badlogic.gdx.math.Vector3;

import dressing.controller.Piece2DCreator;
import dressing.model.accessoire.SupportBlocTiroir;
import dressing.model.debitage.Debitage;
import dressing.model.debitage.DebitageFormulas;
import dressing.model.debitage.GenericDebitage;
import dressing.model.evalutor.Couple;
import dressing.model.evalutor.Equation;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.parameters.ConstraintParam;
import dressing.model.parameters.UsinageParam;
import dressing.model.persistence.mappers.Persistable;
import dressing.model.persistence.mappers.PersistenceValue;
import dressing.model.types.CaissonType;
import dressing.model.types.DesignType;
import dressing.model.types.DosType;
import dressing.model.types.IntersectionType;
import dressing.model.types.Orientation;
import dressing.model.types.PieceType;
import dressing.model.types.PoigneePosition;
import dressing.model.types.PoigneeType;
import dressing.model.types.PortType;
import dressing.model.types.PorteDirection;
import dressing.model.types.PositionReferenceType;
import dressing.model.usinage.Rainure;
import dressing.model.usinage.Trou;
import dressing.model.usinage.Usinage;
import param.Cavity;
import param.FunctionDef;
import param.MechanicDesign;
import param.MechanicDesignElment;
import param.MechanicPrivateParam;
import param.MechanicPublicParam;
import param.UsinageTrou;
import tech.frsdev.solids.Solide3D;


public abstract class DesignObject3D implements Solide3D,Cloneable,Serializable{

	private  DesignObject3D parentdesign;
	protected MechanicDesign mechanicDesignDefinition;
	protected Object globalDesignDefinition;
	DesignType designType=DesignType.CLASSIC;
	public int sceneNumber;
	public Object getGlobalDesignDefinition() {
		return globalDesignDefinition;
	}
	public void setGlobalDesignDefinition(Object globalDesignDefinition) {
		this.globalDesignDefinition = globalDesignDefinition;
	}

	List<DesignObject3D>   childs;
	List<DesignObject3D>   babies;

	transient	UsinageParam usineparam = new UsinageParam();
	transient ConstraintParam constraintsparam = new ConstraintParam();
	ArrayList<Parameters> params=new ArrayList<Parameters>();
	protected transient Debitage debitage =null;
	public transient DebitageFormulas formulas = new DebitageFormulas();
	//Pour les pieces 3D
	private double longeurext;//la plus longue distance
	private boolean longeurextfree=false;
	private double profondeurext;//profondeur
	private boolean profondeurextfree=false;
	private double hauteurext;
	private boolean hauteurextfree=false;
	
	private double longeurint;//la plus longue distance
	private double profondeurint;//profondeur
	private double hauteurint;
	private String name="";
	
	Materiaux basematerial=null;
	private boolean basematerialfree=false;
	Materiaux backmaterial=null;
	private boolean backmaterialfree=false;
	
	private Materiaux facadeMaterial=null;
	private boolean facadematerialfree=false;
	
	transient boolean errorexist=false;
	transient String errormsg="";
	transient private boolean notificationon=true;

	protected double xpos;
	protected double ypos;
	protected double zpos;

	//imed bug 1188
	transient double xPosABS;
	transient double yPosABS;
	transient double zPosABS;
	
	transient Point3D[] extremes=new Point3D[8];
	protected  ArrayList<Couple> systemesequations = new ArrayList<Couple>();
	protected  ArrayList<Couple> systemesequationsasparent = new ArrayList<Couple>();
	Properties props=new Properties();
	@PersistenceValue
	protected UUID ID=null;
	Kitchen kitchen;
	public DesignType getDesignType() {
		return designType;
	}
	public void setDesignType(DesignType disgntype) {
		DesignType oldValue = this.designType;
		this.designType = disgntype;
		firePropertyChange("designType", oldValue, this.designType);
	}
	public void setSystemesequations(ArrayList<Couple> systemesequations) {
		ArrayList<Couple> oldValue = this.systemesequations;
		this.systemesequations = systemesequations;
		firePropertyChange("systemesequations", oldValue, systemesequations);
	}
	
	
	public double getXPosABS() {	
		if(this instanceof Project3D || this instanceof Dressing) {
			return 0;
		}else {			
			if(getParentdesign()!=null) {
				return getXpos()+getParentdesign().getXPosABS();
			}else {
				return getXpos();
			}
		}
	}
	public void setXPosABS(double xABSPos) {
		double oldValue = this.xPosABS;
		this.xPosABS = xABSPos;
		firePropertyChange("xPosABS", oldValue, xPosABS);
	}
	public double getYPosABS() {
		if(this instanceof Project3D || this instanceof Dressing) {
			return 0;
		}else {
			if(getParentdesign()!=null) {
				return getYpos()+getParentdesign().getYPosABS();
			}else {
				return getYpos();
			}
		}	
	}
	public void setYPosABS(double yPosABS) {
		double oldValue = this.yPosABS;
		this.yPosABS = yPosABS;
		firePropertyChange("yPosABS", oldValue, yPosABS);

	}
	public double getZPosABS() {
		if(this instanceof Project3D || this instanceof Dressing) {
			return 0;
		}else {
			if(getParentdesign()!=null) {
				return getZpos()+getParentdesign().getZPosABS();
			}else {
				return getZpos();
			}
		}	
	}
	public void setZPosABS(double zPosABS) {
		double oldValue = this.zPosABS;
		this.zPosABS = zPosABS;
		firePropertyChange("zPosABS", oldValue, zPosABS);
	}
	
	//end;imed bug 1188
	
	transient protected Boolean selected=false;
	public DesignObject3D() {
		// TODO Auto-generated constructor stub
		childs = new ArrayList<DesignObject3D>();
		babies= new ArrayList<DesignObject3D>();
//	   readResolve() ;
	}
	
	public List<DesignObject3D> getBabies() {
		return babies;
	}
	public void setBabies(List<DesignObject3D> babies) {
		List<DesignObject3D> oldValue = this.babies;
		this.babies = babies;
		firePropertyChange("babies", oldValue, babies);
	}
	public void addBaby(DesignObject3D baby) throws DesignException {
		if(baby ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}
		if(babies==null) {
			babies=new ArrayList<DesignObject3D>();
		}
		this.babies.add(baby);

	}
	public void removeBaby(DesignObject3D baby) throws DesignException {
		if(baby ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}
		if(babies==null) {
			babies=new ArrayList<DesignObject3D>();
		}
		if(babies.contains(baby)) {
			this.babies.remove(baby);
		}

	}
	public DesignObject3D getParentdesign() {
		return parentdesign;
	}
	public void setParentdesign(DesignObject3D parentdesign) {
		this.parentdesign = parentdesign;
	}
	public List<DesignObject3D> getChilds() {
		return childs;
	}
	public void setChilds(List<DesignObject3D> childs) {
		this.childs = childs;
	}
	
	public List<DesignObject3D> addChilds(List<DesignObject3D> listchildsToAdd){
		for(DesignObject3D c :listchildsToAdd ) {
			this.childs.add(c);
		}
		return this.childs;
		
		
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}
	
	
	public double getLongeurext() {
		return longeurext;
	}
	public void setLongeurext(double longeurext) {
	
		double oldValue = this.longeurext;
		this.longeurext = longeurext;
		firePropertyChange("longeurext", oldValue, longeurext);
	}
	public double getProfondeurext() {
		return profondeurext;
	}
	public void setProfondeurext(double profondeurext) {
	
		double oldValue = this.profondeurext;
		this.profondeurext = profondeurext;
		firePropertyChange("profondeurext", oldValue, profondeurext);
	}
	public double getHauteurext() {
		return hauteurext;
	}
	public void setHauteurext(double hauteurext) {
	
		double oldValue = this.hauteurext;
		this.hauteurext = hauteurext;
		firePropertyChange("hauteurext", oldValue, hauteurext);
	}
	public double getLongeurint() {
		return longeurint;
	}
	public void setLongeurint(double longeurint) {
	
		double oldValue = this.longeurint;
		this.longeurint = longeurint;
		firePropertyChange("longeurint", oldValue, longeurint);
	}
	public double getProfondeurint() {
		return profondeurint;
	}
	public void setProfondeurint(double profondeurint) {
	
		double oldValue = this.profondeurint;
		this.profondeurint = profondeurint;
		firePropertyChange("profondeurint", oldValue, profondeurint);
	}
	public double getHauteurint() {
		return hauteurint;
	}
	public void setHauteurint(double hauteurint) {
	
		double oldValue = this.hauteurint;
		this.hauteurint = hauteurint;
		firePropertyChange("hauteurint", oldValue, hauteurint);
	}
	public Materiaux getBasematerial() {
		return basematerial;
	}
	public void setBasematerial(Materiaux basematerial) {
	
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}
	public Materiaux getBackmaterial() {
		return backmaterial;
	}
	public void setBackmaterial(Materiaux backmaterial) {
	
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}
	
	public abstract boolean canHold(DesignObject3D child);
	
	@Override
	public String toString() {
	
		return name;
	}
	
	public Materiaux getFacadeMaterial() {
		return facadeMaterial;
	}
	public void setFacadeMaterial(Materiaux facadeMaterial) {
		Materiaux oldValue = this.facadeMaterial;
		this.facadeMaterial = facadeMaterial;
		firePropertyChange("facadeMaterial", oldValue, facadeMaterial);
	}
	public boolean isFacadematerialfree() {
		return facadematerialfree;
	}
	public void setFacadematerialfree(boolean facadematerialfree) {
		boolean oldValue = this.facadematerialfree;
		this.facadematerialfree = facadematerialfree;
		firePropertyChange("facadematerialfree", oldValue, facadematerialfree);
	}
	public void check() throws DesignException
	{
		
	}
	/**
	 * 
	 * @return L'objet design parent absolue dressing ou cuisine
	 */
	public DesignObject3D getRoot()
	{
		DesignObject3D parent2= this.getParentdesign();
		while(parent2!= null && parent2.getParentdesign()!=null&& !(parent2 instanceof Dressing)) {
			parent2=parent2.getParentdesign();
		}
		return parent2;
	}
	
	public void checkIntersectionWithRoot(DesignObject3D coming) throws DesignException
	{
		DesignObject3D root = this.getRoot();	
		if(root!=null && coming!=null && coming instanceof Piece2D)
		checkIntersectionWithSubelements(root,coming);
	}
	public void checkIntersectionWithSubelements(DesignObject3D sub , DesignObject3D coming) throws DesignException
	{
		for(DesignObject3D designobject : sub.getChilds())
		{
			if(designobject instanceof Piece2D && coming instanceof Piece2D)
			{
				if(designobject.isIntersect(coming).equals(IntersectionType.INTERSECTION))
				{
//					throw new DesignException("Intersection detecté entre  "+coming.getName()+" et "+designobject.getName());
//					if(sub instanceof Piece2D && coming instanceof Piece2D) {
//						if(!isallowedIntersection(sub,coming)) {
//							throw new DesignException("Intersection detecté entre  "+coming.getName()+" et "+designobject.getName());
//						}
//					}
				}
				if(designobject.isIntersect(coming).equals(IntersectionType.TANGENT))
				{
//					throw new DesignException("Intersection detecté entre  "+coming.getName()+" et "+designobject.getName());
				}
			}
			checkIntersectionWithSubelements(designobject, coming);
           
		}
	}
//	private boolean isallowedIntersection(DesignObject3D sub, DesignObject3D coming) {
//		if(((Piece2D)sub).getPiecetype().equals(PieceType.DOS_INTERIEUR)
//				||((Piece2D)coming).getPiecetype().equals(PieceType.DOS_INTERIEUR)){
//			return true;
//		}
//		if(((Piece2D)sub).getPiecetype().equals(PieceType.PORTE)
//				||((Piece2D)coming).getPiecetype().equals(PieceType.PORTE)){
//			return true;
//		}
//		return false;
//	}
	public void addElement(DesignObject3D child) throws DesignException, GeometricEngineException
	{

		if(child ==null)
		{
			throw new DesignException("Impossible d'ajouter un child null");
		}

//		this.checkIntersectionWithRoot(child);
		
		
		if(canHold(child))
		{	
			if(this instanceof Space3D && child instanceof Separator)
			{
				for(DesignObject3D d : childs)
				{
					if(d instanceof Separator)
					{
						throw new DesignException("Un seprateur existe deja dans cet espace 3d");
					}
				}
				Separator sep =(Separator)child;
				//supprimer le dos si le type est transversale
				if(sep.getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT))
				{
					//trouver le dos
					DesignObject3D dos =null;
					for(DesignObject3D d : childs)
					{
						if(d instanceof Piece2D)
						{
							if(((Piece2D) d).getPiecetype().equals(PieceType.DOS_INTERIEUR))
							{
								dos =d;
								break;
							}
						}
					}
					//Supprimer les dos si il existes
//					if(!(sep.getSepaxe().equals(SeprationAxe.ZAXIS)))
//					{
						if(dos!=null)
						deletechild(dos);
//					}
				}

			}
			//on ne peut bloquer l'insertion de multiple doss dans un seul space3D
//			if(this instanceof Space3D && child instanceof Piece2D) {
//				if(((Piece2D) child).getPiecetype().equals(PieceType.DOS_INTERIEUR)
//						||((Piece2D) child).getPiecetype().equals(PieceType.DOS_EXTERIRUR))
//				{
//					for(DesignObject3D d : this.getChilds())
//					{
//						if(d instanceof Piece2D)
//						{
//							if(((Piece2D) d).getPiecetype().equals(PieceType.DOS_INTERIEUR)||((Piece2D) d).getPiecetype().equals(PieceType.DOS_EXTERIRUR))
//							{
//								throw new DesignException("Un dos existe deja dans cet espace 3d");
//							}
//							if(((Piece2D) d).getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT))
//							{
//								throw new DesignException("Un separateurtraversant le dos existe deja dans cet espace 3d");
//							}
//						}
//					}
//					if(getParentdesign()!=null && getParentdesign() instanceof Separator ) {
//						if(((Space3D)this).getZonetype().equals(Zone3DType.ZONEHAUT)
//								&& ((Separator)getParentdesign()).getSepaxe().equals(SeprationAxe.ZAXIS)) {
//							throw new DesignException("impossible d'ajouter un dos dans un espace3d de type exterieur ");
//						}
//					}
//				}
//			}
			if(child!=null)
			{
				child.addPropertyChangeListener(new PropertyChangeListener() {
					
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						// TODO Auto-generated method stub
						if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
							firePropertyChange("project.modify", null, child);
						}
						
					}
				});
			}
			
			childs.add(child);
			child.setParentdesign(this);			
			firePropertyChange("project.child.added", null, child);
//			if(child!=null && child instanceof Piece2D && 
//					((Piece2D) child).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
//				for(DesignObject3D piece:this.childs)
//					{
//						if(piece instanceof Piece2D) {
//							try {
//								//ajout rainure
//								//Imed bug 0001710 correction calcul de debitage de rainure et créer la rainure seulement il y a un intesection phisyque 
//								//entre le dos et le piece2D 
//								if (!piece.ishasrainure()) {
//									if (child.isIntersect(piece).equals(IntersectionType.INTERSECTION)) {
//	
//										Rainure rainure = new Rainure();
//										rainure.setName(piece.getName() + " Rainure");
//										if (!((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
//											piece.addElement(rainure);
//										}
//									}
//								}
//								if(piece.debitage!=null)
//									piece.debitage.createupdateDebitage();
//								else
//									piece.constructDebitage();
//								
//								piece.evaluate();	
//								piece.propagateUpdateToChildrens(piece);						
//								piece.firePropertyChange("project.recalculate", null, this);
//							} catch (GeometricEngineException e) {					
//								this.setErrorexist(true);
//								this.setErrormsg(e.getMessage());
//								firePropertyChange("project.error", null, true);
//							} finally {
//		
//							}
//						}
//					}
//				try {
//					if(this.debitage!=null)
//						this.debitage.createupdateDebitage();
//					else
//						this.constructDebitage();
//					
//					this.evaluate();	
//					this.propagateUpdateToChildrens(this);						
//				} catch (GeometricEngineException e) {					
//					this.setErrorexist(true);
//					this.setErrormsg(e.getMessage());
//					firePropertyChange("project.error", null, true);
//				}
//			}
		}
		else
		{
			throw new DesignException("Impossible d'ajouter "+child.getName());
		}

		
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(
			this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName,
				listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
		if(isNotificationon())
		{
			propertyChangeSupport.firePropertyChange(propertyName, oldValue,
					newValue);
		}
					
	}
	public PropertyChangeListener[] getListeners() {
		if(propertyChangeSupport==null) {
			return null;
		}
		return	propertyChangeSupport.getPropertyChangeListeners();
	}
	public void removeAllLsteners() {
		PropertyChangeListener[] listeners=getListeners();
		if(listeners==null) {
			return;
		}
		for(PropertyChangeListener listener:listeners) {
			propertyChangeSupport.removePropertyChangeListener(listener);
		}
	}
	public void setErrorexist(boolean errorexist) {

		boolean oldValue = this.errorexist;
		this.errorexist = errorexist;
		firePropertyChange("errorexist", oldValue, errorexist);
	}
	public boolean isErrorexist() {
		return errorexist;
	}
	public void setErrormsg(String errormsg) {

		String oldValue = this.errormsg;
		this.errormsg = errormsg;
		firePropertyChange("errormsg", oldValue, errormsg);
	}
	public String getErrormsg() {
		return errormsg;
	}
	protected void createSubElements() throws DesignException
	{
		
	}
	public void ModifySubElements() throws DesignException
	{
		
	}
	public void clearautomatique() throws DesignException, GeometricEngineException
	{
		List<DesignObject3D> list =  new ArrayList<DesignObject3D>();
		list.addAll(getChilds());
		for(DesignObject3D obj : list)
		{
			obj.clearautomatique();
			obj.setParentdesign(null);
			obj.removeAllLsteners();
			childs.remove(obj);

		}
		
		List<DesignObject3D> listbabies =  new ArrayList<DesignObject3D>();
		if(getBabies()!=null) {
			listbabies.addAll(getBabies());
		}
		for(DesignObject3D obj : listbabies)
		{
				babies.remove(obj);
				if(obj.getParentdesign()!=null) {
					obj.getParentdesign().deletechild(obj);
				}
		}
	}
	public String printDescription()
	{		
		String s="	";
		s+=" 	Default design object "  + getName() +"\n";
		System.out.println(s);
		for(DesignObject3D child : getChilds())
		{
			s+=child.printDescription();
		}
		
		return s;
	}
	public boolean deletechild(DesignObject3D child) throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		if(childs.contains(child))
		{
			boolean sepcontaindos=false;
			if(child instanceof Separator) {
				for(DesignObject3D spaces:child.getChilds()) {
					if(spaces instanceof Space3D) {
						for(DesignObject3D pieces:spaces.getChilds()) {
							if(pieces instanceof Piece2D&& ((Piece2D)pieces).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
								sepcontaindos=true;
							}
						}
					}
				}
			}
			child.clearautomatique();
			child.setParentdesign(null);
			boolean retval =  childs.remove(child);
			if(sepcontaindos) {
				Piece2DCreator piecefactory=new Piece2DCreator();
				piecefactory.setName("Dos");
				piecefactory.setBackmaterial(getBackmaterial());
				piecefactory.setBasematerial(getBasematerial());
				piecefactory.setMaterial(getBackmaterial());
				piecefactory.setPiecetype(PieceType.DOS_INTERIEUR);
				piecefactory.setDostype(DosType.DOSINTERIEUR);
				piecefactory.setParent(this);
				
				piecefactory.create();
				this.addElement(piecefactory.getPiece2DInstance());
			}
			firePropertyChange("project.delete.compoenent", null, true);
			return retval;
		}
		return false;
	}


	public void setLongeurSumOfchilds() {
		// TODO Auto-generated method stub
	}
	public void setUpdatechildsPositions() throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
//		if(this instanceof Caisson) {
//			for(DesignObject3D piece:getChilds()) {
//				if(piece.debitage!=null)
//					piece.debitage.createupdateDebitage();
//				else
//					piece.constructDebitage();
//				
//				piece.evaluate();	
//				piece.updateproperties();
//			}
//			
//		}
		
	}
	public void setNotificationon(boolean notificationon) {
		this.notificationon = notificationon;
	}
	public boolean isNotificationon() {
		return notificationon;
	}
    public void initafterread() {
    	if(props==null) {
    		this.props=new Properties();
    	}
    	propertyChangeSupport = new PropertyChangeSupport(this);

    	for(DesignObject3D child : childs)
	    {	
    		child.initafterread();
    		try {
				setNotificationon(false);
				child.constructDebitage();
				child.evaluate();
				child.updateproperties();
				
				setNotificationon(true);
				
			} catch (DesignException | GeometricEngineException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
    		 
    		child.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
						firePropertyChange("project.modify", null, child);
					}
				}
			});
    		
    	}
    	if(getBackmaterial()!=null) {
    		getBackmaterial().initafterread();
//    		for(Object o:ModelProvider.getMateriallist()) {
//        			if(getBackmaterial().equals((Materiaux)o)) {
//        				setBackmaterial((Materiaux)o);
//        			}
//        		};
    		firePropertyChange("project.modify", null, getBackmaterial());
		}
		if(getBasematerial()!=null) {
        	getBasematerial().initafterread();
//        		for(Object o:ModelProvider.getMateriallist()) {
//        			if(getBasematerial().equals((Materiaux)o)) {
//        				setBasematerial((Materiaux)o);
//        			}
//        		}
    		firePropertyChange("project.modify", null, getBasematerial());
		}
		if(getParams()!=null) {
			for(Parameters param:getParams()) {
				param.initafterread();
			}
		}
		
    }
    @Override
    public List getChildren() {
    	// TODO Auto-generated method stub
    	return childs;
    }

	
	@Override
	public double getXPosition() {
		// TODO Auto-generated method stub
		return getXpos();
	}
	@Override
	public double getYPosition() {
		// TODO Auto-generated method stub
		return getYpos();
	}
	@Override
	public double getZPosition() {
		// TODO Auto-generated method stub
		return getZpos();
	}
	public UsinageParam getUsineparam() {
		return usineparam;
	}
	public void setUsineparam(UsinageParam usineparam) {
		UsinageParam oldValue = this.usineparam;
		this.usineparam = usineparam;
		firePropertyChange("usineparam", oldValue, usineparam);
	}
	public ConstraintParam getConstraintsparam() {
		return constraintsparam;
	}
	public void setConstraintsparam(ConstraintParam constraintsparam) {
		ConstraintParam oldValue = this.constraintsparam;
		this.constraintsparam = constraintsparam;
		firePropertyChange("constraintsparam", oldValue, constraintsparam);
	}
	public double getXpos() {
		return xpos;
	}
	public void setXpos(double xpos) {
		double oldValue = this.xpos;
		this.xpos = xpos;
		firePropertyChange("xpos", oldValue, xpos);
	}
	public double getYpos() {
		return ypos;
	}
	public void setYpos(double ypos) {
		double oldValue = this.ypos;
		this.ypos = ypos;
		firePropertyChange("ypos", oldValue, ypos);
	}
	public double getZpos() {
		return zpos;
	}
	public void setZpos(double zpos) {
		double oldValue = this.zpos;
		this.zpos = zpos;
		firePropertyChange("zpos", oldValue, zpos);
	}
	@Override
	public double gettransparency() {
		// TODO Auto-generated method stub
		return 0;
	}
	
	
	public boolean isLongeurextfree() {
		return longeurextfree;
	}
	public void setLongeurextfree(boolean longeurextfree) {
		boolean oldValue = this.longeurextfree;
		this.longeurextfree = longeurextfree;
		firePropertyChange("longeurextfree", oldValue, longeurextfree);		
	}
	public boolean isProfondeurextfree() {
		return profondeurextfree;
	}
	public void setProfondeurextfree(boolean profondeurextfree) {
		boolean oldValue = this.profondeurextfree;
		this.profondeurextfree = profondeurextfree;
		firePropertyChange("profondeurextfree", oldValue, profondeurextfree);
	}
	public boolean isHauteurextfree() {
		return hauteurextfree;
	}
	public void setHauteurextfree(boolean hauteurextfree) {
		boolean oldValue = this.hauteurextfree;
		this.hauteurextfree = hauteurextfree;
		firePropertyChange("hauteurextfree", oldValue, hauteurextfree);
	}
	public boolean isBasematerialfree() {
		return basematerialfree;
	}
	public void setBasematerialfree(boolean basematerialfree) {
		boolean oldValue = this.basematerialfree;
		this.basematerialfree = basematerialfree;
		firePropertyChange("basematerialfree", oldValue, basematerialfree);
	}
	public boolean isBackmaterialfree() {
		return backmaterialfree;
	}
	public void setBackmaterialfree(boolean backmaterialfree) {
		boolean oldValue = this.backmaterialfree;
		this.backmaterialfree = backmaterialfree;
		firePropertyChange("backmaterialfree", oldValue, backmaterialfree);
	}
	
	
	
	
	
	

	/**
	 * @param selected the selected to set
	 */
	public void setSelected(Boolean selected) {
		if(this.selected==null) {
			this.selected=false;
		}
		boolean oldValue = this.selected;
		this.selected = selected;
		firePropertyChange("selected", oldValue, selected);
	}
	/* (non-Javadoc)
	 * @see tech.frsdev.solids.Solide3D#isSelected()
	 */
	@Override
	public Boolean isSelected() {
		if(this.selected==null) {
			this.selected=false;
		}
		return selected;
	}
	/* (non-Javadoc)
	 * @see tech.frsdev.solids.Solide3D#isHighlighted()
	 */

	@Override
	public Solide3D getParent() {
		// TODO Auto-generated method stub
		return this.getParentdesign();
	}
	public void propagateUpdateToChildrens(DesignObject3D parent) throws GeometricEngineException, DesignException
	{
		//si la source est null alors c est l objet lui même qui a été changé
		if(debitage!=null)
		debitage.createupdateDebitage();
		else
			constructDebitage();
		
		evaluate();
		
		for(DesignObject3D child : childs)
		{

			child.updateMaterialFromParent(this);
			child.propagateUpdateToChildrens(this);
		}
		//imed Bug 0001217 :mise a jour les piece et les usinage relier a cette composant et n'est pas sa fisse directe
		if(babies==null) {
			babies=new ArrayList<DesignObject3D>();
		}
		for(DesignObject3D baby : babies)
		{
			baby.propagateUpdateToChildrens(this);
		}

		//faire la mise des positions apartir de parent
		if(this.getParentdesign()!=null)
		{
			this.getParentdesign().setUpdatechildsPositions();
		}
		if(this instanceof Caisson ) {
			setUpdatechildsPositions();
		}
		if(parent==null)
		{
			firePropertyChange("project.modify", null, this);
			firePropertyChange("project.recalculate", null, this);
			
		}
	}
	protected void updateMaterialFromParent(DesignObject3D parent) {
		// TODO Auto-generated method stub
		if(parent!=null)
		{	
			if(!isBackmaterialfree())
			{
				setBackmaterial(parent.getBackmaterial());
			}
			if(!isBasematerialfree())
			{
				setBasematerial(parent.getBasematerial());
			}
		}		
			
	}
	
	/**
	 * cette methode est utilise pour le debiotage dynamique
	 * @param eList 
	 * @param publicparams 
	 * @param privateparams 
	 * @throws DesignException
	 */
	public void constructGenericDebitage(List<MechanicPrivateParam> privateparams, List<MechanicPublicParam> publicparams, Object emf,DesignObject3D parent) throws DesignException
	{
		//faire passer tous les variables categoriques dans les proprotes de design object
		// avnat de lancer le calcul de debitage et passer la resolutions
		//
		
		if(emf instanceof MechanicDesign)
		{
			MechanicDesign design = ((MechanicDesign)emf);
			
			if(design.getFunctiongroup()!=null)
			{
				int index=0;
				for(FunctionDef f : design.getFunctiongroup().getFunctiondef())
				{
					String func= " function " + f.getName() + "{"+f.getCorps()+"}";
					this.put("$FUNCTION"+index++, func);
				}
			}
		}
		if(emf instanceof MechanicDesignElment)
		{
			MechanicDesignElment elment = ((MechanicDesignElment)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				this.put("EXIST_EXPRESSION", elment.getExistexpression());
			}
			if(this instanceof Piece2D) {
				Piece2D piece=((Piece2D) this);
				if(piece.getMaterialType()!=null && piece.getMaterialType().getMaterial()!=null
						&& piece.getMaterialType().getMaterial().getName()!=null 
						&& !piece.getMaterialType().getMaterial().getName().isEmpty()) {
					this.put("MATERIAL_TYPE", piece.getMaterialType().getMaterial().getName());
					
				}
				if(piece.getVitreMaterialType()!=null&&piece.getVitreMaterialType().getMaterial()!=null
						&&piece.getVitreMaterialType().getMaterial().getName()!=null 
						&& !piece.getVitreMaterialType().getMaterial().getName().isEmpty()) {
					this.put("VITRE_MATERIAL_TYPE", piece.getVitreMaterialType().getMaterial().getName());					
				}
			}
		}
		
		if(emf instanceof UsinageTrou)
		{
			UsinageTrou elment = ((UsinageTrou)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				this.put("EXIST_EXPRESSION", elment.getExistexpression());
			}
			if(elment.getHaveOppositeExpression()!=null && !elment.getHaveOppositeExpression().isEmpty())
			{
				this.put("HAVE_OPPOSITE_EXPRESSION", elment.getHaveOppositeExpression());
			}
		}
		if(emf instanceof param.Rainure)
		{
			param.Rainure elment = ((param.Rainure)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				this.put("EXIST_EXPRESSION", elment.getExistexpression());
			}
		}
		if(emf instanceof Cavity)
		{
			Cavity elment = ((Cavity)emf);
			if(elment.getExistexpression()!=null && !elment.getExistexpression().isEmpty())
			{
				this.put("EXIST_EXPRESSION", elment.getExistexpression());
			}
		}
		
		for(MechanicPublicParam param : publicparams)
		{
			if(param.getKey()!=null && !param.getKey().isEmpty())
			{
				if(param.getTypedef()!=null && param.getTypedefelement()!=null )
				{
					if(param.getTypedefelement().getKey() != null) {
						this.put(param.getKey(), param.getTypedefelement().getKey());
					}else {
						this.put(param.getKey(), "");

					}
				}
				else if(param.getDefaultvalue()!=null && !param.getDefaultvalue().isEmpty())
				{
					String tempkey = param.getKey().replace("@", "");
					if(!param.getKey().contains("_")&&param.getKey().contains(".")) {
						this.put(tempkey.replace('.', '_'), param.getDefaultvalue());
					}
					this.put(param.getKey(), param.getDefaultvalue());
				}
			}
		}
		
		for(MechanicPrivateParam param : privateparams)
		{
			if(param.getKey()!=null && !param.getKey().isEmpty())
			{
				if(param.getTypedef()!=null && param.getTypedefelement()!=null )
				{
					this.put(param.getKey(), param.getTypedefelement().getKey());
				}
				else if(param.getValue()!=null && !param.getValue().isEmpty())
				{
					String tempkey = param.getKey().replace("@", "");
					if(!param.getKey().contains("_")&&param.getKey().contains(".")) {
						this.put(tempkey.replace('.', '_'), param.getValue());
					}
					this.put(param.getKey(), param.getValue());
				}
			}
		}
		if(emf instanceof MechanicDesignElment) {
			MechanicDesignElment elt=(MechanicDesignElment)emf;
			if(elt.isFacadeTypeFree() && elt.getFacadeType()!=null && elt.getFacadeType().getKey()!=null 
					&& !elt.getFacadeType().getKey().isEmpty()) {
				this.put("FACADE_TYPE", elt.getFacadeType().getKey());
				
			}		
			
		}
		debitage = new GenericDebitage(privateparams,publicparams,emf);
		debitage.setParent(parent);
		debitage.setChild(this);
		debitage.createupdateDebitage();
	}
	/**
	 * Cette methode est utilsie pour le debitage generique
	 * @throws GeometricEngineException
	 * @throws DesignException
	 */
	public void evaluategeneric() throws GeometricEngineException, DesignException
	{
		if(debitage!=null)
		{
			debitage.evaluate();
			updateproperties();
		}
		else
		{
			throw new DesignException("Debitage object is null");
		}
	}
	
	public void constructDebitage() throws DesignException
	{
		debitage = new Debitage();
		if(parentdesign==null)
			throw new DesignException("Le parent lors de debitage ne doit pas être null");
		debitage.setParent(parentdesign);
		debitage.setChild(this);
		debitage.createupdateDebitage();
	}
	public void evaluate() throws GeometricEngineException, DesignException
	{
		if(debitage!=null)
		{
			debitage.evaluate();
			updateproperties();
		}
		else
		{
			throw new DesignException("Debitage object is null");
		}
	}
	public Debitage getDebitage() {
		return debitage;
	}
	protected void updateproperties() throws GeometricEngineException
	{
		setNotificationon(false);
		Equation eq=null;
		try {
			if(debitage!=null)
			{
				for(String exportedrefrence : debitage.getExportlist().keySet())
				{
					eq  = Equation.FIND_EQUATION(exportedrefrence, debitage.getEquations());
					if(eq!=null)
					{
						parentdesign.put(debitage.getExportlist().get(exportedrefrence), eq.getEvaluation(null));
					}
					else
					{
						throw new GeometricEngineException(exportedrefrence+ "from "+this.name+" not found in exportation list");
					}
				}
				eq  = Equation.FIND_EQUATION("@this.h@", debitage.getEquations());
				if(eq!=null)
				{
					setHauteurext(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException(this.name + " @this.h@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.l@", debitage.getEquations());
				if(eq!=null)
				{
					setLongeurext(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.l@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.p@", debitage.getEquations());
				if(eq!=null)
				{
					setProfondeurext(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.p@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.hi@", debitage.getEquations());
				if(eq!=null)
				{
					setHauteurint(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.hi@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.li@", debitage.getEquations());
				if(eq!=null)
				{
					setLongeurint(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.li@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.pi@", debitage.getEquations());
				if(eq!=null)
				{
					setProfondeurint(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.pi@ not found to update");
				}
				eq  = Equation.FIND_EQUATION("@this.posx@", debitage.getEquations());
				if(eq!=null)
				{
					setXpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posx@ not found to update");
				}
				
				eq  = Equation.FIND_EQUATION("@this.posy@", debitage.getEquations());
				if(eq!=null)
				{
					setYpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posy@ not found to update");
				}
				
				eq  = Equation.FIND_EQUATION("@this.posz@", debitage.getEquations());
				if(eq!=null)
				{
					setZpos(eq.getEvaluation(null));
				}
				else
				{
					throw new GeometricEngineException("@this.posz@ not found to update");
				}
			}
		} catch (GeometricEngineException e) {
			// TODO: handle exception
			e.printStackTrace();
			throw e;
		}
		finally {
			setNotificationon(true);
		}
		
	}
	public ArrayList<Parameters> getParams() {
		return params;
	}
	public void setParams(ArrayList<Parameters> params) {
		ArrayList<Parameters> oldValue = this.params;
		this.params = params;
		firePropertyChange("params", oldValue, params);
	}
	public void copyParams(List<Parameters> params){
		this.params.clear();
		for(Parameters param : params)
		{
			this.params.add(param.clone());
		}
	}
	public void fillParams(){
		if(getParentdesign()!=null&& getParentdesign().getParams()!=null) {
			this.params.clear();
			DesignObject3D parentparam=getParentdesign();
			while(parentparam!=null 
					&&parentparam.getParams()!=null 
					&&parentparam.getParams().size()==0) {
				parentparam=parentparam.getParentdesign();
			}
			for(Parameters param : parentparam.getParams())
			{
				this.params.add(param.clone());
			}
//			setParams(getParentdesign().getParams());			
		}
	}
	public Parameters getParam(Parameters param) {
		for(Parameters para:getParams()) {
			if(param.equals(para))
			{
				return para;
			}
		}
		return null;
	}
	

	public IntersectionType isIntersect( DesignObject3D planche2){
		

		DesignObject3D planche1  = this;
		Plan3D ppdroite=new Plan3D(planche1);
		Plan3D pphaut=new Plan3D(planche2);
		Plan3D intersection=ppdroite.getIntersection(pphaut);
		if(intersection.getXinter()==null || intersection.getYinter()==null|| intersection.getZinter()==null) {
			return IntersectionType.NOT_RELATED;
		}else {
			if(intersection.getXinter().isPoint() || intersection.getYinter().isPoint()|| intersection.getZinter().isPoint())
			return IntersectionType.TANGENT;
		}
		return IntersectionType.INTERSECTION;
		 
	}
	public Point3D getoppositPoint(DesignObject3D planche1) {
		return new Point3D();
	}
	public void redifinePoints(){
		if(extremes==null) {
			extremes = new Point3D[8];
		}
		Point3D a;
		Point3D b;
		Point3D c;
		Point3D d;
		Point3D e;
		Point3D f;
		Point3D g;
		Point3D h;
		
		a=new Point3D(getXPosABS(),getYPosABS(),getZPosABS());
		
		b=a.Clone();
		b.setX(b.getX()+getLongeurext());
		
		c=b.Clone();
		c.setZ(c.getZ()+getProfondeurext());
		
		d=a.Clone();
		d.setZ(a.getZ()+getProfondeurext());
		
		e=a.Clone();
		e.setY(e.getY()+getHauteurext());
		
		f=e.Clone();
		f.setX(f.getX()+getLongeurext());
		
		g=f.Clone();
		g.setZ(g.getZ()+getProfondeurext());
		
		h=e.Clone();
		h.setZ(h.getZ()+getProfondeurext());
		
		this.extremes[0]=a;
		this.extremes[1]=b;
		this.extremes[2]=c;
		this.extremes[3]=d;
		this.extremes[4]=e;
		this.extremes[5]=f;
		this.extremes[6]=g;
		this.extremes[7]=h;
		
	}
	
	public Plan3D getIntersect( DesignObject3D planche2){
		

		DesignObject3D planche1  = this;
		Plan3D ppdroite=new Plan3D(planche1);
		Plan3D pphaut=new Plan3D(planche2);
		Plan3D intersection=ppdroite.getIntersection(pphaut);
		return intersection;
		 
	}
	
	public void createUsinage() throws GeometricEngineException, DesignException {
		List<DesignObject3D> list =  new ArrayList<DesignObject3D>();
		list.addAll(getChilds());
		for(DesignObject3D design:list) {
			design.createUsinage();
		}
	}
	public void deleteUsinage() throws GeometricEngineException, DesignException {
		for(DesignObject3D design:getChilds()) {
			design.deleteUsinage();
		}
	}
	public Boolean isHasTrous()  {
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Trou) {
				return true;
			}
			if(design.isHasTrous()) {
				return true;
			};
		}
		return false;
	}
	
	/**
	 * un méthode pour supprimer tous les trous contenus dans cette object3D ou un de ses fils 
	 * @throws DesignException
	 * @throws GeometricEngineException
	 */
	public void deleteTrous() throws DesignException, GeometricEngineException  {
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Trou) {
				this.deletechild(design);
			}else {
				design.deleteTrous();
			}		
		}
	}
	
	private boolean ishasrainure() {
		// TODO Auto-generated method stub
		for(DesignObject3D design:getChilds()) {
			if(design instanceof Rainure && !(design instanceof Trou)) {
				return true;
			}
			if(design.ishasrainure()) {
				return true;
			};
		}
		return false;
	}

	public List<Couple> getSystemEquation(Object emf)
	{
		return systemesequations;
	}
	public ArrayList<Couple> getSystemesequations() {
		return systemesequations;
	}
	
	public ArrayList<Couple> getSystemEquationAsParent() {
		return systemesequationsasparent;
	}
	
	
	public Properties getProps() {
		return props;
	}
	public void setProps(Properties props) {
		this.props = props;
	}
	
	public Object put(Object key, Object value) {
//		Object oldvalue=this.getProperty((String) key);
//		firePropertyChange((String) key, oldvalue, value);
		return this.props.put(key, value);
	}
	
	
	public String getProperty(String key) {
		return this.props.getProperty(key);
	}
	
	public String getProperty(String key, String defaultValue) {
		return this.props.getProperty(key, defaultValue);
	}
	
	public synchronized boolean isEmpty() {
		return this.props.isEmpty();
	}
	
	public synchronized Enumeration<Object> keys() {
		return this.props.keys();
	}
	
	public synchronized Enumeration<Object> elements() {
		return this.props.elements();
	}
	
	public synchronized Object get(Object key) {
		return this.props.get(key);
	}
	
	public synchronized void clear() {
		this.props.clear();
	}
	
	public Set<Object> keySet() {
		return this.props.keySet();
	}
	
	public Collection<Object> values() {
		return this.props.values();
	}
	
	public synchronized Object getOrDefault(Object key, Object defaultValue) {
		return this.props.getOrDefault(key, defaultValue);
	}
	
	public synchronized boolean remove(Object key, Object value) {
		return this.props.remove(key, value);
	}
	
	public synchronized boolean replace(Object key, Object oldValue, Object newValue) {
		return this.props.replace(key, oldValue, newValue);
		
	}
	  
	public Set<Map.Entry<Object,Object>> entrySet() {
		return  this.props.entrySet();
	}
	  
	public synchronized boolean containsKey(Object key) {
		return  this.props.containsKey(key);
	}
	@Override
	public  DesignObject3D clone() throws CloneNotSupportedException {		
		return (DesignObject3D) super.clone();
	}
	public abstract DesignObject3D copy(DesignObject3D object) throws DesignException, GeometricEngineException, CloneNotSupportedException 	;

	public DebitageFormulas getDebitageFormulas() {
		if(formulas==null) {
			formulas = new DebitageFormulas();
		}
		return formulas; 
	}
	
	/**
	 *
	 * @return  chercher recursuvement pour les pieces 2D contenue dans un caisson ou un espace3D
	 */
	public List<Piece2D> getListPieces(){
		List<Piece2D> pieces =new ArrayList<Piece2D>();
			for(DesignObject3D design:getChilds() ) {
				if(design instanceof Piece2D ) {
					pieces.add((Piece2D) design);
				}else {
					pieces.addAll(design.getListPieces());
				}
			}
		
		return pieces;
	}
	

	
	/**
	 *
	 * @return  chercher recursuvement pour les pieces 2D contenue dans un caisson ou un espace3D
	 */
	public List<Piece2D> getListCotes(){
		List<Piece2D> pieces =new ArrayList<Piece2D>();
			for(DesignObject3D design:getChilds() ) {
				if(design instanceof Piece2D && design!=null ) {
					Piece2D piece=(Piece2D) design;
					if(piece.getPiecetype()!=null && (piece.getPiecetype().equals(PieceType.COTE_DROITE)
							|| piece.getPiecetype().equals(PieceType.COTE_GAUCHE))) {
						pieces.add((Piece2D) design);
					}
				}
				if(design instanceof Piece2D || design instanceof Space3D) {
					pieces.addAll(design.getListCotes());
				}
			}
		
		return pieces;
	}
	
	public UUID getID() {
		return ID;
	}
	public void setID(UUID iD) {
		ID = iD;
	}
	
	public List<Charniere> getcharniere(DesignObject3D space){
		List<Charniere> list=new ArrayList<Charniere>();
		if(space !=null) {
			for(DesignObject3D ch:space.getChilds()) {
				if(ch instanceof Charniere) {
					list.add((Charniere) ch);
				}else {
					list.addAll(getcharniere(ch));
				}
			}
		}
		
		return list;
	}
	public List<Usinage> getUsinages(DesignObject3D space){
		List<Usinage> list=new ArrayList<Usinage>();
		if(space !=null) {
			for(DesignObject3D ch:space.getChilds()) {
				if(ch instanceof Usinage) {
					list.add((Usinage) ch);
				}else {
					list.addAll(getUsinages(ch));
				}
			}
		}
		
		return list;
	}
	public List<SupportBlocTiroir> getSupportBlocTiroirs(DesignObject3D space){
		List<SupportBlocTiroir> list=new ArrayList<SupportBlocTiroir>();
		if(space !=null) {
			for(DesignObject3D ch:space.getChilds()) {
				if(ch instanceof SupportBlocTiroir) {
					list.add((SupportBlocTiroir) ch);
				}else {
					list.addAll(getSupportBlocTiroirs(ch));
				}
			}
		}
		
		return list;
	}
	public static DesignObject3D getCharniereMother(Charniere ch,DesignObject3D space){
		DesignObject3D origin=ch.getMother();
		if(origin== null ||space==null) {
			return null;
		}
		UUID motherID=origin.getID();

		if(space.getID().equals(motherID)) {
			return space;
		}else {
			for (DesignObject3D design : space.getChilds()) {
				DesignObject3D mother = DesignObject3D.getCharniereMother(ch, design);
				if (mother != null) {
					return mother;
				}

			}
			return null;
		}
		
	}
	public static DesignObject3D getUsinageMother(Usinage usin,DesignObject3D space){
		DesignObject3D origin=usin.getMother();
		if(origin== null ||space==null) {
			return null;
		}
		UUID motherID=origin.getID();

		if(space.getID().equals(motherID)) {
			return space;
		}else {
			for (DesignObject3D design : space.getChilds()) {
				DesignObject3D mother = DesignObject3D.getUsinageMother(usin, design);
				if (mother != null) {
					return mother;
				}

			}
			return null;
		}
		
	}
	public static DesignObject3D getSupportBlocTiroirMother(SupportBlocTiroir usin,DesignObject3D space){
		DesignObject3D origin=usin.getMother();
		if(origin== null ||space==null) {
			return null;
		}
		UUID motherID=origin.getID();

		if(space.getID().equals(motherID)) {
			return space;
		}else {
			for (DesignObject3D design : space.getChilds()) {
				DesignObject3D mother = DesignObject3D.getSupportBlocTiroirMother(usin, design);
				if (mother != null) {
					return mother;
				}
			}
			return null;
		}
		
	}
	public MechanicDesign getMechanicDesignDefinition() {
		return mechanicDesignDefinition;
	}
	public void setMechanicDesignDefinition(MechanicDesign mechanicDesignDefinition) {
		Object old=this.mechanicDesignDefinition;				
		this.mechanicDesignDefinition = mechanicDesignDefinition;
		firePropertyChange("mechanicDesignDefinition", old, mechanicDesignDefinition);
	}
	// setters for public Params of the designDifition for designPurposes

	public boolean setElementPositionType(CaissonType position) {
		try {
			String pos="MONO";
			switch (position) {
			case EXTREME_DROITE:
				pos="DROITE";
				break;
			case EXTREME_GAUCHE:
				pos="GAUCHE";
				break;
			case MILIEU:
				pos="MILIEU";
				break;
			case MONO_CAISSON:
				pos="MONO";
				break;
			default:
				break;
			}
			
			this.mechanicDesignDefinition.getPublicparamgroup().setParamType("POSITION_TYPE", pos);
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	public boolean setElementPorteDirection(PorteDirection direction) {
		String dir="LEFT";
		switch (direction) {
		case LEFT:
			dir="LEFT";
			break;
		case RIGHT:
			dir="RIGHT";
			break;
		default:
			break;
		}
		try {
			this.mechanicDesignDefinition.getPublicparamgroup().setParamType("PORTE_DIRECTION", dir);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		
		return true;
	}
	
	public boolean setElementPoigneeType(PoigneeType direction) {
		String dir="AVEC_POIGNEE";
		switch (direction) {
		case AVEC_POIGNEE:
			dir="AVEC_POIGNEE";
			break;
		case SANS_POIGNEE:
			dir="SANS_POIGNEE";

		default:
			break;
		}
		try {
			this.mechanicDesignDefinition.getPublicparamgroup().setParamType("POIGNEE_TYPE", dir);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		
		
		return true;
	}

	public boolean setElementPorteType(PortType direction) {
		String dir="FRANCAISE";
		switch (direction) {
		case FRANCAISE:
			dir="FRANCAISE";
			break;
		case FRANCAISE2V:
			dir="FRANCAISE2V";
		case BASCULANT:
			dir="BASCULANT";
			break;
		case BASCULANT2H:
			dir="BASCULANT2H";
			break;
		case COLISSANT:
			dir="COLISSANT";
			break;
		case FRANCAISE2H:
			dir="FRANCAISE2H";
			break;
		case BASCULANT2H2P:
			dir ="BASCULANT2H2P0";
			break;
		default:
			break;
		}
		try {
			this.mechanicDesignDefinition.getPublicparamgroup().setParamType("PORT_TYPE", dir);
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		
		
		return true;
	}
	//
	
	// getters for public Params of the designDifition for designPurposes
	public MechanicPublicParam getElementPositionType() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("POSITION_TYPE");
	}
	
	public CaissonType getPositionType() {
		try {
			MechanicPublicParam param=getElementPositionType();
			if(param==null) {
				return CaissonType.MONO_CAISSON;
			}
			String type=param.getTypedefelement().getKey();
			switch (type) {
			case "DROITE":
				return CaissonType.EXTREME_DROITE;
				
			case "GAUCHE" :
				return	CaissonType.EXTREME_GAUCHE;
				
			case "MILIEU" :
				return CaissonType.MILIEU;
				
			case "MONO":
				return CaissonType.MONO_CAISSON;
				
			default:
				return CaissonType.MONO_CAISSON;
			}
		}
		catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public MechanicPublicParam getElementPorteDirection() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("PORTE_DIRECTION");
	}
	
	public PorteDirection getPorteDirection() {
		MechanicPublicParam param;
		
		try {
			param =getElementPorteDirection();
			if(param==null) {
				return PorteDirection.LEFT;
			}
			String type=param.getTypedefelement().getKey();
			
			switch (type) {
			case "LEFT":
				return PorteDirection.LEFT;
				
			case "RIGHT":
				return PorteDirection.RIGHT;
				
			default:
				return PorteDirection.LEFT;
				
			}
		} catch (Exception e) {
			
			e.printStackTrace();
			return null; 
		}
	}
	
	public MechanicPublicParam getElementPoigneeType() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("POIGNEE_TYPE");
	}
	
	public PoigneeType getPoigneeType(){
		
		MechanicPublicParam param;
		try {
			param = getElementPoigneeType();
			if(param==null) {
				return PoigneeType.AVEC_POIGNEE;
			}
			String type=param.getTypedefelement().getKey();
	
			switch (type) {
			case "AVEC_POIGNEE":
				return PoigneeType.AVEC_POIGNEE;

			case "SANS_POIGNEE":
				return PoigneeType.SANS_POIGNEE;

			default:
				return PoigneeType.AVEC_POIGNEE;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	
	public MechanicPublicParam getElementPorteType() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("PORT_TYPE");
	}
	
	public PortType getPorteType() {
		try {
			MechanicPublicParam param=getElementPorteType();
			if(param==null) {
				return  PortType.FRANCAISE;
			}
			String type=param.getTypedefelement().getKey();
			
			switch (type) {
			case "FRANCAISE":
				return PortType.FRANCAISE;
			
			case "FRANCAISE2V":
				return PortType.FRANCAISE2V;
				
			case "BASCULANT":
				return PortType.BASCULANT;
				
			case "BASCULANT2H":
				return PortType.BASCULANT2H;
				
			case "COLISSANT":
				return PortType.COLISSANT;
				
			case "FRANCAISE2H":
				return PortType.FRANCAISE2H;	
			case "BASCULANT2H2P":
				return PortType.BASCULANT2H2P;
			default:
				return PortType.FRANCAISE;
			}
		}catch (Exception e) {
			e.printStackTrace();
			return null;
		}	
	}
	public MechanicPublicParam getElementPoigneePosition() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("POIGNEE_POSITION");
	}
	public PoigneePosition getPoigneePosition() {
		try {
			MechanicPublicParam param=getElementPoigneePosition();
			if(param==null) {
				return PoigneePosition.TOP_LEFT;
			}
			String type=param.getTypedefelement().getKey();
			
			switch (type) {
			case "BOTTOM_LEFT":
				return PoigneePosition.BOTTOM_LEFT;
			
			case "BOTTOM_MIDDLE":
				return PoigneePosition.BOTTOM_MIDDLE;
				
			case "BOTTOM_RIGHT":
				return PoigneePosition.BOTTOM_RIGHT;
				
			case "LEFT_MIDDLE":
				return PoigneePosition.LEFT_MIDDLE;
				
			case "RIGHT_MIDDLE":
				return PoigneePosition.RIGHT_MIDDLE;
				
			case "TOP_LEFT":
				return PoigneePosition.TOP_LEFT;	
			case "TOP_MIDDLE":
				return PoigneePosition.TOP_MIDDLE;
				
			case "TOP_RIGHT":
				return PoigneePosition.TOP_RIGHT;
				
			case "CENTER":
				return PoigneePosition.CENTER;	
			default:
				return PoigneePosition.TOP_LEFT;
			}
		}catch (Exception e) {
			e.printStackTrace();
			return null;
		}	
	}
	public boolean setPoigneePosition(PoigneePosition position) {
		try {
			String pos="TOP_RIGHT";
			switch (position) {
			case BOTTOM_LEFT:
				pos= "BOTTOM_LEFT";
			break;
			case BOTTOM_MIDDLE:
				pos= "BOTTOM_MIDDLE";
				break;
			case BOTTOM_RIGHT:
				pos= "BOTTOM_RIGHT";
				break;
			case LEFT_MIDDLE:
				pos=  "LEFT_MIDDLE";
				break;
			case RIGHT_MIDDLE:
				pos= "RIGHT_MIDDLE";
				break;
			case TOP_LEFT:
				pos= "TOP_LEFT";	
				break;
			case TOP_MIDDLE:
				pos= "TOP_MIDDLE";
				break;
			case TOP_RIGHT:
				pos= "TOP_RIGHT";	
				break;
			case CENTER:
				pos= "CENTER";	
				break;
			}
			
			this.mechanicDesignDefinition.getPublicparamgroup().setParamType("POIGNEE_POSITION", pos);
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	
	public MechanicPublicParam getElementPoigneeOrientation() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("POIGNEE_ORIENTATION");
	}
	
	public Orientation getPoigneeOrientation(){
		
		MechanicPublicParam param;
		
		try {
			param = getElementPoigneeOrientation();
			if(param==null) {
				return Orientation.HORIZONTAL;
			}
			String type=param.getTypedefelement().getKey();
	
			switch (type) {
			case "HORIZONTAL":
				return Orientation.HORIZONTAL;

			case "VERTICAL":
				return Orientation.VERTICAL;

			default:
				return Orientation.HORIZONTAL;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	public boolean setPoigneeOrientation(Orientation position) {
		try {
			String pos="HORIZONTAL";
			switch (position) {
			case HORIZONTAL:
				pos= "HORIZONTAL";
				break;
			case VERTICAL:
				pos= "VERTICAL";
				break;
			default:
				pos= "HORIZONTAL";
				break;
			
			}
			
			this.mechanicDesignDefinition.getPublicparamgroup().setParamType("POIGNEE_ORIENTATION", pos);
			
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}
	public double getDesignLongeur() throws Exception {
		MechanicPublicParam param= this.mechanicDesignDefinition.getPublicParam("global.l");
		String value=param.getDefaultvalue();
		double longeur=Double.valueOf(value);
		
		return longeur;
		
	}
	
	public double getDesignHauteur() throws Exception {
		MechanicPublicParam param= this.mechanicDesignDefinition.getPublicParam("global.h");
		String value=param.getDefaultvalue();
		double longeur=Double.valueOf(value);
		
		return longeur;
		
	}
	public double getDesignMaxPorteLongeur() {
		MechanicPublicParam param;
		double longeur=600.0;
		try {
			param = this.mechanicDesignDefinition.getPublicParam("PORTE_MAXWIDTH");
			if(param!=null)
			{
				String value=param.getDefaultvalue();
				longeur=Double.valueOf(value);

			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		return longeur;
		
	}
	public double getDesignProfondeur() throws Exception {
		MechanicPublicParam param= this.mechanicDesignDefinition.getPublicParam("global.p");
		String value=param.getDefaultvalue();
		double longeur=Double.valueOf(value);
		
		return longeur;
		
	}
	public boolean getDesignContainSocle() {
		String value = "";
		MechanicPublicParam param;
		try {
			param = this.mechanicDesignDefinition.getPublicParam("contains_socle");
			value=param.getTypedefelement().getKey();
			return Boolean.valueOf(value);
		} catch (Exception e) {
		}
		return false;
		
	}
	public float getDesignAltitude() {
		float altitude=0;
		String value = null;
		MechanicPublicParam param;
		try {
			param = this.mechanicDesignDefinition.getPublicParam("element.positionY");
			value=param.getDefaultvalue();
			altitude = value!=null?Float.valueOf(value):0;
		} catch (Exception e) {
		}
		return altitude;
	}
	public PositionReferenceType getDesignAltitudeReference() {
		PositionReferenceType reference=PositionReferenceType.BAS;
		String value = "";
		MechanicPublicParam param;
		try {
			param = this.mechanicDesignDefinition.getPublicParam("element_YReference");
			value=param.getTypedefelement().getKey();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(value!=null && value.toUpperCase().contentEquals("TOP")) {
			reference =PositionReferenceType.HAUT;
		}else {
			reference=PositionReferenceType.BAS;
		}
		return reference;
	}
	public String getDesignCaissonType() {
		String value = "";
		MechanicPublicParam param;
		try {
			param = this.mechanicDesignDefinition.getPublicParam("CAISSON_TYPE");
			value=param.getTypedefelement().getKey();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return value;
		
	}
	public int getNbTiroir() {
		String value = null;
		MechanicPublicParam param;
		try {
			param = this.mechanicDesignDefinition.getPublicParam("NB_TIROIR");
			value=param.getDefaultvalue();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return value!=null?Integer.valueOf(value):-1;
		
	}
	//
	public MechanicPublicParam getElementNombrEtagere() throws Exception {
		return this.mechanicDesignDefinition.getPublicParam("ETAGERE_COUNT");
	}
	
	public float getFacadeThickness() {
		float thickness = 0;
		for( DesignObject3D designX : getListPieces()) {
			if(designX instanceof Piece2D) {
				Piece2D piece2D = (Piece2D) designX;
				if((piece2D.getPiecetype() == PieceType.PORTE )|| (piece2D.getPiecetype() == PieceType.PORTE_GAUCHE ) ||
						(piece2D.getPiecetype() == PieceType.PORTE_DROITE || piece2D.getPiecetype() == PieceType.FACADE||
						piece2D.getPiecetype() == PieceType.PORTE_BAS || (piece2D.getPiecetype() == PieceType.PORTE_HAUT))) {
					float pieceThickness = (float) piece2D.getProfondeurext();
					if( pieceThickness > thickness)
						thickness = pieceThickness;
				}
			}
		}
		return thickness;
	}
	
	//
	public Vector3 getfourPosition() {
		try {
			String caissonType=getDesignCaissonType();
			if (caissonType != null && !caissonType.isEmpty()) {
				if ((caissonType.contentEquals("COLONNE_FOUR")
						|| caissonType.contentEquals("COLONNE_FOUR_MICROONDE"))) {
					PoigneeType poigneeType = getPoigneeType();
					float sep1Position = 1.0f;
					float sep2Position = 1.0f;
					String sep1Name = "";
					String sep2Name = "";
//					if (poigneeType.equals(PoigneeType.AVEC_POIGNEE)) {
						sep1Name = "separator.position";
						sep2Name = "separator2.position";
//					} else {
//						sep1Name = "separator.sansPoignee_position";
//						sep2Name = "separator2.sansPoignee_position";
//					}
					MechanicPrivateParam paramsep1Position = this.mechanicDesignDefinition.getPrivateParam(sep1Name);
					MechanicPrivateParam paramsep2Position = this.mechanicDesignDefinition.getPrivateParam(sep2Name);
					String valueSep1Position = paramsep1Position.getValue();
					String valueSep2Position = paramsep2Position.getValue();
					sep1Position = Float.valueOf(valueSep1Position);
					sep2Position = Float.valueOf(valueSep2Position);
					float x = (float) (getLongeurext() / 2000f);
					float y = (sep1Position + sep2Position) / 2000f;
					float z = (float) getProfondeurext() / 2000f + 0.026f;
					Vector3 pos = new Vector3(x, y, z);
					return pos;
				}else if(caissonType.contentEquals("BAS_FOUR")) {
					float x = (float) (getLongeurext() / 2000f);
					float y = (float) (getHauteurext() / 2000f)+0.012f;
					float z = (float) getProfondeurext() / 2000f + 0.026f;
					Vector3 pos = new Vector3(x, y, z);
					return pos;
				}

			}
		} catch (Exception e) {
			
			e.printStackTrace();
			return null;
		}
		
		
		return null;
	}
	public Vector3 getfourDimention() {
		try {
			String caissonType=getDesignCaissonType();
			if (caissonType != null && !caissonType.isEmpty()) {
				if ((caissonType.contentEquals("COLONNE_FOUR")
						|| caissonType.contentEquals("COLONNE_FOUR_MICROONDE"))) {
					PoigneeType poigneeType = getPoigneeType();
					float sep1Position = 1.0f;
					float sep2Position = 1.0f;
					String sep1Name = "";
					String sep2Name = "";
//					if (poigneeType.equals(PoigneeType.AVEC_POIGNEE)) {
						sep1Name = "separator.position";
						sep2Name = "separator2.position";
//					} else {
//						sep1Name = "separator.sansPoignee_position";
//						sep2Name = "separator2.sansPoignee_position";
//					}
					MechanicPrivateParam paramsep1Position = this.mechanicDesignDefinition.getPrivateParam(sep1Name);
					MechanicPrivateParam paramsep2Position = this.mechanicDesignDefinition.getPrivateParam(sep2Name);
					String valueSep1Position = paramsep1Position.getValue();
					String valueSep2Position = paramsep2Position.getValue();
					sep1Position = Float.valueOf(valueSep1Position);
					sep2Position = Float.valueOf(valueSep2Position);
					float x = (float) (getLongeurext() / 1000f) - 0.036f;
					float y = (sep1Position - sep2Position) / 1000f - 0.018f;
					float z = (float) getProfondeurext() / 1000f - 0.052f;
					Vector3 pos = new Vector3(x, y, z);
					return pos;
				}else if(caissonType.contentEquals("BAS_FOUR")) {
					float x = (float) (getLongeurext() / 1000f)-0.036f;
					float y = (float) (getHauteurext() / 1000f)-0.133f;
					float z = (float) getProfondeurext() / 1000f - 0.026f;
					Vector3 pos = new Vector3(x, y, z);
					return pos;
				}
			}
		} catch (Exception e) {
			
			e.printStackTrace();
			return null;
		}
		
		
		return null;
	}
	public Vector3 getMicroondePosition() {
		try {
			String caissonType=getDesignCaissonType();
			if(caissonType!=null&& !caissonType.isEmpty()
					&&(caissonType.contentEquals("COLONNE_FOUR_MICROONDE")||caissonType.contentEquals("COLONNE_MICROONDE"))) {
				PoigneeType poigneeType=getPoigneeType();
				float sep1Position=1.0f;
				float sep2Position=1.0f;
				String sep1Name="";
				String sep2Name="";
				sep1Name="separator2.position";
				sep2Name="separator3.position";
				if(caissonType.contentEquals("COLONNE_MICROONDE")) {
					sep1Name="separator.position";
					sep2Name="separator2.position";
				}
				MechanicPrivateParam paramsep1Position=this.mechanicDesignDefinition.getPrivateParam(sep1Name);
				MechanicPrivateParam paramsep2Position=this.mechanicDesignDefinition.getPrivateParam(sep2Name);
				String valueSep1Position=paramsep1Position.getValue();
				String valueSep2Position=paramsep2Position.getValue();
				sep1Position=Float.valueOf(valueSep1Position);
				sep2Position=Float.valueOf(valueSep2Position);
				float x=(float)(getLongeurext()/2000f);
				float y= (sep1Position+sep2Position)/2000f;
				float z=(float)getProfondeurext()/2000f+0.026f;
				Vector3 pos=new Vector3(x,y, z);
				return pos;
			}
		} catch (Exception e) {
			
			e.printStackTrace();
			return null;
		}
		
		
		return null;
	}
	public Vector3 getMicroondeDimention() {
		try {
			String caissonType=getDesignCaissonType();
			if(caissonType!=null&& !caissonType.isEmpty()
					&&(caissonType.contentEquals("COLONNE_FOUR_MICROONDE")||caissonType.contentEquals("COLONNE_MICROONDE"))) {

				PoigneeType poigneeType=getPoigneeType();
				float sep1Position=1.0f;
				float sep2Position=1.0f;
				String sep1Name="";
				String sep2Name="";
				sep1Name="separator2.position";
				sep2Name="separator3.position";
				if(caissonType.contentEquals("COLONNE_MICROONDE")) {
					sep1Name="separator.position";
					sep2Name="separator2.position";
				}
				MechanicPrivateParam paramsep1Position=this.mechanicDesignDefinition.getPrivateParam(sep1Name);
				MechanicPrivateParam paramsep2Position=this.mechanicDesignDefinition.getPrivateParam(sep2Name);
				String valueSep1Position=paramsep1Position.getValue();
				String valueSep2Position=paramsep2Position.getValue();
				sep1Position=Float.valueOf(valueSep1Position);
				sep2Position=Float.valueOf(valueSep2Position);
				float x=(float)(getLongeurext()/1000f)-0.036f;
				float y= (sep1Position-sep2Position)/1000f-0.018f;
				float z=(float)getProfondeurext()/1000f-0.052f;
				Vector3 pos=new Vector3(x,y, z);
				return pos;
			}
		} catch (Exception e) {
			
			e.printStackTrace();
			return null;
		}
		
		
		return null;
	}
	public Vector3 getFrigoPosition() {
		try {
			String caissonType=getDesignCaissonType();
			if(caissonType!=null&& !caissonType.isEmpty() && caissonType.contentEquals("COLONNE_FRIGO")) {
				MechanicPrivateParam paramsep1Position=this.mechanicDesignDefinition.getPrivateParam("separator.position");
				String valueSep1Position=paramsep1Position.getValue();
				float sep1Position=Float.valueOf(valueSep1Position);
				float x=(float)(getLongeurext()/2000f);
				float y= (sep1Position+0.009f)/2000f;
				float z=(float)getProfondeurext()/2000f+0.026f;
				Vector3 pos=new Vector3(x,y, z);
				return pos;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		return null;
	}
	public Vector3 getFrigoDimention() {
		try {
			String caissonType=getDesignCaissonType();
			if(caissonType!=null&& !caissonType.isEmpty() && caissonType.contentEquals("COLONNE_FRIGO")) {
				MechanicPrivateParam paramsep1Position=this.mechanicDesignDefinition.getPrivateParam("separator.position");
				String valueSep1Position=paramsep1Position.getValue();
				float sep1Position=Float.valueOf(valueSep1Position);
				float x=(float)(getLongeurext()/1000f)+0.036f;
				float y= sep1Position/1000f-0.027f;
				float z=(float)getProfondeurext()/1000f+0.052f;
				Vector3 pos=new Vector3(x,y, z);
				return pos;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		return null;
	}
	//
	public Kitchen getKitchen() {
		return kitchen;
	}
	public void setKitchen(Kitchen kitchen) {
		Kitchen oldValue=this.kitchen;
		this.kitchen = kitchen;
		firePropertyChange("kitchen", oldValue, this.kitchen);
	}
	public int getSceneNumber() {
		return sceneNumber;
	}
	public void setSceneNumber(int sceneNumber) {
		this.sceneNumber = sceneNumber;
	}
	
	public void generateElementsGcode() {
		for(DesignObject3D piece: getListPieces()) {
			if(piece instanceof Piece2D) {
				((Piece2D)piece).generateElementsGcode();
			}
		}
	}

	@Override
	public double getXSize() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public double getYSize() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public double getZSize() {
		// TODO Auto-generated method stub
		return 0;
	}
	@Override
	public BufferedImage getImage() {
		// TODO Auto-generated method stub
		return null;
	}
	@Override
	public boolean isdrawable() {
		// TODO Auto-generated method stub
		return false;
	}
	@Override
	protected void finalize() throws Throwable {
		removeAllLsteners();
		super.finalize();
	}
	
	
	
	public int getSceneIndex() {
		if(isFausseFacade()) {
			return ProjectManager.getManager().getCurrentKitchen().getElementsFausseFacades().indexOf(this) + 1;

		}else {
			return ProjectManager.getManager().getCurrentKitchen().getElementsWithoutFausseFacades().indexOf(this) + 1;
		}
	}
	
	public boolean isFausseFacade() {
		return getDesignCaissonType().contentEquals("FAUSSE_FACADE");
	}
	
	public void dispose() {
		removeAllLsteners();
		
		for(DesignObject3D d : childs) {
			if(d!=null)d.dispose();
		}
		for(DesignObject3D d : babies) {
			if(d!=null)d.dispose();
		}
		
		if(systemesequations!=null)systemesequations.clear();
		if(systemesequations!=null)systemesequationsasparent.clear();
		if(mechanicDesignDefinition!=null)mechanicDesignDefinition.dispose();
		childs.clear();
		babies.clear();
		params.clear();
		props.clear();
		parentdesign= null;
		if(debitage!=null) {
			debitage.dispose();
		}
		if(formulas!=null) {
			formulas.dispose();
		}
		
		formulas = null;
		debitage=null;
		basematerial=null;
		backmaterial=null;
		childs=null;
		babies=null;
		params=null;
		mechanicDesignDefinition = null;
		systemesequations = null;
		systemesequationsasparent = null;
		props=null;
		propertyChangeSupport =null;
		kitchen=null;
		extremes=null;
		}

}
