package dressing.controller;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Etagere;
import dressing.model.Materiaux;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import dressing.model.types.Zone3DType;

public class SeparatorCreator implements Creator{
	String name;
	Materiaux basematerial;
	Materiaux backmaterial;
	Materiaux material;
	PositionCalculationType positionCalculationType = PositionCalculationType.POURCENT;
	double separationposition;
	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
	boolean sepratortransversal = true;
	PieceType piecetype = null;
	Piece2D piece2d;
	DesignObject3D parent;
	boolean isSepIsometrique = true;
	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
	double sepRetrait = 0;
	double sepretraitderiere = 0;
	PropertyChangeListener pcl;
	boolean sepnotisometrique = !isSepIsometrique;

	public boolean isSepnotisometrique() {
		return sepnotisometrique;
	}

	public void setSepnotisometrique(boolean sepnotisometrique) {
		boolean oldValue = this.sepnotisometrique;
		this.sepnotisometrique = sepnotisometrique;
		firePropertyChange("sepnotisometrique", oldValue, sepnotisometrique);
	}

	public double getSepRetrait() {
		return sepRetrait;
	}

	public void setSepRetrait(double sepRetrait) {
		double oldValue = this.sepRetrait;
		this.sepRetrait = sepRetrait;
		firePropertyChange("sepRetrait", oldValue, sepRetrait);
	}

	public double getSepretraitderiere() {
		return sepretraitderiere;
	}

	public void setSepretraitderiere(double sepretraitderiere) {
		double oldValue = this.sepretraitderiere;
		this.sepretraitderiere = sepretraitderiere;
		firePropertyChange("sepretraitderiere", oldValue, sepretraitderiere);
	}

	public PositionReferenceType getSepPosRefType() {
		return sepPosRefType;
	}

	public void setSepPosRefType(PositionReferenceType sepPosRefType) {
		PositionReferenceType oldValue = this.sepPosRefType;
		this.sepPosRefType = sepPosRefType;
		firePropertyChange("sepPosRefType", oldValue, sepPosRefType);
	}

	public boolean getIsSepIsometrique() {
		return isSepIsometrique;
	}

	public void setIsSepIsometrique(boolean isSepIsometrique) {
		boolean oldValue = this.isSepIsometrique;
		this.isSepIsometrique = isSepIsometrique;
		firePropertyChange("isSepIsometrique", oldValue, isSepIsometrique);
		setSepnotisometrique(!isSepIsometrique);
	}

	public Materiaux getBasematerial() {
		return basematerial;
	}

	transient protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
	}

	public void setBasematerial(Materiaux basematerial) {
		Materiaux oldValue = this.basematerial;
		this.basematerial = basematerial;
		firePropertyChange("basematerial", oldValue, basematerial);
	}

	public Materiaux getBackmaterial() {
		return backmaterial;
	}

	public void setBackmaterial(Materiaux backmaterial) {
		Materiaux oldValue = this.backmaterial;
		this.backmaterial = backmaterial;
		firePropertyChange("backmaterial", oldValue, backmaterial);
	}

	public PositionCalculationType getPositionCalculationType() {
		return positionCalculationType;
	}

	public void setPositionCalculationType(PositionCalculationType positionCalculationType) {
		PositionCalculationType oldValue = this.positionCalculationType;
		this.positionCalculationType = positionCalculationType;
		firePropertyChange("positionCalculationType", oldValue, positionCalculationType);
	}

	public double getSeparationposition() {
		return separationposition;
	}

	public void setSeparationposition(double separationposition) {
		double oldValue = this.separationposition;
		this.separationposition = separationposition;
		firePropertyChange("separationposition", oldValue, separationposition);
	}

	public SeprationAxe getSeprationaxe() {
		return seprationaxe;
	}

	public void setSeprationaxe(SeprationAxe seprationaxe) {
		SeprationAxe oldValue = this.seprationaxe;
		this.seprationaxe = seprationaxe;
		firePropertyChange("seprationaxe", oldValue, seprationaxe);
	}

	public boolean isSepratortransversal() {
		return sepratortransversal;
	}

	public void setSepratortransversal(boolean sepratortransversal) {
		boolean oldValue = this.sepratortransversal;
		this.sepratortransversal = sepratortransversal;
		firePropertyChange("sepratortransversal", oldValue, sepratortransversal);
	}

	public DesignObject3D getParent() {
		return parent;
	}

	public void setParent(DesignObject3D parent) {
		DesignObject3D oldValue = this.parent;
		this.parent = parent;
		firePropertyChange("parent", oldValue, parent);
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		String oldValue = this.name;
		this.name = name;
		firePropertyChange("name", oldValue, name);
	}

	public Materiaux getMaterial() {
		return material;
	}

	public void setMaterial(Materiaux material) {
		Materiaux oldValue = this.material;
		this.material = material;
		firePropertyChange("material", oldValue, material);
	}

	public PieceType getPiecetype() {
		return piecetype;
	}

	public void setPiecetype(PieceType piecetype) {
		PieceType oldValue = this.piecetype;
		this.piecetype = piecetype;
		firePropertyChange("piecetype", oldValue, piecetype);
	}

	public void create() throws DesignException, GeometricEngineException {
		// TODO Auto-generated method stub
		createSubElements();
	}

	/**
	 * C'est le resultat attendue
	 * 
	 * @return
	 */
	public DesignObject3D getPiece2DInstance() {
		// TODO Auto-generated method stub
		return piece2d;
	}

	public void check() throws DesignException {
		if (getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)
				|| getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
			if (getPositionCalculationType().equals(PositionCalculationType.POURCENT)) {
				if (getSeparationposition() >= 100) {
					throw new DesignException("le position de separation doit etre inférieur a 100%");
				}
			}
		}
		// bloquer le position du separateur pour etre dans l'espace3D
		if (getSeprationaxe().equals(SeprationAxe.YAXIS)) {
			if (getSeparationposition() > getParent().getHauteurint()) {
				throw new DesignException(
						"impossible d'ajouter un separateur avec position sepurieur a la Hauteur du parent");
			}
		} else if (getSeprationaxe().equals(SeprationAxe.XAXIS)) {
			if (getSeparationposition() > getParent().getLongeurint()) {
				throw new DesignException(
						"impossible d'ajouter un separateur avec position sepurieur a la Longeur du parent");
			}
		} else {
			if (getSeparationposition() > getParent().getProfondeurint() - getMaterial().getEpaisseur()) {
				throw new DesignException(
						"impossible d'ajouter un separateur avec position sepurieur a la Profondeur du parent");
			}
		}
		//
	}

	public void createSubElements() throws DesignException, GeometricEngineException {
		check(); // On met le controle dans une seule fonction
		if (getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)
				|| getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
			piece2d = new Separator((Space3D) getParent(), separationposition, getPositionCalculationType(),
					getSeprationaxe(), getIsSepIsometrique(), getSepPosRefType(), getSepRetrait(),
					getSepretraitderiere());
		} else if (getPiecetype().equals(PieceType.ETAGERE_FIXE) || getPiecetype().equals(PieceType.ETAGERE_MOBILE)) {

			piece2d = new Etagere((Space3D) parent, separationposition, getPositionCalculationType(), getSeprationaxe(),
					getSepRetrait());
		}

		else {
			piece2d = new Piece2D();
		}
		piece2d.setName(getName());
		piece2d.setBackmaterial(getBackmaterial());
		piece2d.setBasematerial(getBasematerial());
		piece2d.setMaterial(getMaterial());
		piece2d.setParentdesign(parent);
		piece2d.setPiecetype(getPiecetype());
		piece2d.constructDebitage();
		piece2d.evaluate();

		// creer les pieces necessaires
		// si c est un separateur ilfuat creer les deux champs
		if (getPiecetype().equals(PieceType.SEPRATEUR_TRANSVERSANT)) {
			((Separator) piece2d).setIsSepIsometrique(getIsSepIsometrique());
			((Separator) piece2d).setPosRefType(getSepPosRefType());

			String zone = "1";

			if (getSeprationaxe().equals(SeprationAxe.YAXIS)) {
				zone = "Haut";
			} else if (getSeprationaxe().equals(SeprationAxe.XAXIS)) {
				zone = "Gauche";
			} else {
				zone = "Exterieur";
			}
			Space3D space = ((Separator) piece2d).getLefttopchild();
			space.setName("Zone " + zone);
			space.setBackmaterial(getBackmaterial());
			space.setBasematerial(getBasematerial());
			space.setParentdesign(piece2d);
			space.setZonetype(Zone3DType.ZONEHAUT);
			space.setPorttype(((Space3D) piece2d.getParentdesign()).getPorttype());
			space.constructDebitage();
			space.evaluate();
			piece2d.addElement(space);
			Piece2DCreator piececreator = new Piece2DCreator();
			if (!(getSeprationaxe().equals(SeprationAxe.ZAXIS))) {
				if (piece2d.getParentdesign() != null && piece2d.getParentdesign() instanceof Space3D) {
					Boolean isParentHasDos = false;
					for (DesignObject3D piece : piece2d.getParentdesign().getChilds()) {
						if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
							isParentHasDos = true;
						}
					}
					if (isParentHasDos) {
						piececreator.setBackmaterial(getBackmaterial());
						piececreator.setBasematerial(getBasematerial());
						piececreator.setParent(space);
						piececreator.setName("Dos " + zone);
						piececreator.setPiecetype(PieceType.DOS_INTERIEUR);
						piececreator.setMaterial(getBackmaterial());
						piececreator.create();
						space.addElement(piececreator.getPiece2DInstance());
					}
				}
			}

			if (getSeprationaxe().equals(SeprationAxe.YAXIS)) {
				zone = "Bas";
			} else if (getSeprationaxe().equals(SeprationAxe.XAXIS)) {
				zone = "Droite";
			} else {
				zone = "Interieur";
			}

			space = ((Separator) piece2d).getRightdownchild();
			space.setName("Zone " + zone);
			space.setBackmaterial(getBackmaterial());
			space.setBasematerial(getBasematerial());
			space.setParentdesign(piece2d);
			space.setZonetype(Zone3DType.ZONEBAS);
			space.setPorttype(((Space3D) piece2d.getParentdesign()).getPorttype());
			space.constructDebitage();
			space.evaluate();
			piece2d.addElement(space);

			// if(!(getSeprationaxe().equals(SeprationAxe.ZAXIS)) ) {
			if (piece2d.getParentdesign() != null && piece2d.getParentdesign() instanceof Space3D) {
				Boolean isParentHasDos = false;
				for (DesignObject3D piece : piece2d.getParentdesign().getChilds()) {
					if (((Piece2D) piece).getPiecetype().equals(PieceType.DOS_INTERIEUR)) {
						isParentHasDos = true;
					}
				}
				if (isParentHasDos) {
					piececreator = new Piece2DCreator();
					piececreator.setBackmaterial(getBackmaterial());
					piececreator.setBasematerial(getBasematerial());
					piececreator.setParent(space);
					piececreator.setName("Dos " + zone);
					piececreator.setPiecetype(PieceType.DOS_INTERIEUR);
					piececreator.setMaterial(getBackmaterial());
					piececreator.create();
					space.addElement(piececreator.getPiece2DInstance());
				}
			}
			// }

		} else if (getPiecetype().equals(PieceType.SEPRATEUR_NORMAL)) {
			((Separator) piece2d).setIsSepIsometrique(getIsSepIsometrique());
			((Separator) piece2d).setPosRefType(getSepPosRefType());
			// bloquer le position du separateur pour etre dans l'espace3D
			if (getSeprationaxe().equals(SeprationAxe.YAXIS)) {
				if (getSeparationposition() > getParent().getHauteurint()) {
					throw new DesignException(
							"impossible d'ajouter un separateur avec position sepurieur a la Hauteur du parent");
				}
			} else if (getSeprationaxe().equals(SeprationAxe.XAXIS)) {
				if (getSeparationposition() > getParent().getLongeurint()) {
					throw new DesignException(
							"impossible d'ajouter un separateur avec position sepurieur a la Longeur du parent");
				}
			} else {
				if (getSeparationposition() > getParent().getProfondeurint() - getMaterial().getEpaisseur()) {
					throw new DesignException(
							"impossible d'ajouter un separateur avec position sepurieur a la Profondeur du parent");
				}
			}
			//
			String zone = "1";
			if (getSeprationaxe().equals(SeprationAxe.YAXIS)) {
				zone = "Haut";
			} else if (getSeprationaxe().equals(SeprationAxe.XAXIS)) {
				zone = "Droite";
			} else {
				zone = "Exterieur";
			}
			Space3D space = ((Separator) piece2d).getLefttopchild();
			space.setName("Zone " + zone);
			space.setBackmaterial(getBackmaterial());
			space.setBasematerial(getBasematerial());
			space.setParentdesign(piece2d);
			space.setZonetype(Zone3DType.ZONEHAUT);
			space.setPorttype(((Space3D) piece2d.getParentdesign()).getPorttype());
			space.constructDebitage();
			space.evaluate();
			piece2d.addElement(space);
			if (getSeprationaxe().equals(SeprationAxe.YAXIS)) {
				zone = "Bas";
			} else if (getSeprationaxe().equals(SeprationAxe.XAXIS)) {
				zone = "Gauche";
			} else {
				zone = "Interieur";
			}
			space = ((Separator) piece2d).getRightdownchild();
			space.setName("Zone " + zone);
			space.setBackmaterial(getBackmaterial());
			space.setBasematerial(getBasematerial());
			space.setParentdesign(piece2d);
			space.setZonetype(Zone3DType.ZONEBAS);
			space.setPorttype(((Space3D) piece2d.getParentdesign()).getPorttype());
			space.constructDebitage();
			space.evaluate();
			piece2d.addElement(space);
		}

	}

	public void clearlisteners() {
		piece2d.removePropertyChangeListener(pcl);
	}

}
