package api.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;

import java.io.File;
import java.util.HashMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.layout.GridData;
import org.eclipse.wb.swt.ResourceManager;

import api.event.EventBus;
import api.event.EventType;
import api.event.MepEvent;
import api.mep.PIPE_TYPE;
import api.mep.PipeDrawer;
import api.provider.ModelProvider;
import api.utils.RessourceLoader;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class PlumbingMenu extends Composite{

	private Button btnFroid;
	private Button btnEvac;
	private Button btnChaud;
	private Button btnGaz;
	private Button btnHotte;

	public PlumbingMenu(Composite parent, int style) {
		super(parent, style);
		
		
		createControl();
	}

	private void createControl() {
		
		setLayout(new GridLayout(1, false));

		Label label = new Label(this, SWT.NONE);
		label.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, true, 1, 1));
		
		btnFroid = new Button(this, SWT.NONE);
		btnFroid.setText("Eau Froide");
		btnFroid.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				invokePipeDrawer(PIPE_TYPE.COLD);
			}
		});
		String path = ModelProvider.root + File.separator + "icons/icons8-waterblue-pipe-48.png";
		Image coldImg = new Image(getDisplay(), path);
		btnFroid.setImage(coldImg);
		btnFroid.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnFroid.setToolTipText("froid");
		btnFroid.setAlignment(SWT.CENTER);
        
		
		btnChaud = new Button(this, SWT.NONE);
		btnChaud.setText("Eau Chaude");
		btnChaud.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				invokePipeDrawer(PIPE_TYPE.HOT);

			}
		});
		path = ModelProvider.root + File.separator +  "icons/icons8-waterred-pipe-48.png";
		Image hotImg = new Image(getDisplay(), path);
		btnChaud.setImage(hotImg);
		btnChaud.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnChaud.setToolTipText("Chaud");
		
		btnEvac = new Button(this, SWT.NONE);
		btnEvac.setText("Evacuation Eau");
		path = ModelProvider.root + File.separator + "icons/icons8-water-pipe-48.png";
		Image evacImg = new Image(getDisplay(), path);
		btnEvac.setImage(evacImg);
		btnEvac.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnEvac.setToolTipText("Evacuation");
		btnEvac.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				invokePipeDrawer(PIPE_TYPE.EVACUATION);
			}
		});
		
		btnGaz = new Button(this, SWT.NONE);
		btnGaz.setText("Alimentation Gaz");
		path = ModelProvider.root + File.separator + "icons/icons8-wateryel-pipe-48.png";
		Image gazImg = new Image(getDisplay(), path);
		btnGaz.setImage(gazImg);
		btnGaz.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnGaz.setToolTipText("Gaz");
		
		btnHotte = new Button(this, SWT.NONE);
		btnHotte.setText("Evacuation Hotte");
		path = ModelProvider.root + File.separator + "icons/icons8-watergreen-pipe-48.png";
		Image hotteImg = new Image(getDisplay(), path);
		btnHotte.setImage(hotteImg);
		btnHotte.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		btnHotte.setToolTipText("Conduit d'air pour Hotte");

		
		Label lblNewLabel = new Label(this, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, true, 1, 1));
		
	}

	protected void invokePipeDrawer(PIPE_TYPE type) {
		HashMap<String, Object> details = new HashMap<String, Object>();
		details.put("Type", type);
		EventBus.getInstance().notify(new MepEvent(EventType.INVOKE_PIPE_DRAWER, details));
	}

}
