package api.mep;

import org.joml.Matrix4f;
import org.joml.Vector3f;

import api.graphics.geometry.ShapeDrawer;

public class Measure{

	private Vector3f v0;
	private Vector3f v1;
	private float value;
	
	private Matrix4f transform;
	
	public Measure(Vector3f v0, Vector3f v1) {
		this.v0 = v0;
		this.v1 = v1;
		value = v0.distance(v1);
	}
	
	public Vector3f getCenter() {
		return new Vector3f(v0).add(v1).mul(0.5f);
	}
	
	public Vector3f getV0() {
		return v0;
	}
	public void setV0(Vector3f v0) {
		this.v0 = v0;
	}
	public Vector3f getV1() {
		return v1;
	}
	public void setV1(Vector3f v1) {
		this.v1 = v1;
	}	
	public float getValue() {
		return value;
	}
	public void setValue(float value) {
		this.value = value;
	}
	
	
	public void draw(ShapeDrawer drawer) {
		
	}
	
	
	
	
	
}
