package api.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;


public class EventBus {
	
	private HashMap<EventType, List<EventHandler>> eventHandlers = new HashMap<EventType, List<EventHandler>>();
	private static  EventBus instance = new EventBus();
	
	private EventBus() {}
	
	public void register(EventType event, EventHandler handler) {
		List<EventHandler> handlers = eventHandlers.get(event);
		if(handlers == null) {
			handlers = new ArrayList<EventHandler>();
			eventHandlers.put(event, handlers);
		}
		if(!handlers.contains(handler))
			handlers.add(handler);
	}
	
	public void notify(MepEvent event) {
		var handlers = eventHandlers.get(event.getType());
		if(handlers != null) {
			for(var handler: handlers)
				handler.handle(event);
		}
		
	}
	
	
	public static EventBus getInstance() {
		return instance;
	}


	public void clear() {
		this.eventHandlers.clear();
	}
}
