/*
 * Decompiled with CFR 0.152.
 */
package org.frs.resources.downloder;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.frs.resources.downloder.DownloadObserver;
import org.frs.resources.downloder.DownloadRule;
import org.frs.resources.downloder.FileInstaller;
import org.frs.resources.downloder.HttpFileDownloader;
import org.frs.supercad.config.ConfigurationManager;

public class DownloaderUI
extends JFrame {
    private DefaultTableModel tableModel;
    private List<String> urls = new ArrayList<String>();
    private List<String> localFiles = new ArrayList<String>();
    private List<File> localFilesForInstall = new ArrayList<File>();
    private List<Long> fileSizes = new ArrayList<Long>();
    private List<HttpFileDownloader> downloaders = new ArrayList<HttpFileDownloader>();
    private long totalSize = 0L;
    private boolean paused = false;
    private int currentDownloadIndex = 0;
    private List<Long> downloadedBytesPerFile = new ArrayList<Long>();
    private boolean isDownloading = false;
    private int completedDownloads = 0;
    private List<DownloadRule> downloadRules = new ArrayList<DownloadRule>();
    private boolean downloadCompleted = false;
    private boolean allChecksumsValid = true;
    private JLabel label2;
    private JButton btExtraire;
    private JButton btOuvrir;
    private JButton buttonDownloder;
    private JButton buttonPause;
    private JScrollPane scrollPane1;
    private JTextArea textArea;
    private JScrollPane scrollPane2;
    private JTable table;
    private JProgressBar progressBar;

    public DownloaderUI() {
        this.initComponents();
        ImageIcon labelIcon = new ImageIcon(this.getClass().getResource("/icons/supercad.png"));
        this.label2.setIcon(labelIcon);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/icons/icon-supercad32.jpg"));
        this.setIconImage(icon.getImage());
        this.setSize(530, 580);
        this.setLocationRelativeTo(null);
        this.btExtraire.setEnabled(false);
        this.initDownloadList();
        this.initEvents();
        this.buttonPause.addActionListener(this::togglePause);
        this.setDefaultCloseOperation(3);
    }

    private void initDownloadList() {
        this.loadDownloadRules();
        for (DownloadRule rule : this.downloadRules) {
            this.urls.add(rule.getUrl());
        }
        this.fileSizes = new ArrayList<Long>();
        this.downloadedBytesPerFile = new ArrayList<Long>();
        this.tableModel = new DefaultTableModel(new String[]{"Nom du fichier", "Taille", "Chemin/URL", "\u00c9tat", "Progression"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 1) {
                    return Long.class;
                }
                return String.class;
            }
        };
        this.table.setModel(this.tableModel);
        this.table.setDefaultRenderer(Long.class, new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                if (value instanceof Long) {
                    this.setText(DownloaderUI.this.formatFileSize((Long)value));
                } else if (value instanceof String) {
                    try {
                        long size = Long.parseLong((String)value);
                        this.setText(DownloaderUI.this.formatFileSize(size));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.setText(value.toString());
                    }
                } else {
                    this.setText(value == null ? "" : value.toString());
                }
            }
        });
        this.urls.forEach(url -> {
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            String pathOrUrl = url.startsWith("file://") ? url.substring(7) : url;
            Object[] objectArray = new Object[5];
            objectArray[0] = fileName;
            objectArray[2] = pathOrUrl;
            objectArray[3] = "En attente";
            objectArray[4] = "0%";
            this.tableModel.addRow(objectArray);
        });
        this.computeTotalSize();
    }

    private void loadDownloadRules() {
        this.downloadRules.clear();
        try {
            String[] rules;
            String urlsStr = ConfigurationManager.getProperty((String)"URL_RESOURCES");
            if (urlsStr == null || urlsStr.trim().isEmpty()) {
                System.err.println("Aucune r\u00e8gle trouv\u00e9e dans la configuration (cl\u00e9: URL_RESOURCES)");
                return;
            }
            String[] stringArray = rules = urlsStr.split("\\|\\|");
            int n = rules.length;
            int n2 = 0;
            while (n2 < n) {
                String rule = stringArray[n2];
                if (!(rule = rule.trim()).isEmpty()) {
                    try {
                        this.downloadRules.add(new DownloadRule(rule));
                        String[] parts = rule.split(";");
                        if (parts.length >= 1) {
                            String urlZip = parts[0];
                            String urlSha = urlZip + ".sha";
                            String installPath = parts.length >= 2 ? parts[1] : "";
                            String ifExistsAction = parts.length >= 3 ? parts[2] : "IGNORE";
                            String shaRule = urlSha + ";" + installPath + ";" + ifExistsAction;
                            this.downloadRules.add(new DownloadRule(shaRule));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("R\u00e8gle ignor\u00e9e (format invalide): " + rule);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            System.err.println("Erreur lors du chargement des r\u00e8gles de t\u00e9l\u00e9chargement: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void computeTotalSize() {
        new Thread(() -> {
            try {
                int i = 0;
                while (i < this.urls.size()) {
                    int currentIndex = i;
                    String urlStr = this.urls.get(currentIndex);
                    if (urlStr.startsWith("file://")) {
                        File file = new File(urlStr.substring(7));
                        long size = file.length();
                        this.fileSizes.add(size);
                        this.totalSize += size;
                        SwingUtilities.invokeLater(() -> {
                            this.tableModel.setValueAt(size, currentIndex, 1);
                            this.tableModel.setValueAt(urlStr.substring(7), currentIndex, 2);
                        });
                    } else {
                        URL url = new URL(urlStr);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("HEAD");
                        long size = conn.getContentLengthLong();
                        this.fileSizes.add(size);
                        this.totalSize += size;
                        conn.disconnect();
                        SwingUtilities.invokeLater(() -> this.tableModel.setValueAt(size, currentIndex, 1));
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.appendToConsole("Erreur lors du calcul des tailles : " + e.getMessage());
            }
        }).start();
    }

    private void initEvents() {
        this.buttonDownloder.addActionListener(this::startDownloads);
        this.btOuvrir.addActionListener(this::openFile);
    }

    private void startDownloads(ActionEvent e) {
        this.currentDownloadIndex = 0;
        this.downloaders.clear();
        this.downloadedBytesPerFile = new ArrayList<Long>();
        int i = 0;
        while (i < this.urls.size()) {
            if (this.urls.get(i).startsWith("file://")) {
                this.downloadedBytesPerFile.add(this.fileSizes.get(i));
            } else {
                this.downloadedBytesPerFile.add(0L);
            }
            ++i;
        }
        System.out.println("downloadedBytesPerFile" + String.valueOf(this.downloadedBytesPerFile));
        this.buttonDownloder.setEnabled(false);
        new Thread(() -> this.startNextDownload()).start();
    }

    private void startNextDownload() {
        if (this.isDownloading) {
            return;
        }
        this.isDownloading = true;
        while (this.currentDownloadIndex < this.urls.size()) {
            boolean downloadExists;
            String url = this.urls.get(this.currentDownloadIndex);
            if (url.startsWith("file://")) {
                ++this.currentDownloadIndex;
                continue;
            }
            String fileName = url.substring(url.lastIndexOf("/") + 1);
            long expectedSize = this.fileSizes.get(this.currentDownloadIndex);
            if (this.localFileExistsForUrl(fileName)) {
                JOptionPane.showMessageDialog(this, "Le fichier \"" + fileName + "\" existe d\u00e9j\u00e0 en version locale.", "Information", 1);
                this.downloadedBytesPerFile.set(this.currentDownloadIndex, expectedSize);
                this.updateTableStatus(this.currentDownloadIndex, "Ignor\u00e9 (existe local)", "100%");
                ++this.currentDownloadIndex;
                this.updateGlobalProgress();
                continue;
            }
            String resourcesDirPath = System.getProperty("user.dir") + File.separator + "resources";
            File resourcesDir = new File(resourcesDirPath);
            if (!resourcesDir.exists()) {
                try {
                    boolean created = resourcesDir.mkdirs();
                    if (!created) {
                        throw new IOException("Impossible de cr\u00e9er le dossier resources : " + resourcesDirPath);
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            Object outputPath = resourcesDirPath + File.separator + fileName;
            File targetFile = new File((String)outputPath);
            File downloadFile = new File((String)outputPath + ".download");
            boolean targetExists = targetFile.exists() && targetFile.length() == expectedSize;
            boolean bl = downloadExists = downloadFile.exists() && downloadFile.length() == expectedSize;
            if (targetExists || downloadExists) {
                String message = targetExists && downloadExists ? "Deux versions du fichier existent :\n- " + fileName + " (complet)\n- " + fileName + ".download (complet)\nQue faire ?" : (targetExists ? "Le fichier " + fileName + " existe d\u00e9j\u00e0 (complet).\nQue faire ?" : "Le fichier " + fileName + ".download existe d\u00e9j\u00e0 (complet).\nQue faire ?");
                int choice = JOptionPane.showOptionDialog(this, message, "Fichier existant", 1, 3, null, new String[]{"Remplacer", "T\u00e9l\u00e9charger", "Ignorer"}, "Remplacer");
                if (choice == 0) {
                    targetFile.delete();
                    downloadFile.delete();
                } else if (choice == 1) {
                    outputPath = this.renameFile((String)outputPath);
                } else {
                    this.updateTableStatus(this.currentDownloadIndex, "Ignor\u00e9", " ");
                    this.downloadedBytesPerFile.set(this.currentDownloadIndex, expectedSize);
                    ++this.currentDownloadIndex;
                    this.updateGlobalProgress();
                    continue;
                }
            }
            this.startSingleDownload(this.currentDownloadIndex, url, (String)outputPath);
            return;
        }
        this.isDownloading = false;
        if (this.currentDownloadIndex >= this.urls.size()) {
            this.isDownloading = false;
            this.buttonPause.setEnabled(false);
            this.buttonDownloder.setEnabled(true);
            this.btExtraire.setEnabled(true);
            this.btExtraire.addActionListener(e -> {
                JOptionPane optionPane = new JOptionPane("Installation en cours...", 1, -1, null, new Object[0], null);
                final JDialog dialog = optionPane.createDialog(null, "Installation");
                dialog.setDefaultCloseOperation(0);
                SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        FileInstaller.installFiles(DownloaderUI.this.downloadRules, DownloaderUI.this.localFilesForInstall, progress -> {});
                        return null;
                    }

                    @Override
                    protected void done() {
                        dialog.dispose();
                        JOptionPane.showMessageDialog(null, "Installation termin\u00e9e avec succ\u00e8s", "Information", 1);
                        DownloaderUI.this.downloadCompleted = true;
                    }
                };
                worker.execute();
                dialog.setVisible(true);
            });
        }
    }

    private boolean localFileExistsForUrl(String fileName) {
        for (String localFile : this.localFiles) {
            if (!localFile.endsWith(fileName)) continue;
            return true;
        }
        return false;
    }

    private void startSingleDownload(int rowIndex, String url, final String outputPath) {
        HttpFileDownloader downloader = new HttpFileDownloader(url, outputPath);
        this.downloaders.add(downloader);
        final int finalRowIndex = rowIndex;
        downloader.addObserver(new DownloadObserver(){

            @Override
            public void onProgress(int percent) {
                SwingUtilities.invokeLater(() -> {
                    DownloaderUI.this.updateTableProgress(finalRowIndex, percent);
                    DownloaderUI.this.tableModel.setValueAt("En cours", finalRowIndex, 3);
                    long fileSize = DownloaderUI.this.fileSizes.get(finalRowIndex);
                    long downloadedBytes = (long)percent * fileSize / 100L;
                    DownloaderUI.this.downloadedBytesPerFile.set(finalRowIndex, downloadedBytes);
                    System.out.println(String.valueOf(DownloaderUI.this.downloadedBytesPerFile) + "final");
                    DownloaderUI.this.updateGlobalProgress();
                });
            }

            @Override
            public void onStatus(String message) {
                SwingUtilities.invokeLater(() -> DownloaderUI.this.appendToConsole(message));
            }

            @Override
            public void onCompleted() {
                SwingUtilities.invokeLater(() -> {
                    DownloaderUI.this.updateTableStatus(finalRowIndex, "Termin\u00e9", "100%");
                    DownloaderUI.this.tableModel.setValueAt(outputPath, finalRowIndex, 2);
                    DownloaderUI.this.downloadedBytesPerFile.set(finalRowIndex, DownloaderUI.this.fileSizes.get(finalRowIndex));
                    DownloaderUI.this.updateGlobalProgress();
                    ++DownloaderUI.this.currentDownloadIndex;
                    DownloaderUI.this.isDownloading = false;
                    DownloaderUI.this.startNextDownload();
                    ++DownloaderUI.this.completedDownloads;
                    if (DownloaderUI.this.completedDownloads == DownloaderUI.this.downloaders.size()) {
                        DownloaderUI.this.allChecksumsValid = true;
                        int i = 0;
                        while (i < DownloaderUI.this.tableModel.getRowCount()) {
                            String downloadedFilePath = (String)DownloaderUI.this.tableModel.getValueAt(i, 2);
                            String downloadedFileName = new File(downloadedFilePath).getName();
                            System.out.println(downloadedFilePath);
                            System.out.println(downloadedFileName);
                            if (!downloadedFileName.toLowerCase().endsWith(".sha")) {
                                boolean currentFileChecksumValid;
                                block10: {
                                    String shaFilePath = System.getProperty("user.dir") + File.separator + "resources" + File.separator + downloadedFileName + ".sha";
                                    System.out.println(shaFilePath);
                                    File shaFile = new File(shaFilePath);
                                    System.out.println(shaFile);
                                    currentFileChecksumValid = false;
                                    if (shaFile.exists()) {
                                        try {
                                            String calculatedChecksum = DownloaderUI.this.calculateChecksum(downloadedFilePath);
                                            String shaChecksum = DownloaderUI.this.readChecksumFromFile(shaFilePath);
                                            System.out.println("Checksum attendu : " + shaChecksum);
                                            System.out.println("Checksum calcul\u00e9 : " + calculatedChecksum);
                                            if (calculatedChecksum.equalsIgnoreCase(shaChecksum)) {
                                                currentFileChecksumValid = true;
                                                System.out.println("Checksum v\u00e9rifi\u00e9 pour " + downloadedFileName + " : OK");
                                                break block10;
                                            }
                                            System.err.println("Erreur de checksum pour " + downloadedFileName + ". Les checksums ne correspondent pas !");
                                        }
                                        catch (IOException | NoSuchAlgorithmException e) {
                                            e.printStackTrace();
                                        }
                                    } else {
                                        System.err.println("Fichier .sha introuvable pour " + downloadedFileName);
                                    }
                                }
                                if (!currentFileChecksumValid) {
                                    DownloaderUI.this.allChecksumsValid = false;
                                }
                            } else {
                                System.out.println("Fichier " + downloadedFileName + " est un fichier .sha, v\u00e9rification ignor\u00e9e.");
                            }
                            ++i;
                        }
                        Object message = "Tous les fichiers ont \u00e9t\u00e9 t\u00e9l\u00e9charg\u00e9s avec succ\u00e8s !\n";
                        message = DownloaderUI.this.allChecksumsValid ? (String)message + "Toutes les v\u00e9rifications de checksums sont r\u00e9ussies \u2705." : (String)message + "Attention : des erreurs de checksum ont \u00e9t\u00e9 d\u00e9tect\u00e9es \u274c.";
                        JOptionPane.showMessageDialog(null, message);
                    }
                });
            }

            @Override
            public void onErreur(String errorMsg) {
                SwingUtilities.invokeLater(() -> {
                    DownloaderUI.this.appendToConsole("Erreur: " + errorMsg);
                    DownloaderUI.this.updateTableStatus(finalRowIndex, "Erreur", "0%");
                    ++DownloaderUI.this.currentDownloadIndex;
                    DownloaderUI.this.startNextDownload();
                });
            }
        });
        new Thread(downloader).start();
        this.updateTableStatus(rowIndex, "En cours", "0%");
        this.tableModel.setValueAt(url, rowIndex, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String calculateChecksum(String filePath) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest;
        block16: {
            digest = MessageDigest.getInstance("SHA-256");
            Throwable throwable = null;
            Object var4_5 = null;
            try {
                FileInputStream is = new FileInputStream(filePath);
                try {
                    try (DigestInputStream dis = new DigestInputStream(is, digest);){
                        byte[] buffer = new byte[16384];
                        while (dis.read(buffer) != -1) {
                        }
                    }
                    if (is == null) break block16;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        byte[] byArray = hashBytes;
        int n = hashBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hexString.append(String.format("%02x", b));
            ++n2;
        }
        return hexString.toString();
    }

    private String readChecksumFromFile(String shaFilePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(shaFilePath));){
            return reader.readLine().split(" ")[0];
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void openFile(ActionEvent e) {
        FileDialog fileDialog = new FileDialog((Frame)this, "S\u00e9lectionner un fichier ZIP", 0);
        fileDialog.setMultipleMode(true);
        fileDialog.setFile("*.zip");
        fileDialog.setVisible(true);
        File[] selectedFiles = fileDialog.getFiles();
        if (selectedFiles != null && selectedFiles.length > 0) {
            File[] fileArray = selectedFiles;
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File selectedFile = fileArray[n2];
                String filePath = selectedFile.getAbsolutePath();
                String fileName = selectedFile.getName();
                long fileSize = selectedFile.length();
                String fileUrl = "file://" + filePath;
                if (!filePath.toLowerCase().endsWith(".zip")) {
                    JOptionPane.showMessageDialog(this, "Veuillez s\u00e9lectionner un fichier ZIP", "Format incorrect", 0);
                    return;
                }
                boolean hasRule = false;
                for (DownloadRule rule : this.downloadRules) {
                    String ruleFileName = rule.getUrl().substring(rule.getUrl().lastIndexOf(47) + 1);
                    if (!fileName.equals(ruleFileName)) continue;
                    hasRule = true;
                    break;
                }
                if (!hasRule) {
                    JOptionPane.showMessageDialog(this, "Le fichier \"" + fileName + "\" n'a pas de r\u00e8gle correspondante", "Information", 1);
                } else if (this.localFiles.contains(fileUrl) || this.urls.contains(fileUrl)) {
                    JOptionPane.showMessageDialog(this, "Le fichier \"" + fileName + "\" existe d\u00e9j\u00e0 dans la liste.", "Information", 1);
                } else {
                    this.localFiles.add(fileUrl);
                    this.localFilesForInstall.add(selectedFile);
                    this.urls.add(fileUrl);
                    this.fileSizes.add(fileSize);
                    this.downloadedBytesPerFile.add(fileSize);
                    this.totalSize += fileSize;
                    this.tableModel.addRow(new Object[]{fileName, fileSize, filePath, "Fichier local", "100%"});
                    this.appendToConsole("Fichier ajout\u00e9: " + fileName + " (" + this.formatFileSize(fileSize) + ")");
                }
                ++n2;
            }
            this.updateGlobalProgress();
        }
    }

    private String formatFileSize(long size) {
        if (size < 1024L) {
            return size + " octets";
        }
        if (size < 0x100000L) {
            return String.format("%.1f Ko", (double)size / 1024.0);
        }
        if (size < 0x40000000L) {
            return String.format("%.1f Mo", (double)size / 1048576.0);
        }
        return String.format("%.1f Go", (double)size / 1.073741824E9);
    }

    private void updateGlobalProgress() {
        long totalDownloaded = this.downloadedBytesPerFile.stream().mapToLong(Long::longValue).sum();
        System.out.println(String.valueOf(this.downloadedBytesPerFile) + "pro");
        int globalPercent = (int)(totalDownloaded * 100L / this.totalSize);
        this.progressBar.setValue(globalPercent);
    }

    private void updateTableStatus(int rowIndex, String status, String progress) {
        this.tableModel.setValueAt(status, rowIndex, 3);
        this.tableModel.setValueAt(progress, rowIndex, 4);
    }

    private void updateTableProgress(int rowIndex, int percent) {
        this.tableModel.setValueAt(percent + "%", rowIndex, 4);
    }

    private void togglePause(ActionEvent e) {
        this.paused = !this.paused;
        for (HttpFileDownloader downloader : this.downloaders) {
            downloader.togglePause();
        }
        this.buttonPause.setText(this.paused ? "Reprendre" : "Pause");
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            String etat = (String)this.tableModel.getValueAt(i, 3);
            if (this.paused && "En cours".equalsIgnoreCase(etat)) {
                this.tableModel.setValueAt("En pause", i, 3);
            } else if (!this.paused && "En pause".equalsIgnoreCase(etat)) {
                this.tableModel.setValueAt("En cours", i, 3);
            }
            ++i;
        }
    }

    private void appendToConsole(String text) {
        this.textArea.append(text + "\n");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    private String renameFile(String originalPath) {
        File newFile;
        File file = new File(originalPath);
        String name = file.getName();
        String baseName = name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : name;
        String extension = name.contains(".") ? name.substring(name.lastIndexOf(".")) : "";
        int count = 1;
        do {
            newFile = new File(file.getParent(), baseName + "(" + count + ")" + extension);
            ++count;
        } while (newFile.exists());
        return newFile.getAbsolutePath();
    }

    public boolean isDownloadCompleted() {
        return this.downloadCompleted;
    }

    private void initComponents() {
        this.label2 = new JLabel();
        this.btExtraire = new JButton();
        this.btOuvrir = new JButton();
        this.buttonDownloder = new JButton();
        this.buttonPause = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.scrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.progressBar = new JProgressBar();
        this.setTitle("Downloader Resources SuperCad");
        this.setBackground(Color.white);
        this.setFont(new Font("Dialog", 1, 12));
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new TableLayout((double[][])new double[][]{{-1.0, -1.0, -1.0, -1.0}, {121.0, 51.0, 130.0, -1.0, 50.0}}));
        ((TableLayout)contentPane.getLayout()).setHGap(7);
        ((TableLayout)contentPane.getLayout()).setVGap(7);
        this.label2.setHorizontalTextPosition(10);
        contentPane.add((Component)this.label2, new TableLayoutConstraints(0, 0, 3, 0, 2, 2));
        this.btExtraire.setText("Installer");
        this.btExtraire.setBackground(Color.white);
        contentPane.add((Component)this.btExtraire, new TableLayoutConstraints(0, 1, 0, 1, 2, 1));
        this.btOuvrir.setText("Ouvrir");
        this.btOuvrir.setBackground(Color.white);
        contentPane.add((Component)this.btOuvrir, new TableLayoutConstraints(1, 1, 1, 1, 2, 1));
        this.buttonDownloder.setText("T\u00e9l\u00e9charger");
        this.buttonDownloder.setBackground(Color.white);
        contentPane.add((Component)this.buttonDownloder, new TableLayoutConstraints(2, 1, 2, 1, 2, 1));
        this.buttonPause.setText("Pause");
        this.buttonPause.setBackground(Color.white);
        contentPane.add((Component)this.buttonPause, new TableLayoutConstraints(3, 1, 3, 1, 2, 1));
        this.textArea.setEditable(false);
        this.scrollPane1.setViewportView(this.textArea);
        contentPane.add((Component)this.scrollPane1, new TableLayoutConstraints(0, 2, 3, 2, 2, 2));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Nom du fichier", "\u00c9tat", "Progression"}){
            boolean[] columnEditable;
            {
                this.columnEditable = new boolean[3];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        this.scrollPane2.setViewportView(this.table);
        contentPane.add((Component)this.scrollPane2, new TableLayoutConstraints(0, 3, 3, 3, 2, 2));
        this.progressBar.setStringPainted(true);
        contentPane.add((Component)this.progressBar, new TableLayoutConstraints(0, 4, 3, 4, 2, 1));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public void open() {
        SwingUtilities.invokeLater(() -> this.setVisible(true));
    }
}

