/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class ChmodAction
extends ProvisioningAction {
    private static final String ACTION_CHMOD = "chmod";
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public IStatus execute(Map<String, Object> parameters) {
        String[] stringArray;
        if (WINDOWS) {
            return Status.OK_STATUS;
        }
        Object absoluteFiles = parameters.get("absoluteFiles");
        String targetDir = (String)parameters.get("targetDir");
        String targetFile = (String)parameters.get("targetFile");
        if (targetFile != null && absoluteFiles != null) {
            return Util.createError(Messages.chmod_param_cant_be_set_together);
        }
        if (targetDir != null && targetFile == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"targetFile", (Object)ACTION_CHMOD));
        }
        if (targetDir == null && targetFile != null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"targetDir", (Object)ACTION_CHMOD));
        }
        String permissions = (String)parameters.get("permissions");
        if (permissions == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"permissions", (Object)ACTION_CHMOD));
        }
        String optionsString = (String)parameters.get("options");
        if (absoluteFiles != null) {
            if (absoluteFiles instanceof String) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)absoluteFiles;
            } else {
                stringArray = (String[])absoluteFiles;
            }
        } else {
            stringArray = this.makeFilesAbsolute(targetDir, targetFile);
        }
        String[] filesToProcess = stringArray;
        MultiStatus rStatus = new MultiStatus("org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.action_0_status, (Object)ACTION_CHMOD), null);
        String[] stringArray3 = filesToProcess;
        int n = filesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            block15: {
                String fileToChmod;
                block14: {
                    fileToChmod = stringArray3[n2];
                    try {
                        File probe = new File(fileToChmod).getCanonicalFile();
                        if (!probe.exists()) {
                            rStatus.add(Util.createError(NLS.bind((String)Messages.action_0_failed_file_1_doesNotExist, (Object)ACTION_CHMOD, (Object)probe.toString())));
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        rStatus.add(Util.createError(NLS.bind((String)Messages.action_0_failed_on_file_1_reason_2, (Object[])new String[]{ACTION_CHMOD, fileToChmod, e.getMessage()}), e));
                    }
                    break block15;
                }
                IStatus chmodStatus = this.doChmod(fileToChmod, permissions, optionsString);
                if (!chmodStatus.isOK()) {
                    rStatus.merge(chmodStatus);
                }
            }
            ++n2;
        }
        return rStatus;
    }

    private String[] makeFilesAbsolute(String targetDir, String targetFile) {
        return new String[]{new String(targetDir + "/" + targetFile)};
    }

    private IStatus doChmod(String fileToChmod, String permissions, String optionsString) {
        String[] options = null;
        if (optionsString != null) {
            ArrayList<String> collect = new ArrayList<String>();
            String r = optionsString.trim();
            while (r.length() > 0) {
                int spaceIdx = r.indexOf(32);
                if (spaceIdx < 0) {
                    collect.add(r);
                    r = "";
                    continue;
                }
                collect.add(r.substring(0, spaceIdx));
                r = r.substring(spaceIdx + 1);
                r = r.trim();
            }
            if (collect.size() > 0) {
                options = new String[collect.size()];
                collect.toArray(options);
            }
        }
        return this.chmod(fileToChmod, permissions, options);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Status.OK_STATUS;
    }

    public IStatus chmod(String fileToChmod, String perms, String[] options) {
        if (WINDOWS) {
            return Status.OK_STATUS;
        }
        Runtime r = Runtime.getRuntime();
        try {
            String[] args = new String[3 + (options == null ? 0 : options.length)];
            int i = 0;
            args[i++] = ACTION_CHMOD;
            if (options != null) {
                String[] stringArray = options;
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    String option = stringArray[n2];
                    args[i++] = option;
                    ++n2;
                }
            }
            args[i++] = perms;
            args[i] = fileToChmod;
            Process process = r.exec(args);
            this.readOffStream(process.getErrorStream());
            this.readOffStream(process.getInputStream());
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException e) {
            return Util.createError(NLS.bind((String)Messages.action_0_failed_on_file_1_reason_2, (Object[])new String[]{ACTION_CHMOD, fileToChmod, e.getMessage()}), e);
        }
        return Status.OK_STATUS;
    }

    private void readOffStream(InputStream inputStream) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                while (reader.readLine() != null) {
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
    }
}

