package dressing.ui.model.project3d;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;

import dressing.model.ModelPackageProject3D;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.BeanProperties;

public class ModelPackageProject3DComposite extends Composite {


	
	private DataBindingContext m_bindingContext;
	private ModelPackageProject3D project3D = new ModelPackageProject3D();
	private Text nameText;
	private Label lblFci;
	private Text textfullpath;
	private Text textdir;

	public ModelPackageProject3DComposite(Composite parent, int style, ModelPackageProject3D newProject3D) {
		this(parent, style);
		setProject3D(newProject3D);
	}

	public ModelPackageProject3DComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(3, false));

		new Label(this, SWT.NONE).setText("Nom de projet");

		nameText = new Text(this, SWT.BORDER | SWT.SINGLE);
		nameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		new Label(this, SWT.NONE);

		Label label = new Label(this, SWT.NONE);
		label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		label.setText("R\u00E9pertoire");
		
		textdir = new Text(this, SWT.BORDER);
		textdir.setEditable(false);
		textdir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		
		Button btnNewButton = new Button(this, SWT.NONE);
		btnNewButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				m_bindingContext.updateTargets();
				
				DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
				dialog.setMessage("Selectionner un r�pertoire pour vos projets");
				String dir = dialog.open();
				project3D.setDirectory(dir);				
			}
		});
		btnNewButton.setText("Explorer");
		
		lblFci = new Label(this, SWT.NONE);
		lblFci.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, true, 1, 1));
		lblFci.setText("Fichier");
		
		textfullpath = new Text(this, SWT.BORDER);
		textfullpath.setEditable(false);
		textfullpath.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		if (project3D != null) {
			m_bindingContext = initDataBindings();
		}

	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}

	public ModelPackageProject3D getProject3D() {
		return project3D;
	}

	public void setProject3D(ModelPackageProject3D newProject3D) {
		setProject3D(newProject3D, true);
	}

	public void setProject3D(ModelPackageProject3D newProject3D, boolean update) {
		project3D = newProject3D;
		if (update) {
			if (m_bindingContext != null) {
				m_bindingContext.dispose();
				m_bindingContext = null;
			}
			if (project3D != null) {
				m_bindingContext = initDataBindings();
			}
		}
	}
	protected DataBindingContext initDataBindings() {
		DataBindingContext bindingContext = new DataBindingContext();
		//
		IObservableValue nameObserveWidget = WidgetProperties.text(SWT.Modify).observe(nameText);
		IObservableValue nameObserveValue = BeanProperties.value("name").observe(project3D);
		bindingContext.bindValue(nameObserveWidget, nameObserveValue, null, null);
		//
		IObservableValue observeTextTextfullpathObserveWidget = WidgetProperties.text(SWT.Modify).observe(textfullpath);
		IObservableValue fullpathProject3DObserveValue = BeanProperties.value("fullpath").observe(project3D);
		bindingContext.bindValue(observeTextTextfullpathObserveWidget, fullpathProject3DObserveValue, null, null);
		//
		IObservableValue observeTextTextdirObserveWidget = WidgetProperties.text(SWT.Modify).observe(textdir);
		IObservableValue directoryProject3DObserveValue = BeanProperties.value("directory").observe(project3D);
		bindingContext.bindValue(observeTextTextdirObserveWidget, directoryProject3DObserveValue, null, null);
		//
		//Charger les prefernces ici
		if (project3D != null) {
			Preferences preferences = InstanceScope.INSTANCE.getNode("com.dressing");
			Preferences projectpref = preferences.node("project3d");
			String dirpath = projectpref.get("directory", "C:");
			project3D.setDirectory(dirpath);
		}
		return bindingContext;
	}
}
