package dressing.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;



public class ModelPackageProjectParent{

	List<ModelPackageProject3D> projects = new ArrayList<ModelPackageProject3D>();

	public ModelPackageProjectParent() {
		// TODO Auto-generated constructor stub
		initpropagtionlistners();
	}
	
	public List<ModelPackageProject3D> getProjects() {
		return projects;
	}

	private void initpropagtionlistners() {
		for (ModelPackageProject3D prj : projects) {
			if (prj != null) {
				prj.addPropertyChangeListener(new PropertyChangeListener() {
					@Override
					public void propertyChange(PropertyChangeEvent evt) {
						if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
							firePropertyChange("project.modify", null, evt.getNewValue());
						}		
					}
				});
			}
		}

	}

	public void addProject(ModelPackageProject3D projet,boolean fromfile) {
	
		if (projet != null) {
			projects.add(projet);
			projet.addPropertyChangeListener(new PropertyChangeListener() {
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					if(!evt.getPropertyName().equalsIgnoreCase("selected")) {
						firePropertyChange("project.modify", null, evt.getNewValue());
					}					
				}
			});
			if(fromfile)
			{
				firePropertyChange("project.read", null, projet);
			}
			else
			{
				firePropertyChange("project.modify", null, projet);
			}
			

		}
	}
	public void deleteProject(ModelPackageProject3D projet) {
		
		if (projet != null) {
			projects.remove(projet);
			firePropertyChange("project.close", null, projet);
		}
	}
	protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(
			this);

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}

	public void addPropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(propertyName,
				listener);
	}

	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void removePropertyChangeListener(String propertyName,
			PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(propertyName,
				listener);
	}

	protected void firePropertyChange(String propertyName, Object oldValue,
			Object newValue) {
		propertyChangeSupport.firePropertyChange(propertyName, oldValue,
				newValue);
	}
}
