package tech.frsdev.solids;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

import com.badlogic.gdx.math.Vector3;

import dressing.model.Caisson;
import dressing.model.Piece2D;
import dressing.model.Separator;
import dressing.model.types.PieceType;

public interface Solide3D 
{
	double getXSize();
	double getYSize();
	double getZSize();
	double getXPosition();
	double getYPosition();
	double getZPosition();
	List<Solide3D> getChildren();
	Solide3D getParent();
	BufferedImage getImage();
	boolean isdrawable();
	Boolean isSelected();
	default Boolean isHighlighted() {
		return isSelected();
		
	}
	default double getVolume() {
		return getXSize()*getYSize()* getZSize();
		
	}

	default  double gettransparency()
	{
		return  1;
	}
	default boolean  hasMember(Solide3D sld) {
		if(sld==null)
			return false;
		if(this.equals(sld))
			return true;
		for(Solide3D child : getChildren())
		{
			if(child.hasMember(sld))
			{
				return true;
			}
		}
		return false;
	}
	default boolean  isDirectlyDelatable()
	{
		if(this instanceof Piece2D)
		{
			Piece2D piece = (Piece2D) this;
			PieceType type = piece.getPiecetype();
			boolean deltable = false;
			switch (type)
			{
			  case  ETAGERE_FIXE:
			  case  ETAGERE_MOBILE:
			  case  DOS_EXTERIRUR:
			  case  DOS_INTERIEUR:
				  deltable=true;
				  break;
			default:
				deltable = false;
				break;
			}
			
			if( this instanceof Separator)
			{
				deltable = true;
			}
			
			return deltable;
		}
		else if(this instanceof Caisson)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	
	public default Vector3 getSize() {
		return new Vector3((float) getXSize(), (float) getYSize(), (float) getZSize());
	}
	
	public default Vector3 getPosition() {
		return new Vector3((float) getXPosition(), (float) getYPosition(), (float) getZPosition());
	}
	
	default public <T extends Solide3D> void  getChildrenByType( Class<T> clazz, ArrayList<T> out) {
		for(Solide3D solid: getChildren()) {
			if(clazz.isInstance(solid))
				out.add((T) solid);
			solid.getChildrenByType(clazz, out);
		}
	}
}
