package dressing.ui.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.badlogic.gdx.math.Vector3;

import dressing.controller.tools.ToolController;
import dressing.model.ModelProvider;
import dressing.model.ProjectManager;
import dressing.ui.engine3d.SceneTexture.CATEGORY;
import dressing.ui.engine3d.sceneconfig.FloorSettingComposite;
import dressing.ui.engine3d.sceneconfig.WallConfigComposite;
import dressing.ui.shapedrawer.FinalPage;
import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.WorldObject;
import gdxapp.scenes.SceneManager;
import gdxapp.scenes.ScenePreferences;
import geometry.CompoundObject;
import geometry.CompoundShape;
import geometry.ShapeDrawer;

public class FloorConfigWizardFormPage extends WizardPage implements PropertyChangeListener , FinalPage {
	
	

	private FloorSettingFormComposite composite;
	
	GeometryObject worldobject;
	
	protected FloorConfigWizardFormPage(String pageName) {
		super(pageName);
	}
	
	public FloorSettingFormComposite getComposite() {
		return composite;
	}

	public void setComposite(FloorSettingFormComposite composite) {
		this.composite = composite;
	}

	protected FloorConfigWizardFormPage() {
		super("");
		setTitle("Création du socle");
		this.worldobject = new GeometryObject();
		CompoundObject compoundObject =  ShapeDrawer.getInstance().getTemporaryObject().cpy();
		compoundObject.getBorder().setMaterial(ProjectManager.getManager().getCurrentScene().getPreferences().getFloorMtl());
		this.worldobject.setGeometry(compoundObject);
		this.worldobject.setRealWorldDimension(compoundObject.getRealWorldDimension(0.01f));
		this.worldobject.setRealWorldPosition(new Vector3(0, 0.005f,0));
		this.worldobject.addPropertyChangeListener(this);
		
	}

	@Override
	public void createControl(Composite parent) {
		composite = new FloorSettingFormComposite(parent, SWT.EMBEDDED,(GeometryObject) worldobject,ModelProvider.getMaterialsByCategory(CATEGORY.FLOOR));
		setControl(composite);
		getWizard().getContainer().updateButtons();

	}
	public void clearlistners() {
		worldobject.removePropertyChangeListener(this);
	}

	@Override
	public boolean isPageComplete() {
		return worldobject.getGeometry().getBorder().getMaterial() != null ;
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if(isCurrentPage())
		{
			if (FloorConfigWizardFormPage.this != null) {
				setPageComplete(isPageComplete());
				if (getWizard().getContainer() != null)
					getContainer().updateButtons();
			}
		}
	}

	@Override
	public void onHide() {
		clearlistners();	
		ProjectManager.getManager().getCurrentScene().addActor(worldobject, true);
		ShapeDrawer.getInstance().finish();
	}


	

}
