package dressing.ui.porte;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.controller.DressingCreator;
import dressing.controller.Piece2DCreator;
import dressing.controller.PorteCreator;
import dressing.model.DesignException;
import dressing.model.Dressing;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;

public class PorteWelcomePage extends WizardPage{

	PorteCreator portefactory ;
	PropertyChangeListener pcl;
	boolean errorfound=false;
	protected PorteWelcomePage(String pageName,PorteCreator piece) {
		super(pageName);
		this.portefactory = piece;
		setTitle("Ajouter une porte");
		setDescription("Veuillez renseigner le type de porte");		
		// TODO Auto-generated constructor stub
	}


	@Override
	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		PorteCompositeWizard compo1 = new PorteCompositeWizard(parent, SWT.NONE,portefactory);
		setControl(compo1);
		pcl = new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				// TODO Auto-generated method stub
				if(!evt.getPropertyName().startsWith("project.")) //seulemnt les proprietes de javabean
				{
					try {										
						portefactory.create();
						setErrorMessage(null);	
						errorfound = false;
						setMessage("Vous pouvez ajouter votre porte", WizardPage.INFORMATION);
					} catch (DesignException  | GeometricEngineException e) {
						setErrorMessage(e.getMessage());	
						errorfound = true;
					}
					getWizard().getContainer().updateButtons();
				}

			}
		};
		portefactory.addPropertyChangeListener(pcl);
	}
@Override
public boolean isPageComplete() {
	// TODO Auto-generated method stub
	boolean b = !errorfound;
	return b;
}
public void clearlistners() {
	portefactory.removePropertyChangeListener(pcl);
}
}