package dressing.ui.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.EPartService.PartState;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import dressing.controller.EtagereCreator;
import dressing.handlers.AddEtagereWizardHandler;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Dressing;
import dressing.model.Etagere;
import dressing.model.Materiaux;
import dressing.model.ModelProvider;
import dressing.model.Piece2D;
import dressing.model.Piece2DCoupe;
import dressing.model.Project3D;
import dressing.model.ProjectParent;
import dressing.model.Separator;
import dressing.model.Space3D;
import dressing.model.Space3DFree;
import dressing.model.Tirroir;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.EtagereType;
import dressing.model.types.PieceType;
import dressing.model.types.Zone3DType;
import dressing.model.usinage.Usinage;
import dressing.model.types.EtagereReferenceType;
import dressing.ui.ProjectTreeContentProvider;
import dressing.ui.cam.parts.GcodeEditorPart;
import dressing.ui.etagere.EtagereWizard;
import dressing.ui.modelprovders.DimHLabelProvider;
import dressing.ui.modelprovders.DimLLabelProvider;
import dressing.ui.modelprovders.MaterialLabelProvider;
import dressing.ui.modelprovders.NameLabelProvider;
import dressing.ui.palette.PaletteItem;
import dressing.ui.palette.PaletteItemTransferType;
import dressing.ui.separator.SeparatorWizard;
import dressing.ui.swt.samples.DataTransfer.MyTransfer;
import dressing.ui.swt.samples.DataTransfer.MyType;
import dressing.ui.util.ListenerSelection;
import tech.frsdev.solids.Solide3D;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider.IStyledLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.StyledString.Styler;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;

public class ProjectTreePart {

	@Inject 
	IEclipseContext eclipsecontext;
	@Inject
	private ESelectionService selectionService;

	@Inject 
	EPartService partService;
	
	@Inject
	private EHandlerService handlerService;
	@Inject
	private EModelService modelService;
	@Inject
	private ECommandService commandService;
	@Inject
	private MDirtyable dirty;
	public static  Display display;
	ListenerSelection listenerSelection;
	public ProjectTreePart() {
	}

	/**
	 * Create contents of the view part.
	 */
	@PostConstruct
	public void createControls(Composite parent) {
		
		display = parent.getDisplay();
		final TreeViewer treeViewer = new TreeViewer(parent, SWT.BORDER|SWT.MULTI);
		final Tree tree = treeViewer.getTree();		
		
		ProjectParent parentproject = ModelProvider.RootInstance();
		treeViewer.setContentProvider(new ProjectTreeContentProvider());
		treeViewer.setInput(parentproject);
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
		    public void selectionChanged(SelectionChangedEvent event) {
		      IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		      // set the selection to the service
		      Object selectionobj= selection.size() == 1 ? selection.getFirstElement() : selection.toList();
		      selectionService.setSelection(selectionobj);
		    
		    }
		  });
		treeViewer.addOpenListener(new IOpenListener() {
			
			@Override
			public void open(OpenEvent event) {

//				DesignObject3D object=	(DesignObject3D) event.getSelection();
				IStructuredSelection selection=(IStructuredSelection) event.getSelection();
				 Object selectionobj= selection.size() == 1 ? selection.getFirstElement() : selection.toList();
				 if(selectionobj instanceof Piece2D) {
					Collection<MPart> parts = partService.getParts();
					for(MPart par:parts) {
						if(par.getElementId().equals("dressing.ui.cam.parts.GcodeEditorPart")) {
							GcodeEditorPart p=(GcodeEditorPart)par.getObject();
							if(p!=null && p.getPiece().equals((Piece2D)selectionobj)) {
								partService.activate(par);
								partService.bringToTop(par);
								return;
							}
						}
					}
					 MPart part = partService.createPart("dressing.ui.cam.parts.GcodeEditorPart");

					// Set the input

					part.getTransientData().put("piece", (Piece2D)selectionobj);

					boolean isontop=part.isOnTop();
					// Add to editor part stack

					MPartStack editorStack = (MPartStack) partService.findPart("dressing.partstack.14");

//					editorStack.getChildren().add(part);
//					modelService.find(id, searchRoot)
					// Show
					part.setLabel( ((Piece2D)selectionobj).getName());
					partService.showPart(part, PartState.ACTIVATE);
				 }
				System.err.println(selectionobj +"opened");
			}
		});
		 listenerSelection=new ListenerSelection(selectionService);
		parentproject.addPropertyChangeListener(new PropertyChangeListener() {
			
			@Override
			public void propertyChange(PropertyChangeEvent evt) {

			      parent.getDisplay().asyncExec(new Runnable() {

				         @Override
				         public void run() {
								Object x = evt.getNewValue();
								treeViewer.refresh(true);
								treeViewer.getAutoExpandLevel();
//								treeViewer.expandToLevel(evt.getNewValue(), TreeViewer.ALL_LEVELS);
								if(!evt.getPropertyName().equals("project.read") && !evt.getPropertyName().equals("project.close")
										&&!evt.getPropertyName().contentEquals("selected"))
								{
									dirty.setDirty(true);
								}								

				      }});
				}
		});		
		
		
		TreeViewerColumn viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
		TreeColumn column = viewerColumn.getColumn();
		column.setText("Nom");
		column.setWidth(200);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new NameLabelProvider(ProjectTreePart.display)));


		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Materieaux");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new MaterialLabelProvider()));
		
		
		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Longeur");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimLLabelProvider()));
		
		viewerColumn = new TreeViewerColumn(treeViewer, SWT.NONE);
	    column = viewerColumn.getColumn();
		column.setText("Largeur");
		column.setWidth(100);
		viewerColumn.setLabelProvider(new DelegatingStyledCellLabelProvider(new DimHLabelProvider()));
		
	
		
		
	
		Listener listener = new Listener() {

		   @Override
		   public void handleEvent(Event event) {
		      TreeItem treeItem = (TreeItem) event.item;
		      
		      final TreeColumn[] treeColumns = treeItem.getParent().getColumns();
		      parent.getDisplay().asyncExec(new Runnable() {
 
		         @Override
		         public void run() {
		            for (TreeColumn treeColumn : treeColumns)
		                 treeColumn.pack();
		         }
		        
		      });
		   }
		};
		tree.addListener(SWT.Expand, listener);
		tree.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		
		
		MenuManager menuMgr = new MenuManager();

        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        menuMgr.addMenuListener(new IMenuListener() {
            @Override
            public void menuAboutToShow(IMenuManager manager) {
                // IWorkbench wb = PlatformUI.getWorkbench();
                // IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (treeViewer.getSelection().isEmpty()) {
                    return;
                }

                if (treeViewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection) treeViewer.getSelection();
                    Object object = selection.getFirstElement();
                  //Imed bug 0001710 ajouter une action pour exporter un projet vers dxf
                    Action exportdxfAction=new Action ("Export DXF") {
                    	public void run() {
                    		ParameterizedCommand cmd = commandService.createCommand("dressing.command.exportdxf", null);                        	
                    		handlerService.executeHandler(cmd);
                    	};
					};
					 Action exportgcodeActionAction=new Action ("Export Gcode") {
	                    	public void run() {
	                    		ParameterizedCommand cmd = commandService.createCommand("dressing.command.saveas", null);                        	
	                    		handlerService.executeHandler(cmd);
	                    	};
						};
					Action generateGcodeAction=new Action ("Générer Gcode") {
		                  public void run() {
		                	  ParameterizedCommand cmd = commandService.createCommand("dressing.command.generategcode", null);                        	
		                	  handlerService.executeHandler(cmd);
		                  };
					};
					if(object instanceof CaissonCuisine || object instanceof Caisson ) {
						 manager.add(new Action("Exporter caisson vers la bibliothèque") {
	                        	public void run() {
	                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.exportmodel", null);                        	
	                        		handlerService.executeHandler(cmd);
	                        	};
	    					});
					}
                    if (object instanceof DesignObject3D)
                    {
                        manager.add(new Action("Copier les pieces vers excell -Sans Grouper") {
                        	public void run() {
                        		HashMap<String, Object> param = new HashMap<>();
                        		param.put("dressing.commandparameter.copyexcell.groupby",Piece2DCoupe.GROUPBY_NONE);
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                        
                        manager.add(new Action("Copier les pieces vers excell -Grouper Tous") {
                        	public void run() {
                        		HashMap<String, Object> param = new HashMap<>();
                        		param.put("dressing.commandparameter.copyexcell.groupby",Piece2DCoupe.GROUPBY_ALL);
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                        manager.add(new Action("Copier les pieces vers excell -Grouper par Parent") {
                        	public void run() {
                        		HashMap<String, Object> param = new HashMap<>();
                        		param.put("dressing.commandparameter.copyexcell.groupby",Piece2DCoupe.GROUPBY_PARENT);
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                        manager.add(new Action("Copier les pieces vers excell -Grouper par Projet") {
                        	public void run() {
                        		HashMap<String, Object> param = new HashMap<>();
                        		param.put("dressing.commandparameter.copyexcell.groupby",Piece2DCoupe.GROUPBY_PROJECT);
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                        manager.add(new Action("Copier les pieces vers excell -Grouper par Dressing") {
                        	public void run() {
                        		HashMap<String, Object> param = new HashMap<>();
                        		param.put("dressing.commandparameter.copyexcell.groupby",Piece2DCoupe.GROUPBY_DRESSING);
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                        manager.add(new Action("Copier les pieces vers excell -Grouper par Caisson") {
                        	public void run() {
                        		HashMap<String, Object> param = new HashMap<>();
                        		param.put("dressing.commandparameter.copyexcell.groupby",Piece2DCoupe.GROUPBY_CAISSON);
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.copy.pieces.nomenclature.toexcell", param);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                       
                        manager.add(new Action("Réinitialiser les Parameters") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.reinitialiserParameters", null);                        	
                        		handlerService.executeHandler(cmd);
                        	};
    					});
                        if(!(object instanceof Usinage) && !(object instanceof Space3DFree)){
                        	manager.add(new Action("Créer les trou d'usinage") {
                        		public void run() {
                            		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.usinage.trou", null);                        	
                            		handlerService.executeHandler(cmd);
                            	};
        					});
                        }
                        	
                      //Imed bug 0001710 ajouter une action pour exporter un projet vers dxf
                        if(!(object instanceof Usinage)) {
                            manager.add(exportdxfAction);
                            manager.add(exportgcodeActionAction);
                            manager.add(generateGcodeAction);
                        }
                      }
                    
                    if (object instanceof Project3D) {
                    	
                        manager.add(new Action("Ajouter un dressing") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.create.wizard", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                        manager.add(new Action("Ajouter une cuisine") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.cuisine", null);
                        		handlerService.executeHandler(cmd);
                        	};
						});
                        manager.add(new Action("Fermer") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.close.project", null);
                        		handlerService.executeHandler(cmd);
                        	};
						});                      
                        manager.add(new Action("Imprimer le rapport technique") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.printtechreport", null);
                        		handlerService.executeHandler(cmd);
                        	};
						});
                        
                    } 
                    if (object instanceof Dressing && !(object instanceof Cuisine)) 
                    {
                        manager.add(new Action("Ajouter un caisson") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.addcuissonwizard", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                    }
                    if (object instanceof Cuisine) 
                    {
                        manager.add(new Action("Ajouter un caisson cuisine") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.caisson.cuisine.dialog", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});                       
                        //Imed bug 0001875 ajouter le creator de la bloc tiroir
                        manager.add(new Action("Ajouter un Bloc Tiroir") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.AddBlocTiroir", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                        manager.add(new Action("importer un model") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.import.model.fromlibrary", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                    }
                    if (object instanceof Space3D && !(object instanceof Dressing)&& !(object instanceof Tirroir)  && !(object instanceof Space3DFree))
                    {
                    	 // gestion add.des.etageres.wizard command
                        manager.add(new Action("Ajouter des etageres") {
                        	public void run() {
               
                        		Object o = selectionService.getSelection("dressing.part.tree");
                        		//Voire l element de l arbre selectionne
                        		if(o instanceof Space3D&& !(o instanceof Dressing))
                        		{
		
                        			ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.etageres.wizard", null);
                            		handlerService.executeHandler(cmd);
                        		}
                        	}
                        		
                        	});
                        manager.add(new Action("Ajouter un seprateur") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.separtor", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                        manager.add(new Action("Ajouter une porte") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.porte.wizard", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                        manager.add(new Action("Ajouter un dos") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.dos.wizard", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                        manager.add(new Action("Ajouter des tiroirs") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.tiroires.wizard", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                        manager.add(new Action("Ajouter des charniere") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.charniere", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                    }
                    if (object instanceof DesignObject3D && !(object instanceof Project3D)) {
                    	manager.add(new Action("Supprimer") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.delete", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                    	manager.add(new Action("Costomiser les Parameters") {
                        	public void run() {
                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.customiseParameters", null);
                        		handlerService.executeHandler(cmd);
                        		};
						});
                    }
                }
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        treeViewer.getControl().setMenu(menu);
	
     
        final TextTransfer textTransfer = TextTransfer.getInstance();
       	final FileTransfer fileTransfer = FileTransfer.getInstance();
       	final PaletteItemTransferType paletteitemtransfert = PaletteItemTransferType.getInstance();
       	
//       	Transfer[]		types = new Transfer[] {fileTransfer, textTransfer,PaletteItemTransferType.getInstance()};
//        int operations = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_DEFAULT;
//       	DropTarget target = new DropTarget(treeViewer.getControl(), operations);
//       	target.setTransfer(types);
       	
//       	target.addDropListener(new DropTargetListener() {
//			
//			@Override
//			public void dropAccept(DropTargetEvent event) {
//				// TODO Auto-generated method stub
//				System.out.println("Drop Accept :   Check profond si on veut l accepter");
//			    if (textTransfer.isSupportedType(event.currentDataType)) {
//	 	            // NOTE: on unsupported platforms this will return null
//	 	            Object o = textTransfer.nativeToJava(event.currentDataType);
//	  	            String t = (String)o;
//				    if(t != null &&t.length()>5)
//				    {
//				    	event.detail =event.operations;
//				    }
//				    else
//				    {
//				    	event.detail = DND.DROP_NONE;
//				    }
//	    }
//			}
//			
//			@Override
//			public void drop(DropTargetEvent event) {
//				// TODO Auto-generated method stub
//				System.out.println("Drop ");
//				
//				  event.feedback = DND.FEEDBACK_SELECT | DND.FEEDBACK_SCROLL;
//				    if (textTransfer.isSupportedType(event.currentDataType)) {
//				 	            // NOTE: on unsupported platforms this will return null
//				 	            Object o = textTransfer.nativeToJava(event.currentDataType);
//				  	            String t = (String)o;
//							    if(t != null &&event.item!=null && event.item.getData() instanceof Space3D)
//							    {
//							    	((Space3D)(event.item.getData())).setName(t);
//							    	
//	                        		ParameterizedCommand cmd = commandService.createCommand("dressing.command.add.separtor", null);
//	                        		handlerService.executeHandler(cmd);
//							    }	          
//				    }
//
//				    
//			}
//			
//			@Override
//			public void dragOver(DropTargetEvent event) {
//				
//				// TODO Auto-generated method stub
//				System.out.println("Drop over : Check rapide en temps de reel si on veut accepter");
//				event.feedback = DND.FEEDBACK_SELECT | DND.FEEDBACK_SCROLL;
//				// NOTE: on unsupported platforms this will return null
//				if (event.data != null) {
//					PaletteItem[] items = (PaletteItem[]) event.data;
//
//					int debug = 0;
//					debug++;
//					if (event.item != null && event.item.getData() instanceof Space3D) {
//						event.detail = event.operations;
//					}
//				}
//
//
//			}
//			
//			@Override
//			public void dragOperationChanged(DropTargetEvent event) {
//				// TODO Auto-generated method stub
//				System.out.println("Drop operation changed");
//			}
//			
//			@Override
//			public void dragLeave(DropTargetEvent event) {
//				// TODO Auto-generated method stub
//				System.out.println("Drop leave");
//			}
//			
//			@Override
//			public void dragEnter(DropTargetEvent event) {
//				// TODO Auto-generated method stub
//				System.out.println("Drop enter");
//			}
//		});
	
       	
       	DropTarget target = new DropTarget(treeViewer.getControl(), DND.DROP_COPY | DND.DROP_DEFAULT);
        target.setTransfer(new Transfer[] { PaletteItemTransferType.getInstance() });
        target.addDropListener(new DropTargetAdapter() {
          public void dragEnter(DropTargetEvent event) {
            if (event.detail == DND.DROP_DEFAULT) {
              event.detail = DND.DROP_COPY;
            }
          }

          public void dragOperationChanged(DropTargetEvent event) {
            if (event.detail == DND.DROP_DEFAULT) {
              event.detail = DND.DROP_COPY;
            }
          }

          public void drop(DropTargetEvent event) {
            if (event.data != null) {
              PaletteItem[] myTypes = (PaletteItem[]) event.data;
              if (myTypes != null) {
                String cmdstr = "";
                for (int i = 0; i < myTypes.length; i++) {
                  cmdstr += myTypes[i].getCmd();
                }                
				if (event.item != null && event.item.getData() instanceof Space3D)
				{
//					((Space3D)(event.item.getData())).setName(cmdstr);		
					selectionService.setSelection(event.item.getData());
            		ParameterizedCommand cmd = commandService.createCommand(cmdstr, null);
            		handlerService.executeHandler(cmd);
				}
            
              }
            }
          }

        });
	}

	@PreDestroy
	public void dispose() {
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}
	@Persist
	public void save() throws DesignException {
		dirty.setDirty(false);
	}
	public void setSelection( @Named(IServiceConstants.ACTIVE_SELECTION) Dressing contact) {
		  if (contact == null) {
		    /* implementation not shown */
		  } else {
		    /* implementation not shown */
		  }
		}
	protected void activateAllParts() {
		MPart partt=null;
		for(MPart part:partService.getParts()) {
			partService.activate(part);
			if(part.getElementId().equalsIgnoreCase("dressing.part.prview"))
				partt=part;
			
		}
		if(partt!=null)
		{
			partService.activate(partt,true);
		}
	}
}

