package dressing.ui.library;

import java.util.List;

import javax.inject.Inject;

import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;

import dressing.controller.EtagereCreator;
import dressing.model.Caisson;
import dressing.model.CaissonCuisine;
import dressing.model.Cuisine;
import dressing.model.DesignException;
import dressing.model.DesignObject3D;
import dressing.model.Space3D;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.EtagereType;
import dressing.model.types.PieceType;
import dressing.model.types.EtagereReferenceType;

public class ImportModelWizard extends Wizard {
	@Inject
	IEclipseContext eclipsecontext;

	@Inject
	private EHandlerService handlerService;

	@Inject
	private ECommandService commandService;
	Cuisine cuisine;
	ImportModelWelcomePage welcomePage;

	public Cuisine getCuisine() {
		return cuisine;
	}

	public void setCuisine(Cuisine caisson) {
		this.cuisine = caisson;
	}

	public ImportModelWizard() {
		super();
		setWindowTitle("Importer un caisson");
	}

	@Override
	public void addPages() {
		welcomePage = new ImportModelWelcomePage("Welcome Page", cuisine);
		addPage(welcomePage);
		
		
	}

	@Override
	public boolean performFinish() {
		for (IWizardPage page : getPages()) {
			((WizardPage) page).setErrorMessage("");
		}
		try {
			//
		Cuisine cuisine= getCuisine();
		Space3D caisson=(Space3D) welcomePage.getCaisson().clone();
		caisson.setName(welcomePage.getCaissonName());
		if(caisson.getParams()==null || caisson.getParams().isEmpty()) {
			caisson.setParentdesign(welcomePage.getCaisson().getParentdesign());
			caisson.fillParams();
		}		
		caisson.setParentdesign(cuisine);
		cuisine.addElement(caisson);
		caisson.constructDebitage();
		caisson.evaluate();
		//caisson.createUsinage();
		
		welcomePage.clearlistners();
		} catch (DesignException | GeometricEngineException e) {
			for (IWizardPage page : getPages()) {
				((WizardPage) page).setErrorMessage(e.getMessage());
				e.printStackTrace();
			}
			return false;
		}
		return true;

	}

	@Override
	public boolean canFinish() {
		if (!welcomePage.isPageComplete())
			return false;
		
		return true;
	}

}
