package dressing.ui;

import org.eclipse.jface.viewers.IStructuredSelection;

import com.badlogic.gdx.math.Vector3;

import dressing.mathutils.Vector4;
import dressing.model.Space3DFree;
import dressing.ui.engine3d.SceneTexture;
import gdxapp.object3d.KitchenElement;
import gdxapp.object3d.Wall;
import gdxapp.object3d.WorldObject;
import gdxapp.object3d.WorldObject.ObjectType;
import param.MechanicPublicParam;

public class ChangeTextureCommand implements ChangeCommand {
	public static final int TEXTURE_WALL=1;
	public static final int TEXTURE_FACADE=2;
	public static final int TEXTURE_MARBLE=3;
	public static final int TEXTURE_BOX=4;
	public static final int TEXTURE_CACHE_BAS=5;

	String name;
	String description;
	int typeTexture=0;
	SceneTexture oldTexture;
	SceneTexture newTexture;
	WorldObject target;

	public ChangeTextureCommand(String name, String description, int typeTexture, SceneTexture oldTexture,
			SceneTexture newTexture, WorldObject target) {
		super();
		this.name = name;
		this.description = description;
		this.typeTexture = typeTexture;
		this.oldTexture = oldTexture;
		this.newTexture = newTexture;
		this.target = target;
	}

	@Override
	public void redo() {
		if(target!=null){
			switch (typeTexture) {
			case TEXTURE_FACADE:
				if(target instanceof KitchenElement)
				{
					 ((KitchenElement) target).setFacadeTexture(newTexture);	
				}
				break;
			case TEXTURE_BOX:
				if(target.getType().equals(ObjectType.DEFINED))
				{
					((KitchenElement) target).setBoxTexture(newTexture);	
				}
				break;	

			default:
				break;
			}
			target.setRequireRefrech(true);
			
		}

	}

	@Override
	public void verify() {
		// TODO Auto-generated method stub

	}

	@Override
	public void undo() {
		if(target!=null){
			switch (typeTexture) {
			case TEXTURE_FACADE:
				if(target.getType().equals(ObjectType.DEFINED))
				{
					((KitchenElement) target).setFacadeTexture(oldTexture);	
				}
				break;
			case TEXTURE_BOX:
				if(target.getType().equals(ObjectType.DEFINED))
				{
					((KitchenElement) target).setBoxTexture(oldTexture);	
				}
				break;	

			default:
				break;
			}
			target.setRequireRefrech(true);
		}
	}

	public String getID() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public WorldObject getTarget() {
		return target;
	}

	public void setTarget(WorldObject target) {
		this.target = target;
	}
	
	@Override
	public void dispose() {
		name=null;
		description=null;
		oldTexture=null;
		newTexture=null;
		target=null;
		
	}
}
