package dressing.model.persistence.dpos;

import gdxapp.object3d.GeometryObject;
import gdxapp.object3d.WorldObject.ObjectType;
import geometry.CompoundObject;
import jakarta.xml.bind.annotation.XmlRootElement;


@XmlRootElement(name="Geometry")
public class GeometryDPO extends Object3D implements DPO<GeometryObject>{
	
	protected CompoundObject geometry;
		
	public GeometryDPO() {}
	
	public GeometryObject getWorldActor() {
		GeometryObject geometry = new GeometryObject();
		geometry.setType(ObjectType.POLY);
		geometry.setGeometry(this.geometry);
		geometry.setRealWorldDimension(this.dimension);
		geometry.setRealWorldPosition(this.position);
		geometry.setRotation(this.rotation);
		geometry.setProperties(this.properties);
		geometry.setStaticobject(this.staticObject);
		return geometry;
	}

	public CompoundObject getGeometry() {
		return geometry;
	}

	public void setGeometry(CompoundObject geometry) {
		this.geometry = geometry;
	}

	@Override
	public DPO<GeometryObject> from(GeometryObject entity) {
		super.set(entity);
		setGeometry(entity.getGeometry());
		return this;
	}

	@Override
	public GeometryObject get() {
		GeometryObject geometryObject = new GeometryObject();
		geometryObject.setGeometry(this.geometry);
		geometryObject.setSceneId(sceneID);
		geometryObject.setType(objectType);
		geometryObject.setRotation(rotation);
		geometryObject.setRealWorldPosition(position);
		geometryObject.setRealWorldDimension(dimension);
		return geometryObject;
	}
}
