package dressing.model;

import static org.junit.Assert.assertEquals;

import dressing.controller.CaissonCreator;
import dressing.controller.Piece2DCreator;
import dressing.model.evalutor.GeometricEngineException;
import dressing.model.types.CaissonMontageType;
import dressing.model.types.CaissonType;
import dressing.model.types.DosType;
import dressing.model.types.IntersectionType;
import dressing.model.types.PieceType;
import dressing.model.types.PortType;
import dressing.model.types.PositionCalculationType;
import dressing.model.types.PositionReferenceType;
import dressing.model.types.SeprationAxe;
import utils.ParametersProvider;
import utils.ParametersUtils;
import utils.TestModelProvider;

public class Plan3D {

	Point3D[] extremes=new Point3D[8];

	Intervale xinter;
	Intervale yinter;
	Intervale zinter;
	
	public Point3D[] getExtremes() {
		return extremes;
	}

	public Intervale getXinter() {
		return xinter;
	}

	public void setXinter(Intervale xinter) {
		this.xinter = xinter;
	}

	public Intervale getYinter() {
		return yinter;
	}

	public void setYinter(Intervale yinter) {
		this.yinter = yinter;
	}

	public Intervale getZinter() {
		return zinter;
	}

	public void setZinter(Intervale zinter) {
		this.zinter = zinter;
	}

	public void setExtremes(Point3D[] extremes) {
		this.extremes = extremes;
	}

	public Plan3D(Point3D[] extremes) {
		super();
		initializeIntervales(extremes);
	}
	
	public Plan3D() {
		super();
		// TODO Auto-generated constructor stub
	}

	public Plan3D(Intervale xinter, Intervale yinter, Intervale zinter) {
		super();
		this.xinter = xinter;
		this.yinter = yinter;
		this.zinter = zinter;
	}

	public Plan3D(DesignObject3D obj) {
		
		obj.redifinePoints();
		this.extremes=obj.extremes;
		initializeIntervales(extremes);
	}
	public void initializeIntervales(Point3D[] extremes) {
		this.extremes = extremes;
		double xmax=this.extremes[0].getX();
		double xmin=this.extremes[0].getX();
		double ymax=this.extremes[0].getY();
		double ymin=this.extremes[0].getY();
		double zmax=this.extremes[0].getZ();
		double zmin=this.extremes[0].getZ();

		if(this.extremes!=null) {
			for(Point3D point:this.extremes ) {
				//determine xmax& xmin
				if(point.getX()>xmax) {
					xmax=point.getX();
				}
				if(point.getX()<xmin) {
					xmin=point.getX();
				}
				//determine ymax& ymin
				if(point.getY()>ymax) {
					ymax=point.getY();
				}
				if(point.getY()<ymin) {
					ymin=point.getY();
				}
				//determine zmax& zmin
				if(point.getZ()>zmax) {
					zmax=point.getZ();
				}
				if(point.getZ()<zmin) {
					zmin=point.getZ();
				}
								
			}
			this.xinter=new Intervale(xmin, true, xmax, true);
			this.yinter=new Intervale(ymin, true, ymax, true);
			this.zinter=new Intervale(zmin, true, zmax, true);

		}
	}
	
	public Plan3D getIntersection(Plan3D plan) {
		
		Intervale xintersection=getXinter().getintersection(plan.getXinter());
		Intervale yintersection=getYinter().getintersection(plan.getYinter());
		Intervale zintersection=getZinter().getintersection(plan.getZinter());
		return new Plan3D(xintersection,yintersection,zintersection);
	}
	public IntersectionType isIntersect(Plan3D planche2){
		
		Plan3D intersection=this.getIntersection(planche2);
		if(intersection.getXinter()==null || intersection.getYinter()==null|| intersection.getZinter()==null) {
			return IntersectionType.NOT_RELATED;
		}else {
			if(intersection.getXinter().isPoint() || intersection.getYinter().isPoint()|| intersection.getZinter().isPoint())
			return IntersectionType.TANGENT;
		}
		return IntersectionType.INTERSECTION;
		 
	}
	public static IntersectionType getPlan3DType(Plan3D intersection){
		
		if(intersection.getXinter()==null || intersection.getYinter()==null|| intersection.getZinter()==null) {
			return IntersectionType.NOT_RELATED;
		}else {
			if(intersection.getXinter().isPoint() || intersection.getYinter().isPoint()|| intersection.getZinter().isPoint())
			return IntersectionType.TANGENT;
		}
		return IntersectionType.INTERSECTION;
		 
	}
	public double getSize() {
		double size=0;
		if(xinter!=null ) {
			size=xinter.getlong();	
		}
		if(yinter!=null) {
			if(size==0) {
				size=yinter.getlong();
			}else {
				size*=yinter.getlong();
			}
		}
		if(zinter!=null) {
			if(size==0) {
				size=zinter.getlong();
			}else {
				size*=zinter.getlong();
			}
		}
		return size;
	}
	 public static void main(String[] args) {
		 Intervale inter1=new Intervale(3, true, 10, true);
		 Intervale inter2=new Intervale(5, true, 7, true);		 
		 System.out.println("intervale intersection(expected:5-7) :"+inter1.getintersection(inter2).toString());
		 
		 
		 Intervale inter3=new Intervale(6, true, 10, true);
		 Intervale inter4=new Intervale(5, true, 7, true);		 
		 System.out.println("intervale intersection(expected:6-7) :"+inter3.getintersection(inter4).toString());

		 Intervale inter5=new Intervale(7, true, 10, true);
		 Intervale inter6=new Intervale(5, true, 7, true);
		 System.out.println("intervale intersection(expected:7-7) :"+inter5.getintersection(inter6).toString());

		 Intervale inter7=new Intervale(7.1, true, 10, true);
		 Intervale inter8=new Intervale(5, true, 7, true);
		 System.out.println("intervale intersection(expected:null) :"+inter7.getintersection(inter8));

		 //
		ProjectParent parent = null;
		Project3D project3d = null;
		Dressing dressing = null;
		CaissonCreator caisson = null;
		Piece2DCreator piece2dCreator = null;
		Materiaux mdf18;
		Materiaux mdf5;
		final double LONGEUR = 3000;
		final double HAUTEUR = 2500;
		final double PROFONDEUR = 650;
		TestModelProvider modelprovider = new TestModelProvider();
		mdf18 = (Materiaux) modelprovider.getMateriallist().get(0);
		mdf5 = (Materiaux) modelprovider.getMateriallist().get(1);
		ParametersProvider paramsprovider = new ParametersProvider();
		paramsprovider.fillparamList();
		parent = ModelProvider.RootInstance();
		parent.getProjects().clear();
		project3d = new Project3D();
		parent.addProject(project3d, false);

		dressing = new Dressing();

		dressing.setAppartement("appartement");
		dressing.setEtage("etage");
		dressing.setName("dressing");
		dressing.setChantier(project3d.getName());
		//
		dressing.setHauteurext(HAUTEUR);
		dressing.setLongeurext(LONGEUR);
		dressing.setProfondeurext(PROFONDEUR);
		dressing.setBasematerial(mdf18);
		dressing.setBackmaterial(mdf5);
		dressing.setPorttype(PortType.FRANCAISE);
		dressing.setCaissonmontageType(CaissonMontageType.CAISSON_MONTAGE_I);
		dressing.setDostype(DosType.DOSINTERIEUR);
		dressing.setParentdesign(project3d);

		try {
			dressing.constructDebitage();
			dressing.evaluate();
			project3d.addElement(dressing);
		} catch (DesignException | GeometricEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		//
		caisson = new CaissonCreator();
		caisson.setName("caisson");
		caisson.setBackmaterial(mdf5);
		caisson.setBasematerial(mdf18);
		caisson.setLongeur(LONGEUR);
		caisson.setHauteur(HAUTEUR);
		caisson.setProfondeur(PROFONDEUR);
		caisson.setParent(dressing);
		caisson.setCuissontype(CaissonType.MONO_CAISSON);
		caisson.setPorttype(PortType.FRANCAISE);
		caisson.setDostype(DosType.DOSINTERIEUR);
		caisson.setCaissonMontageType(CaissonMontageType.CAISSON_MONTAGE_I);
		try {
			caisson.create();
			dressing.addElement(caisson.getCaissonInstance());
		} catch (DesignException | GeometricEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		piece2dCreator=new Piece2DCreator();
		piece2dCreator.setBackmaterial(mdf5);
		piece2dCreator.setBasematerial(mdf18);
		piece2dCreator.setParent(caisson.getCaissonInstance());
		
		PieceType piecetype = PieceType.SEPRATEUR_NORMAL;
		piece2dCreator.setPiecetype(piecetype);
                         
		assertEquals(piecetype,piece2dCreator.getPiecetype());
    	double separationposition = 200;
		piece2dCreator.setSeparationposition(separationposition);
                         
		assertEquals(separationposition,piece2dCreator.getSeparationposition(),ParametersUtils.epsilon);
    	SeprationAxe seprationaxe = SeprationAxe.YAXIS;
		piece2dCreator.setSeprationaxe(seprationaxe);
                         
		assertEquals(seprationaxe,piece2dCreator.getSeprationaxe());
    	boolean isSepIsometrique = true;
		piece2dCreator.setIsSepIsometrique(isSepIsometrique);
                         
		assertEquals(isSepIsometrique,piece2dCreator.getIsSepIsometrique());
    	PositionReferenceType sepPosRefType = PositionReferenceType.BAS;
		piece2dCreator.setSepPosRefType(sepPosRefType);
                         
		assertEquals(sepPosRefType,piece2dCreator.getSepPosRefType());
    	PositionCalculationType positionCalculationType = PositionCalculationType.FIX;
		piece2dCreator.setPositionCalculationType(positionCalculationType);
                         
		assertEquals(positionCalculationType,piece2dCreator.getPositionCalculationType());
    	double sepRetrait = 50;
		piece2dCreator.setSepRetrait(sepRetrait);
                         
		assertEquals(sepRetrait,piece2dCreator.getSepRetrait(),ParametersUtils.epsilon);
    	double sepretraitderiere = 100;
		piece2dCreator.setSepretraitderiere(sepretraitderiere);
                         
		assertEquals(sepretraitderiere,piece2dCreator.getSepretraitderiere(),ParametersUtils.epsilon);
    	Materiaux material = mdf18;
		piece2dCreator.setMaterial(material);
		
		try {
			piece2dCreator.create();
		} catch (DesignException | GeometricEngineException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Piece2D pdroite=new Piece2D();
		Piece2D phaut=new Piece2D(); 
		for(DesignObject3D piece:caisson.getCaissonInstance().getChilds()) {
			if(piece instanceof Piece2D ) {
				if(((Piece2D)piece).getPiecetype().equals(PieceType.DROITE_CUISSON)) {
					pdroite=(Piece2D) piece;
				}
				if(((Piece2D)piece).getPiecetype().equals(PieceType.HAUT_CUISSON)) {
					phaut=(Piece2D) piece;
				}
			}
		}
		Plan3D ppdroite=new Plan3D(pdroite);
		Plan3D pphaut=new Plan3D(phaut);
		
		Plan3D intersection=ppdroite.getIntersection(pphaut);
		System.out.println(intersection.getXinter());
		System.out.println(intersection.getYinter());
		System.out.println(intersection.getZinter());

	 }

	 
	 public boolean contains(Plan3D cyl) {
		 boolean iscontainsX=getXinter().contains(cyl.getXinter());
		 boolean iscontainsY=getYinter().contains(cyl.getYinter());
		 boolean iscontainsZ=getZinter().contains(cyl.getZinter());

		 return iscontainsX && iscontainsY && iscontainsZ;
	 }
	 
}
