package dressing.model;


import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

import dressing.model.evalutor.GeometricEngineException;
import tech.frsdev.solids.Solide3D;



public class ModelPackageProject3D  extends Project3D{

	public ModelPackageProject3D() {
		// TODO Auto-generated constructor stub
		if(propertyChangeSupport!=null)
		{
			propertyChangeSupport.addPropertyChangeListener(new PropertyChangeListener() {
				
				@Override
				public void propertyChange(PropertyChangeEvent evt) {
					// TODO Auto-generated method stub
					if(evt.getPropertyName().equals("name") || evt.getPropertyName().equals("directory"))
					{
						setFullpath(getDirectory()+"\\"+getName()+getExtension());
					}
				}
			});
		}
		 fillParams();
	}
	

	@Override
	public boolean canHold(DesignObject3D child) {
		// TODO Auto-generated method stub
		if(child instanceof Dressing||child instanceof Cuisine||child instanceof CaissonCuisine||child instanceof Caisson)
			return true;
		return false;
	}
	
	@Override
	public DesignObject3D clone() {
		ModelPackageProject3D space=new ModelPackageProject3D();
		try {
			space=(ModelPackageProject3D) this.copy(space);
		} catch (DesignException | GeometricEngineException | CloneNotSupportedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return space;
	}

}
