package dressing.ui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import dressing.ui.CommandStack;
import dressing.ui.project.WallConfigformComposite;
import gdxapp.object3d.Wall;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class WallSettingWindow extends org.eclipse.jface.window.Window {
	
	
	private WallConfigformComposite wallConfigCmp;
	private Wall wall;
	
	public WallSettingWindow(Shell parentShell, Wall wall) {
		super(parentShell);
		setShellStyle(SWT.SHELL_TRIM| SWT.APPLICATION_MODAL);
		setBlockOnOpen(true);
		this.wall = wall;
	}
	
		
	
	@Override
	protected void handleShellCloseEvent() {
		setReturnCode(CANCEL);
		close();
	}
	

	/**  
	 * Create contents of the window.
	 * @return 
	 */
	protected Control createContents(Composite parent) {
		parent.setTouchEnabled(true);
		getShell().setText("Configuration de Mur");
		getShell().addShellListener(getShellListener());
		//getShell().setSize(600,400);
		getShell().setLayout(new FillLayout());
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout());
		this.wallConfigCmp = new WallConfigformComposite(container, SWT.NONE);
		Composite btnComposite = new Composite(container, SWT.NONE);
		btnComposite.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, false, 1, 1));
		btnComposite.setLayout(new GridLayout(2, false));
		
		Button btnAnnuler = new Button(btnComposite, SWT.NONE);
		btnAnnuler.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				WallSettingWindow.this.close();
			}
		});
		btnAnnuler.setBounds(0, 0, 90, 30);
		btnAnnuler.setText("Annuler");
			
		
		Button btnModifier = new Button(btnComposite, SWT.NONE);
		btnModifier.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				wallConfigCmp.updateWall();
				WallSettingWindow.this.close();
			}
		});
		btnModifier.setText("Modifier");
		setWall(wall);
		getShell().layout(true);
		return getShell();

	}

	public void setWall(Wall wall) {
		this.wallConfigCmp.setWall(wall);
	}
}
