
package dressing.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import dressing.model.DesignObject3D;
import dressing.ui.DesignObject3DComposite;
import dressing.ui.configuration.CustomParametersComposite;

public class CustomParameters {
	Composite dynamiceditor=null;
	@Inject ESelectionService selectionService;
	Object editelement =null;
	Composite parentcomposite=null;


	@Inject
	private MDirtyable dirty;
	/**
	 * Create contents of the view part.
	 */

	@PostConstruct
	public void postConstruct(Composite parent) {

		selectionService.addSelectionListener(new ISelectionListener() {
			
			@Override
			public void selectionChanged(MPart part, Object selection) {
				// TODO Auto-generated method stub
					if(selection instanceof DesignObject3D)
					changeeditortoDefault((DesignObject3D)selection);
				
			}

		});
		
		if(editelement==null)
		{
			parentcomposite = parent;
			dynamiceditor = new Composite(parentcomposite,  SWT.NONE);			
		}


	}
	@PreDestroy
	public void dispose() {
		if(dynamiceditor!= null)
		{
			dynamiceditor.dispose();
			editelement = null;
		}
	}

	@Focus
	public void setFocus() {
		// TODO	Set the focus to control
	}

	private void changeeditortoDefault(DesignObject3D selection)
	{
		if(dynamiceditor!=null && !dynamiceditor.isDisposed() && dynamiceditor instanceof CustomParametersComposite ) {
			((CustomParametersComposite)dynamiceditor).setDesignObject3d((DesignObject3D) selection);
		}else {
			dispose();
			editelement = selection;
			dynamiceditor = new CustomParametersComposite(parentcomposite,  SWT.NONE,(DesignObject3D) editelement);
			dynamiceditor.pack();
			parentcomposite.requestLayout();
		}
		
	}

}